/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.im;

import android.webkit.ValueCallback;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetOriginRespCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.callback.ICheckNeedUpload;
import com.yy.appbase.service.model.NetCheckUpload;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.base.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import org.json.JSONException;
import org.json.JSONObject;

public class ImRepository {
    private static final String TAG = "ImRepository";

    private static String generateUrl(String path) {
        return UriProvider.getIkxdSvrHost() + path;
    }

    public static <T> void searchFriendsWithNick(String nick, int from, int size, final INetRespCallback<T> callback) {
        final JSONObject obj = JsonParser.obtainJSONObject();
        try {
            obj.put("nick", (Object)nick);
            obj.put("from", from);
            obj.put("size", size);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        final HashMap map = new HashMap();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                map.put("data", obj.toString());
                HttpUtil.httpReq((String)ImRepository.generateUrl("/ikxd_search/friend_list"), (Map)map, (int)1, (INetRespCallback)callback);
            }
        });
    }

    public static String getAddFromStr(int from) {
        if (from == 1) {
            return ResourceUtils.getString((int)R.string.from_discovery);
        }
        if (from == 3) {
            return ResourceUtils.getString((int)R.string.from_fb);
        }
        if (from == 4) {
            return ResourceUtils.getString((int)R.string.from_game);
        }
        if (from == 2) {
            return ResourceUtils.getString((int)R.string.from_search);
        }
        if (from == 5) {
            return ResourceUtils.getString((int)R.string.add_from_suggest);
        }
        if (from == 7) {
            return ResourceUtils.getString((int)R.string.add_from_suggest);
        }
        return ResourceUtils.getString((int)R.string.from_default);
    }

    private static String getCheckUrl() {
        return UriProvider.getIkxdSvrHost() + "/addrlist/check";
    }

    private static String getUpLoadUrl() {
        return UriProvider.getIkxdSvrHost() + "/addrlist/upload";
    }

    public static void checkUploadContacts(final ICheckNeedUpload callback) {
        HttpUtil.httpReq((String)ImRepository.getCheckUrl(), null, (int)1, (INetRespCallback)new INetRespCallback<NetCheckUpload>(){

            public void onError(Call call, Exception e, int id2) {
                final String msg = e != null ? e.getMessage() : "on response error";
                MLog.info((Object)ImRepository.TAG, (String)("check upload contact err:" + msg), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onError(1, msg);
                        }
                    }
                });
            }

            public void onResponse(String response, final BaseResponseBean<NetCheckUpload> res, int id2) {
                MLog.info((Object)ImRepository.TAG, (String)("check upload contact resp:" + response), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (res != null && res.isSuccess()) {
                            if (callback != null) {
                                callback.onSuccess((NetCheckUpload)res.data);
                            }
                        } else if (callback != null) {
                            int code = res != null ? res.code : 0;
                            String msg = res != null ? res.message : "res is null";
                            callback.onError(code, msg);
                        }
                    }
                });
            }
        });
    }

    public static void uploadContacts(String data, final ValueCallback<Boolean> callback) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("data", data);
        HttpUtil.httpReq((String)ImRepository.getUpLoadUrl(), param, (int)2, (INetRespCallback)new INetOriginRespCallback(){

            public void onError(Call call, Exception e, int id2) {
                if (callback != null) {
                    callback.onReceiveValue((Object)false);
                }
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                boolean isSucess;
                JSONObject json = null;
                try {
                    json = JsonParser.obtainJSONObject((String)response);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                boolean bl = isSucess = json != null && json.optInt("code") == 1;
                if (callback != null) {
                    callback.onReceiveValue((Object)isSucess);
                }
            }
        });
    }

    public static interface FriendReqStatus {
        public static final int ADD = 0;
        public static final int PENDING = 1;
        public static final int DELETE = 2;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Status {
        }
    }
}

