/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.im;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.ui.dialog.ConfirmDialog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.im.base.R;
import org.json.JSONObject;

public class ImMsgUtils {
    public static GameMessageModel initGameMessageModel(JSONObject payloadJson, int type) {
        return ImMsgUtils.initGameMessageModel(payloadJson, type, 0L);
    }

    public static GameMessageModel initGameMessageModel(JSONObject payloadJson, int type, long serverTime) {
        String gameUrl = payloadJson.optString("gameUrl");
        String gameId = payloadJson.optString("gameId");
        String gameName = payloadJson.optString("gameName");
        long toUserId = payloadJson.optLong("toUserId");
        String toUserName = payloadJson.optString("toUserName");
        String pkId = payloadJson.optString("pkId");
        long fromUserId = payloadJson.optLong("fromUserId");
        long shadowUid = payloadJson.optLong("shadowUserId", 0L);
        int inviteType = payloadJson.optInt("inviteType", 1);
        String teamId = payloadJson.optString("teamId");
        int gameTemplate = payloadJson.optInt("gameTemplate");
        String fromUserAvatar = payloadJson.optString("fromUserAvatar");
        String fromUserName = payloadJson.optString("fromUserName");
        int fromUserSex = payloadJson.optInt("fromUserSex");
        int gameVersion = payloadJson.optInt("gameVersion");
        int gameTimeLimitType = payloadJson.optInt("gameTimeLimitType", 1);
        String infoPayload = payloadJson.optString("infoPayload");
        String roomId = payloadJson.optString("roomId");
        boolean isGoldGame = payloadJson.optBoolean("isGoldGame", false);
        int mImInviteGameSource = payloadJson.optInt("mInviteGameSource", 99);
        int mPrecipitationSource = payloadJson.optInt("mPrecipitation", 0);
        int from = payloadJson.optInt("from", 0);
        GameMessageModel gameMessageModel = new GameMessageModel();
        gameMessageModel.setGameId(gameId);
        gameMessageModel.setGameName(gameName);
        gameMessageModel.setToUserId(toUserId);
        gameMessageModel.setToUserName(toUserName);
        gameMessageModel.setType(type);
        gameMessageModel.setPkId(pkId);
        gameMessageModel.setFromUserId(fromUserId);
        gameMessageModel.setShadowUid(shadowUid);
        gameMessageModel.setIconUrl(gameUrl);
        gameMessageModel.setInviteType(inviteType);
        gameMessageModel.setTeamId(teamId);
        gameMessageModel.setGameTemplate(gameTemplate);
        gameMessageModel.setServerTime(serverTime);
        gameMessageModel.setFromUserAvatar(fromUserAvatar);
        gameMessageModel.setFromUserName(fromUserName);
        gameMessageModel.setFromUserSex(fromUserSex);
        gameMessageModel.setGameVersion(gameVersion);
        gameMessageModel.setGameTimeLimitType(gameTimeLimitType);
        gameMessageModel.setInfoPayload(infoPayload);
        gameMessageModel.setRoomId(roomId);
        gameMessageModel.setGoldGame(isGoldGame);
        gameMessageModel.setFrom(from);
        gameMessageModel.setImGameInviteSource(mImInviteGameSource);
        gameMessageModel.setPrecipitationSource(mPrecipitationSource);
        return gameMessageModel;
    }

    public static Pair<JSONObject, JSONObject> parseMsgJson(String msg) {
        JSONObject msgJson = null;
        JSONObject payloadJson = null;
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            try {
                msgJson = JsonParser.obtainJSONObject((String)msg);
            }
            catch (Exception e) {
                MLog.error((Object)"IImMsgParse", (String)"\u89e3\u6790msg\u51fa\u73b0\u95ee\u9898 msg:%s", (Throwable)e, (Object[])new Object[]{msg});
            }
        } else {
            MLog.error((Object)"IImMsgParse", (String)"msg \u662f\u7a7a\u5b57\u7b26\u4e32", (Object[])new Object[0]);
        }
        if (msgJson != null && msgJson.has("payload")) {
            try {
                String payloadStr = msgJson.optString("payload");
                if (!TextUtils.isEmpty((CharSequence)payloadStr)) {
                    payloadJson = JsonParser.obtainJSONObject((String)payloadStr);
                }
            }
            catch (Exception e) {
                MLog.error((Object)"IImMsgParse", (String)"\u89e3\u6790payload\u51fa\u73b0\u95ee\u9898 msg\uff1a%s", (Throwable)e, (Object[])new Object[]{msg});
            }
        } else {
            MLog.info((Object)"IImMsgParse", (String)"\u6ca1\u6709 payload \u5b57\u6bb5\uff0cmsg :%s", (Object[])new Object[]{msg});
        }
        return new Pair((Object)msgJson, payloadJson);
    }

    public static void showRevokeGuide(Context context) {
        boolean showed = SettingFlags.getBoolean((String)"key_im_revoke_first_guide_tip_showed", (boolean)false);
        if (!showed) {
            new DialogLinkManager(context).showDialog((BaseDialog)ConfirmDialog.newBuilder().canceledOnClickOutside(true).withCloseBtn(false).message((CharSequence)ResourceUtils.getString((int)R.string.tip_im_revoke_guide)).confirmListener(() -> {}).build());
            SettingFlags.setBoolean((String)"key_im_revoke_first_guide_tip_showed", (boolean)true);
        }
    }
}

