/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.desktopredpoint;

import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.module.desktopredpoint.IUnReadHandler;
import com.yy.hiyo.module.desktopredpoint.IUnreadDelegate;
import com.yy.hiyo.module.desktopredpoint.ServerUnreadBean;
import com.yy.hiyo.module.desktopredpoint.UnreadType;
import org.json.JSONException;
import org.json.JSONObject;

public class OtherHandler
implements IUnReadHandler {
    private static final String TAG = "OtherHandler";
    private IUnreadDelegate mDelegate;
    private boolean isTargetUser;

    OtherHandler(IUnreadDelegate iUnreadDelegate) {
        this.mDelegate = iUnreadDelegate;
    }

    @Override
    public void startWatch() {
        this.isTargetUser = true;
    }

    @Override
    public void onReceivePushMsgs(JSONObject jSONObject) {
        block8: {
            if (!this.isTargetUser) {
                return;
            }
            if (jSONObject.has("pushsdk")) {
                try {
                    MLog.debug((Object)TAG, (String)"receive unread msg", (Object[])new Object[0]);
                    JSONObject jSONObject2 = JsonParser.obtainJSONObject((String)jSONObject.optString("pushsdk"));
                    if (!jSONObject2.has("redpoint")) break block8;
                    ServerUnreadBean serverUnreadBean = (ServerUnreadBean)JsonParser.parseJsonObject((String)jSONObject2.optString("redpoint"), ServerUnreadBean.class);
                    MLog.debug((Object)TAG, (String)("receive unread msg," + serverUnreadBean.getType() + " " + serverUnreadBean.getCount() + " " + serverUnreadBean.getMax()), (Object[])new Object[0]);
                    if (serverUnreadBean == null) {
                        return;
                    }
                    this.mDelegate.updateMaxServerUnreadCount(serverUnreadBean.getMax());
                    if (serverUnreadBean.getType() == 1) {
                        this.mDelegate.increaseUnreadCount(UnreadType.SERVER, serverUnreadBean.getCount());
                        return;
                    }
                    if (serverUnreadBean.getType() == 2) {
                        this.mDelegate.setUnreadCount(UnreadType.SERVER, serverUnreadBean.getCount());
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            } else {
                this.mDelegate.increaseUnreadCount(UnreadType.PUSH, 1);
                MLog.debug((Object)TAG, (String)"onReceivePushMsg", (Object[])new Object[0]);
            }
        }
    }
}

