/*
 * Decompiled with CFR 0.152.
 */
package sg.joyy.hiyo.home.module.play.service;

import androidx.annotation.Keep;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.CountryCodeUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\r8F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lsg/joyy/hiyo/home/module/play/service/PlayTabConfig;", "", "()V", "enableGameTabGuide", "", "getEnableGameTabGuide", "()Z", "setEnableGameTabGuide", "(Z)V", "moreFunInParty", "getMoreFunInParty", "setMoreFunInParty", "refreshIntervalMin", "", "getRefreshIntervalMin", "()I", "setRefreshIntervalMin", "(I)V", "tabsOrder", "", "", "getTabsOrder", "()Ljava/util/List;", "setTabsOrder", "(Ljava/util/List;)V", "toString", "Companion", "home-base_debug"})
@Keep
public final class PlayTabConfig {
    @SerializedName(value="tabs_order")
    @NotNull
    private List<String> tabsOrder = CollectionsKt.emptyList();
    @SerializedName(value="refresh_interval_min")
    private int refreshIntervalMin = 2;
    @SerializedName(value="more_fun_in_party")
    private boolean moreFunInParty = true;
    @SerializedName(value="enable_game_tab_guide")
    private boolean enableGameTabGuide;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<String> getTabsOrder() {
        List list;
        if (this.tabsOrder.isEmpty()) {
            MLog.info((Object)"PlayTabConfig", (String)("getTabsOrder: " + CountryCodeUtils.isCountryAmerica()), (Object[])new Object[0]);
            list = CountryCodeUtils.isCountryAmerica() && AccountUtil.getUid() > 0L ? CollectionsKt.listOf((Object[])new String[]{"today", "live", "party", "game"}) : CollectionsKt.listOf((Object[])new String[]{"today", "game", "party", "live"});
        } else {
            list = this.tabsOrder;
        }
        return list;
    }

    public final void setTabsOrder(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.tabsOrder = list;
    }

    public final int getRefreshIntervalMin() {
        return this.refreshIntervalMin <= 0 ? 2 : this.refreshIntervalMin;
    }

    public final void setRefreshIntervalMin(int n) {
        this.refreshIntervalMin = n;
    }

    public final boolean getMoreFunInParty() {
        return this.moreFunInParty;
    }

    public final void setMoreFunInParty(boolean bl) {
        this.moreFunInParty = bl;
    }

    public final boolean getEnableGameTabGuide() {
        return this.enableGameTabGuide;
    }

    public final void setEnableGameTabGuide(boolean bl) {
        this.enableGameTabGuide = bl;
    }

    @NotNull
    public String toString() {
        return "PlayTabConfig(tabsOrder=" + this.getTabsOrder() + ", refreshIntervalMin=" + this.getRefreshIntervalMin() + ", " + "moreFunInParty=" + this.moreFunInParty + ", enableGameTabGuide=" + this.enableGameTabGuide + ')';
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lsg/joyy/hiyo/home/module/play/service/PlayTabConfig$Companion;", "", "()V", "from", "Lsg/joyy/hiyo/home/module/play/service/PlayTabConfig;", "jsonStr", "", "home-base_debug"})
    public static final class Companion {
        @NotNull
        public final PlayTabConfig from(@NotNull String jsonStr) {
            PlayTabConfig playTabConfig;
            Intrinsics.checkParameterIsNotNull((Object)jsonStr, (String)"jsonStr");
            try {
                PlayTabConfig playTabConfig2 = (PlayTabConfig)JsonParser.parseJsonObject((String)jsonStr, PlayTabConfig.class);
                if (playTabConfig2 == null) {
                    playTabConfig2 = new PlayTabConfig();
                }
                playTabConfig = playTabConfig2;
            }
            catch (Exception e) {
                MLog.error((Object)"PlayTabConfig", (String)"parse %s", (Throwable)e, (Object[])new Object[]{jsonStr});
                playTabConfig = new PlayTabConfig();
            }
            return playTabConfig;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

