/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.home.base.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextSwitcher;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.yy.appbase.common.CommonCallback;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.home.base.R;
import com.yy.hiyo.home.base.widget.EntranceActStyle;
import com.yy.hiyo.home.base.widget.OptionActivityLayout;

public class DrawerOptionView
extends YYConstraintLayout {
    private static final float DES_TEXT_SIZE = 10.0f;
    private static String iconFix = YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)24.0f), (int)ResolutionUtils.dip2Px((float)24.0f), (boolean)true);
    private RecycleImageView mLeft;
    private TextView mDesc;
    private View mRedPointView;
    private YYImageView mIvGiftBag;
    private YYTextView mTvRight;
    private YYImageView mTvRightBg;
    private YYTextView mTvRightNew;
    private YYImageView mTvRightBgNew;
    protected TextSwitcher mTsSwitcher = null;
    private OptionActivityLayout mActivityLayout;
    protected ViewStub mSwitcherStub = (ViewStub)this.findViewById(R.id.vs_switcher);
    private View mViewLine;
    public int type = -1;
    private ViewSwitcher.ViewFactory mFactory;
    private View topDivideView;

    public DrawerOptionView(Context context, boolean isNewDrawerPage) {
        super(context);
        this.createView(context, isNewDrawerPage);
    }

    public DrawerOptionView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context, false);
    }

    public DrawerOptionView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context, false);
    }

    public void createView(Context context, boolean isNewDrawerPage) {
        if (!isNewDrawerPage) {
            View.inflate((Context)this.getContext(), (int)R.layout.layout_drawer_item, (ViewGroup)this);
            int padding = ResourceUtils.getDimen((int)R.dimen.drawer_setting_padding);
            this.setBackgroundResource(R.drawable.bg_item_transparent_selector);
            this.setPadding(0, padding, 0, padding);
        } else {
            View.inflate((Context)this.getContext(), (int)R.layout.layout_minepage_item, (ViewGroup)this);
            this.mTvRightNew = (YYTextView)this.findViewById(R.id.tv_right_new);
            this.mTvRightBgNew = (YYImageView)this.findViewById(R.id.tv_right_bg_new);
            this.mViewLine = this.findViewById(R.id.viewLine);
            this.mActivityLayout = (OptionActivityLayout)this.findViewById(R.id.activity_layout);
        }
        this.mLeft = (RecycleImageView)this.findViewById(R.id.drawer_option_left);
        this.mDesc = (TextView)this.findViewById(R.id.drawer_option_desc);
        this.topDivideView = this.findViewById(R.id.view_top_divder);
        this.mRedPointView = this.findViewById(R.id.drawer_tip_red_point);
        this.mIvGiftBag = (YYImageView)this.findViewById(R.id.drawer_tip_gift_bag);
        this.mTvRight = (YYTextView)this.findViewById(R.id.tv_right);
        this.mTvRightBg = (YYImageView)this.findViewById(R.id.tv_right_bg);
        this.mSwitcherStub = (ViewStub)this.findViewById(R.id.vs_switcher);
        this.mTvRight.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        if (ScreenUtils.getInstance().getScreeSizeType() == 1) {
            this.mDesc.setTextSize((float)ResolutionUtils.dip2Px((float)10.0f));
        }
        this.setBackgroundResource(R.drawable.bg_item_transparent_selector);
    }

    public void setLeftIcon(@DrawableRes int iconRes) {
        this.mLeft.setImageResource(iconRes);
    }

    public void setLeftIcon(String iconUrl) {
        ImageLoader.loadImage((ImageView)this.mLeft, (String)(iconUrl + iconFix));
    }

    public void setRedPointVisible(int visible) {
        if (this.mRedPointView != null) {
            this.mRedPointView.setVisibility(visible);
        }
    }

    public boolean isRedPointShow() {
        if (this.mRedPointView != null) {
            return this.mRedPointView.getVisibility() == 0;
        }
        return false;
    }

    public void setGiftBagVisible(int visible) {
        if (this.mIvGiftBag != null) {
            this.mIvGiftBag.setVisibility(visible);
        }
    }

    public void setRightIcon(@DrawableRes int iconRes) {
    }

    public void setCountdownActivity(int countdownTime, CommonCallback callback) {
        if (this.mActivityLayout != null) {
            this.mActivityLayout.setCountdownActivity(countdownTime, callback);
        }
    }

    public void setRightActPic(String url) {
        if (this.mActivityLayout != null) {
            this.mActivityLayout.setRightActPic(url);
        }
    }

    public void setRightActivityIcon(int pictureType, String activityIconUrl, int picWidth, int picHeight) {
        if (this.mActivityLayout != null) {
            this.mActivityLayout.setRightActivityIcon(pictureType, activityIconUrl, picWidth, picHeight);
        }
    }

    public void setRightActivityIcon(@DrawableRes int pictureRes) {
        if (this.mActivityLayout != null) {
            this.mActivityLayout.setRightActivityIcon(pictureRes);
        }
    }

    public void setRightActivityTitle(String title, @EntranceActStyle.Style int actType) {
        if (this.mActivityLayout != null) {
            this.mActivityLayout.setRightActivityTitle(title, actType);
        }
    }

    public void setRightActivityIcon(String url, @DrawableRes int res) {
        if (this.mActivityLayout != null) {
            this.mActivityLayout.setRightActivityIcon(url, res);
        }
    }

    public void setRightActivityHide() {
        if (this.mActivityLayout != null) {
            this.mActivityLayout.setRightActivityHide();
        }
    }

    public void pauseCountdown() {
        if (this.mActivityLayout != null) {
            this.mActivityLayout.pauseCountdown();
        }
    }

    public void resumeCountdown() {
        if (this.mActivityLayout != null) {
            this.mActivityLayout.resumeCountdown();
        }
    }

    public void setRightContent(CharSequence content, boolean rightBgShow) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            this.mTvRight.setVisibility(8);
            this.mTvRightBg.setVisibility(8);
            return;
        }
        if (this.mTsSwitcher != null) {
            this.mTsSwitcher.setVisibility(8);
        }
        this.mTvRight.setVisibility(0);
        this.mTvRightBg.setVisibility(rightBgShow ? 0 : 8);
        this.mTvRight.setText(content);
    }

    private void inflateSwitcher() {
        if (this.mTsSwitcher == null) {
            this.mTsSwitcher = (TextSwitcher)this.mSwitcherStub.inflate();
        }
    }

    public void setSwitcher(@NonNull CharSequence content, int contentIcon) {
        this.inflateSwitcher();
        if (this.mTsSwitcher != null) {
            TextView currentView;
            this.mTsSwitcher.setVisibility(0);
            if (this.mTvRightNew != null) {
                this.mTvRightNew.setVisibility(8);
            }
            if (this.mTvRightBgNew != null) {
                this.mTvRightBgNew.setVisibility(8);
            }
            this.mTvRight.setVisibility(8);
            this.mTvRightBg.setVisibility(8);
            this.buildSwitcherView(contentIcon);
            if (this.mTsSwitcher.getInAnimation() == null) {
                this.mTsSwitcher.setInAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_in_bottom));
            }
            if (this.mTsSwitcher.getOutAnimation() == null) {
                this.mTsSwitcher.setOutAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_top));
            }
            if (!(currentView = (TextView)this.mTsSwitcher.getCurrentView()).getText().equals(content)) {
                this.mTsSwitcher.setText(content);
            }
        }
    }

    public void setSwitcher(@NonNull CharSequence firstContent, final CharSequence secondContent, int contentIcon) {
        this.inflateSwitcher();
        if (this.mTsSwitcher != null) {
            this.mTsSwitcher.setVisibility(0);
            if (this.mTvRightNew != null) {
                this.mTvRightNew.setVisibility(8);
            }
            if (this.mTvRightBgNew != null) {
                this.mTvRightBgNew.setVisibility(8);
            }
            this.buildSwitcherView(contentIcon);
            this.mTsSwitcher.setInAnimation(!TextUtils.isEmpty((CharSequence)secondContent) ? AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_in_bottom) : null);
            this.mTsSwitcher.setOutAnimation(!TextUtils.isEmpty((CharSequence)secondContent) ? AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_top) : null);
            TextView currentView = (TextView)this.mTsSwitcher.getCurrentView();
            if (!currentView.getText().equals(firstContent)) {
                this.mTsSwitcher.setText(firstContent);
            }
            if (!TextUtils.isEmpty((CharSequence)secondContent)) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TextView currentView = (TextView)DrawerOptionView.this.mTsSwitcher.getCurrentView();
                        if (currentView != null && !currentView.getText().equals(secondContent)) {
                            DrawerOptionView.this.mTsSwitcher.setText(secondContent);
                        }
                    }
                }, (long)1600L);
            }
        }
    }

    private void buildSwitcherView(final int rightResId) {
        if (this.mFactory == null) {
            this.mFactory = new ViewSwitcher.ViewFactory(){

                public View makeView() {
                    YYTextView textView = new YYTextView(DrawerOptionView.this.getContext());
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -1);
                    layoutParams.gravity = 0x800005;
                    if (rightResId > 0) {
                        textView.setCompoundDrawablesWithIntrinsicBounds(rightResId, 0, 0, 0);
                        textView.setCompoundDrawablePadding(ResolutionUtils.dip2Px((float)2.0f));
                    }
                    textView.setTextColor(ResourceUtils.getColor((int)R.color.color_1b1b1b));
                    textView.setTextSize(2, 14.0f);
                    textView.setEllipsize(TextUtils.TruncateAt.END);
                    textView.setGravity(17);
                    textView.setMaxLines(1);
                    textView.setTextDirection(5);
                    textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    return textView;
                }
            };
            this.mTsSwitcher.setFactory(this.mFactory);
        } else {
            TextView nextView = (TextView)this.mTsSwitcher.getNextView();
            nextView.setCompoundDrawablesWithIntrinsicBounds(rightResId, 0, 0, 0);
        }
    }

    public void setViewLineVisible() {
        if (this.mViewLine != null) {
            this.mViewLine.setVisibility(8);
        }
    }

    public void setDesc(String desc) {
        if (!TextUtils.isEmpty((CharSequence)desc)) {
            this.mDesc.setText((CharSequence)desc);
        }
    }

    public View getRedPointView() {
        return this.mRedPointView;
    }

    public void addDivide() {
        this.topDivideView.setVisibility(0);
    }
}

