/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.home.base;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.abtest.ABConfig;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.oldab.OAB;
import com.yy.appbase.safelivedata.SafeLiveData;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import java.util.Arrays;
import java.util.List;

public class LiveAbTest
extends SafeLiveData<Boolean> {
    private static final String TAG = "LiveAbTest";
    private ABConfig<IAB> abConfig;
    private List<IAB> matchTypes;
    private boolean isNewAb;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public LiveAbTest(@NonNull ABConfig<IAB> abConfig, IAB ... matchTypes) {
        MLog.info((Object)TAG, (String)"init %s", (Object[])new Object[]{abConfig});
        this.abConfig = abConfig;
        this.matchTypes = Arrays.asList(matchTypes);
        this.isNewAb = this.matchTypes.contains(NAB.A) || this.matchTypes.contains(NAB.B);
        IAB ab = abConfig.getTest();
        if (ab != null) {
            this.postValue(this.matchTypes.contains(ab));
        } else {
            IAB value = this.readPreference();
            MLog.info((Object)TAG, (String)"readPreference %s, value %s", (Object[])new Object[]{abConfig, value});
            if (value != null) {
                this.postValue(this.matchTypes.contains(value));
            } else {
                this.postValue(false);
            }
        }
        this.mBinder.singleBindSourceTo(abConfig);
    }

    @KvoMethodAnnotation(name="test", sourceClass=ABConfig.class)
    void onAbChanged(KvoEventIntent event) {
        MLog.info((Object)TAG, (String)"onAbChanged %s", (Object[])new Object[]{event.source()});
        IAB value = (IAB)event.newValue();
        if (value != null) {
            this.savePreference(value);
        }
    }

    private void savePreference(IAB value) {
        MLog.info((Object)TAG, (String)"savePreference %s", (Object[])new Object[]{value});
        SettingFlags.setIntValue((String)("main_ab_" + this.abConfig.getTestId()), (int)this.abToInt(value));
    }

    @Nullable
    private IAB readPreference() {
        int value = SettingFlags.getIntValue((String)("main_ab_" + this.abConfig.getTestId()), (int)-1);
        return this.intToAb(value);
    }

    private int abToInt(IAB value) {
        if (NAB.A.equals((Object)value) || OAB.A.equals((Object)value)) {
            return 1;
        }
        if (NAB.B.equals((Object)value) || OAB.B.equals((Object)value)) {
            return 2;
        }
        return -1;
    }

    private IAB intToAb(int value) {
        switch (value) {
            case 1: {
                return this.isNewAb ? NAB.A : OAB.A;
            }
            case 2: {
                return this.isNewAb ? NAB.B : OAB.B;
            }
        }
        return null;
    }
}

