/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.general.innerpresenter;

import android.app.Activity;
import android.content.Context;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkDialog;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.MyChannelControlConfig;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.component.extbiz.GuestLimitPresenter;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.invite.channel.VoiceCallInviteHandler;
import com.yy.hiyo.channel.component.invite.online.handler.OnlineInviteHandler;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.general.R;
import com.yy.hiyo.channel.plugins.general.innerpresenter.InviteVoiceCallPresenter;
import com.yy.hiyo.channel.plugins.general.seat.VoiceChatSeatPresenter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004*\u0001\u000b\u0018\u0000 #2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u00012\u00020\u0004:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0006\u0010\u0015\u001a\u00020\u0011J\u001c\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u0016\u0010\u001c\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\"\u0010\u001e\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/yy/hiyo/channel/plugins/general/innerpresenter/InviteVoiceCallPresenter;", "Lcom/yy/hiyo/channel/cbase/context/BaseChannelPresenter;", "Lcom/yy/hiyo/channel/cbase/AbsPage;", "Lcom/yy/hiyo/channel/cbase/context/IChannelPageContext;", "Lcom/yy/hiyo/channel/cbase/context/IHolderPresenter;", "()V", "hasCheckMyRole", "", "hasCheckPermission", "hasPermission", "mSeatObs", "com/yy/hiyo/channel/plugins/general/innerpresenter/InviteVoiceCallPresenter$mSeatObs$1", "Lcom/yy/hiyo/channel/plugins/general/innerpresenter/InviteVoiceCallPresenter$mSeatObs$1;", "myRole", "", "seatState", "addChatView", "", "checkHasPermissionFromNet", "checkHasSeat", "checkMyRole", "clickJoin", "onDataUpdate", "channelId", "", "info", "Lcom/yy/hiyo/channel/base/bean/ChannelDetailInfo;", "onDestroy", "onInit", "mvpContext", "onRoleChanged", "uid", "", "roleType", "updateSeatState", "Companion", "general_release"})
public final class InviteVoiceCallPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IHolderPresenter {
    private boolean hasCheckPermission;
    private boolean hasPermission;
    private int seatState;
    private int myRole = -1;
    private boolean hasCheckMyRole;
    private final mSeatObs.1 mSeatObs = new Observer<List<? extends SeatItem>>(this){
        final /* synthetic */ InviteVoiceCallPresenter this$0;

        public void onChanged(@Nullable List<? extends SeatItem> t) {
            if (t != null) {
                Collection collection = t;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    InviteVoiceCallPresenter.access$setHasCheckPermission$p(this.this$0, true);
                    InviteVoiceCallPresenter.access$setHasPermission$p(this.this$0, true);
                }
            }
            InviteVoiceCallPresenter.access$checkHasPermissionFromNet(this.this$0);
            InviteVoiceCallPresenter.access$addChatView(this.this$0);
            InviteVoiceCallPresenter.access$updateSeatState(this.this$0);
        }
        {
            this.this$0 = $outer;
        }
    };
    @NotNull
    public static final String TAG = "InviteVoiceCallPresenter";
    public static final int STATE_NOT_VALID = 0;
    public static final int STATE_SITABLE = 1;
    public static final int STATE_INVITEABLE = 2;
    public static final int STATE_FULL = 3;
    public static final Companion Companion = new Companion(null);

    public void onInit(@NotNull IChannelPageContext<AbsPage> mvpContext) {
        Intrinsics.checkParameterIsNotNull(mvpContext, (String)"mvpContext");
        super.onInit(mvpContext);
        this.checkMyRole();
        this.checkHasSeat();
    }

    private final void updateSeatState() {
        int n;
        if (!this.hasPermission || this.isDestroyed()) {
            return;
        }
        boolean isInSeat = this.getChannel().getSeatService().isInSeat(AccountUtil.getUid());
        boolean seatFull = this.getChannel().getSeatService().isSeatFullWithLocked();
        if (isInSeat) {
            int chatMode = this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo.openVoiceChatMode;
            n = this.myRole == 15 || this.myRole == 10 || chatMode == 1 && this.myRole == 5 ? (seatFull ? 3 : 2) : 0;
        } else {
            boolean hasUserInSeat = this.getChannel().getSeatService().hasUserInSeat();
            n = hasUserInSeat ? (seatFull ? 3 : 1) : 0;
        }
        this.seatState = n;
        ((VoiceChatSeatPresenter)this.getPresenter(VoiceChatSeatPresenter.class)).updateSeatState(this.seatState, this.myRole);
    }

    private final void checkMyRole() {
        this.getChannel().getRoleService().getMyRole(new IRoleService.IGetRoleCallBack(this){
            final /* synthetic */ InviteVoiceCallPresenter this$0;

            public void onSuccess(@Nullable String channelId, int roleType) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"InviteVoiceCallPresenter", (String)("getMyRole success, channelId:" + channelId + ", roleType:" + roleType), (Object[])new Object[0]);
                }
                InviteVoiceCallPresenter.access$setMyRole$p(this.this$0, roleType);
                InviteVoiceCallPresenter.access$setHasCheckMyRole$p(this.this$0, true);
                InviteVoiceCallPresenter.access$addChatView(this.this$0);
                InviteVoiceCallPresenter.access$updateSeatState(this.this$0);
            }

            public void onError(@Nullable String channelId, int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                MLog.error((Object)"InviteVoiceCallPresenter", (String)("getMyRole error!!! channelId:" + channelId + ", code:" + errorCode + ", msg:" + errorTips + ", e:" + e), (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void checkHasSeat() {
        LiveData seats = ((VoiceChatSeatPresenter)this.getPresenter(VoiceChatSeatPresenter.class)).seats();
        if (seats != null && seats.getValue() != null) {
            Object object = seats.getValue();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (((List)object).isEmpty()) {
                this.hasCheckPermission = true;
                this.hasPermission = true;
            }
        }
        seats.observe((LifecycleOwner)((IChannelPageContext)this.getMvpContext()).getLifecycleOwner(), (Observer)this.mSeatObs);
        this.checkHasPermissionFromNet();
        this.addChatView();
        this.updateSeatState();
    }

    private final void checkHasPermissionFromNet() {
        block1: {
            if (this.hasPermission || this.isDestroyed()) {
                return;
            }
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null || (iServiceManager = (IChannelCenterService)iServiceManager.getService(IChannelCenterService.class)) == null) break block1;
            iServiceManager.getControlConfig(new IChannelCenterService.IGetControlConfigCallBack(this){
                final /* synthetic */ InviteVoiceCallPresenter this$0;

                public void onSuccess(@Nullable MyChannelControlConfig controlConfig) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"InviteVoiceCallPresenter", (String)("checkHasPermissionFromNet success:" + controlConfig), (Object[])new Object[0]);
                    }
                    if (this.this$0.isDestroyed()) {
                        MLog.error((Object)"InviteVoiceCallPresenter", (String)"has destroy!!!", (Object[])new Object[0]);
                        return;
                    }
                    InviteVoiceCallPresenter.access$setHasCheckPermission$p(this.this$0, true);
                    MyChannelControlConfig myChannelControlConfig = controlConfig;
                    if (myChannelControlConfig != null) {
                        if (myChannelControlConfig.canOpenVoiceChat) {
                            InviteVoiceCallPresenter.access$setHasPermission$p(this.this$0, true);
                        }
                    }
                    InviteVoiceCallPresenter.access$addChatView(this.this$0);
                    InviteVoiceCallPresenter.access$updateSeatState(this.this$0);
                }

                public void onError(int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                    MLog.error((Object)"InviteVoiceCallPresenter", (String)("checkHasPermissionFromNet fail:" + errorCode + ", msg:" + errorTips), (Object[])new Object[0]);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    private final void addChatView() {
        if (!this.hasPermission || this.isDestroyed()) {
            return;
        }
        LiveData seats = ((SeatPresenter)this.getPresenter(SeatPresenter.class)).seats();
        Object object = seats;
        if (object != null && (object = (List)object.getValue()) != null) {
            if (object.isEmpty()) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("addChatView empty seat, hasCheckMyRole:" + this.hasCheckMyRole + ", my role:" + this.myRole), (Object[])new Object[0]);
                }
                if (!this.hasCheckMyRole || this.myRole == 1) {
                    return;
                }
            }
        }
    }

    public final void clickJoin() {
        switch (this.seatState) {
            case 1: {
                boolean isCurGuestAndLimitInput = ((GuestLimitPresenter)this.getPresenter(GuestLimitPresenter.class)).isCurGuestAndLimitInput();
                if (isCurGuestAndLimitInput) {
                    ToastUtils.showToast((Activity)((Activity)((IChannelPageContext)this.getMvpContext()).getContext()), (int)R.string.tips_guest_limit_vc, (int)0);
                    return;
                }
                IEnteredChannel iEnteredChannel = this.getChannel();
                if (iEnteredChannel != null && (iEnteredChannel = iEnteredChannel.getPluginService()) != null && (iEnteredChannel = iEnteredChannel.getCurPluginData()) != null) {
                    if (iEnteredChannel.mode == 1) {
                        if (this.myRole == 1 && this.getChannelDetailInfo().baseInfo.voiceEnterMode == 1) {
                            DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)this.getChannel().getContext());
                            OkDialog dialog = new OkDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_voice_enter_mode_1), true, null);
                            dialog.setShowCancel(false);
                            dialogLinkManager.showDialog((BaseDialog)dialog);
                            return;
                        }
                        if (this.myRole != 10 && this.myRole != 15 && this.getChannelDetailInfo().baseInfo.voiceEnterMode == 2) {
                            DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)this.getChannel().getContext());
                            OkDialog dialog = new OkDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_voice_enter_mode_2), true, null);
                            dialog.setShowCancel(false);
                            dialogLinkManager.showDialog((BaseDialog)dialog);
                            return;
                        }
                    }
                }
                if (((GuestLimitPresenter)this.getPresenter(GuestLimitPresenter.class)).isCurGuestAndLimitVoiceChat()) {
                    ToastUtils.showToast((Activity)((Activity)((IChannelPageContext)this.getMvpContext()).getContext()), (int)R.string.tips_limit_guest_join_voice_chat, (int)0);
                    return;
                }
                ChannelTrack.INSTANCE.onVoiceJoinClick();
                ((SeatPresenter)this.getPresenter(SeatPresenter.class)).onSitDown(-1, (Callback)clickJoin.1.INSTANCE);
                break;
            }
            case 2: {
                ((InvitePresenter)this.getPresenter(InvitePresenter.class)).showOnlineInvitePanel((OnlineInviteHandler)new VoiceCallInviteHandler((IChannel)this.getChannel()));
                ChannelTrack.INSTANCE.onVoiceInviteClick();
                break;
            }
            case 3: {
                MLog.error((Object)TAG, (String)"openVoiceChat STATE_FULL", (Object[])new Object[0]);
                if (this.myRole == 10 || this.myRole == 15) {
                    ((InvitePresenter)this.getPresenter(InvitePresenter.class)).showFriendInvitePanel((InvitePresenter.InviteClickListener)clickJoin.2.INSTANCE);
                    ChannelTrack.INSTANCE.onVoiceInviteClick();
                    break;
                }
                ToastUtils.showToast((Context)((Context)((IChannelPageContext)this.getMvpContext()).getContext()), (int)R.string.tips_voice_chat_full);
                break;
            }
            case 0: {
                MLog.error((Object)TAG, (String)"not valid ", (Object[])new Object[0]);
            }
        }
    }

    public void onRoleChanged(@Nullable String channelId, long uid, int roleType) {
        super.onRoleChanged(channelId, uid, roleType);
        if (uid == AccountUtil.getUid()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("on my role change role:" + roleType), (Object[])new Object[0]);
            }
            this.myRole = roleType;
            this.hasCheckMyRole = true;
            this.checkHasPermissionFromNet();
            this.addChatView();
            this.updateSeatState();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        ((SeatPresenter)this.getPresenter(SeatPresenter.class)).seats().removeObserver((Observer)this.mSeatObs);
    }

    public void onDataUpdate(@Nullable String channelId, @Nullable ChannelDetailInfo info) {
        super.onDataUpdate(channelId, info);
        this.updateSeatState();
    }

    public void setContainer(@NotNull YYPlaceHolderView container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        IHolderPresenter.DefaultImpls.setContainer((IHolderPresenter)this, (YYPlaceHolderView)container);
    }

    public static final /* synthetic */ int access$getMyRole$p(InviteVoiceCallPresenter $this) {
        return $this.myRole;
    }

    public static final /* synthetic */ void access$setMyRole$p(InviteVoiceCallPresenter $this, int n) {
        $this.myRole = n;
    }

    public static final /* synthetic */ boolean access$getHasCheckMyRole$p(InviteVoiceCallPresenter $this) {
        return $this.hasCheckMyRole;
    }

    public static final /* synthetic */ void access$setHasCheckMyRole$p(InviteVoiceCallPresenter $this, boolean bl) {
        $this.hasCheckMyRole = bl;
    }

    public static final /* synthetic */ void access$addChatView(InviteVoiceCallPresenter $this) {
        $this.addChatView();
    }

    public static final /* synthetic */ void access$updateSeatState(InviteVoiceCallPresenter $this) {
        $this.updateSeatState();
    }

    public static final /* synthetic */ boolean access$getHasCheckPermission$p(InviteVoiceCallPresenter $this) {
        return $this.hasCheckPermission;
    }

    public static final /* synthetic */ void access$setHasCheckPermission$p(InviteVoiceCallPresenter $this, boolean bl) {
        $this.hasCheckPermission = bl;
    }

    public static final /* synthetic */ boolean access$getHasPermission$p(InviteVoiceCallPresenter $this) {
        return $this.hasPermission;
    }

    public static final /* synthetic */ void access$setHasPermission$p(InviteVoiceCallPresenter $this, boolean bl) {
        $this.hasPermission = bl;
    }

    public static final /* synthetic */ void access$checkHasPermissionFromNet(InviteVoiceCallPresenter $this) {
        $this.checkHasPermissionFromNet();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/yy/hiyo/channel/plugins/general/innerpresenter/InviteVoiceCallPresenter$Companion;", "", "()V", "STATE_FULL", "", "STATE_INVITEABLE", "STATE_NOT_VALID", "STATE_SITABLE", "TAG", "", "general_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

