/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.general.family;

import android.view.View;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.plugins.general.family.MyFamilyController;
import com.yy.hiyo.channel.plugins.general.family.MyFamilyPage;
import com.yy.hiyo.mvp.base.IMvpContext;
import java.util.List;
import net.ihago.channel.srv.mgr.MemberWithStatus;

public class MyFamilyWindow
extends DefaultWindow {
    private MyFamilyPage mPager;

    public MyFamilyWindow(IMvpContext context, UICallBacks uiCallBacks, int page) {
        super(context.getContext(), uiCallBacks, "MyFamily");
        this.mPager = new MyFamilyPage(context, page);
        this.getBarLayer().addView((View)this.mPager);
    }

    public void onDetached() {
        super.onDetached();
    }

    public void onHidden() {
        super.onHidden();
        MLog.info((Object)"MyFamilyWindow", (String)"onHidden", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.BBSMsgDef.CREATE_POST_ENTRANCE_PAGE_SHOWN, (Object)false);
        MyFamilyController.sIsInMyFamilyPage = false;
    }

    public void onShown() {
        super.onShown();
        MLog.info((Object)"MyFamilyWindow", (String)"onShow", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.BBSMsgDef.CREATE_POST_ENTRANCE_PAGE_SHOWN, (Object)true);
        MyFamilyController.sIsInMyFamilyPage = true;
        this.refresh();
    }

    public void refresh() {
        if (MyFamilyController.sCurrentMyFamilyDetailInfo == null || MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo == null) {
            return;
        }
        ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo.gid).getRoleService().getMyRole(new IRoleService.IGetRoleCallBack(){

            public void onSuccess(String channelId, int roleType) {
                if (MyFamilyController.sIsInMyFamilyPage && roleType != MyFamilyController.sCurremtMyFamilyRole && MyFamilyWindow.this.mPager != null) {
                    MyFamilyController.sCurremtMyFamilyRole = roleType;
                    MyFamilyWindow.this.mPager.refresh();
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
            }
        });
    }

    public void setOnlineMember(@Nullable List<MemberWithStatus> member, int totalUser) {
        if (this.mPager != null) {
            this.mPager.setOnlineUser(member, totalUser);
        }
    }

    public boolean onBack() {
        return this.mPager != null && this.mPager.onBack();
    }

    public boolean isTranslucentBar() {
        return true;
    }

    public boolean isDarkMode() {
        return false;
    }

    @Nullable
    public View getNeedOffsetView() {
        return super.getNeedOffsetView();
    }
}

