/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.general.seat;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.intercepter.IMediaIntercepter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.ISeatViewWrapper;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.general.R;
import com.yy.hiyo.channel.plugins.general.seat.FoldAvatarAdapter;
import com.yy.hiyo.channel.plugins.general.seat.VoiceChatSeatPresenter;
import com.yy.hiyo.channel.plugins.general.seat.VoiceSeatView;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VoiceChatSeatViewWrapper
implements ISeatViewWrapper,
View.OnClickListener,
IMediaIntercepter.IInterceptStateChange {
    private static final int FOLD_SHOW_AVATAR_MAX = 3;
    private static final int FOLD_ANIM_DURATION = 10000;
    private static final int BORDER_MARGIN = 0;
    private VoiceSeatView mSeatView;
    private YYTextView mSpreadJoinTv;
    private YYTextView mFoldJoinTv;
    private YYLinearLayout mSpreadLayout;
    private YYLinearLayout mFoldLayout;
    private YYFrameLayout mVoiceOnLayout;
    private YYTextView mVoiceOnView;
    private YYLinearLayout mFoldBtn;
    private RecyclerView mFoldRv;
    private FoldAvatarAdapter mFoldAvatarAdapter;
    private List<SeatItem> mFoldShowList = new ArrayList<SeatItem>();
    private List<SeatItem> mOriginList = new ArrayList<SeatItem>();
    private int mNextShowIndex = -1;
    private boolean isFold = true;
    private int mFoldLeft = 0;
    private View mRoot;
    private int mLastX;
    private int mLastY;
    private boolean mIsMotionMove = false;
    private IChannelPageContext mPageContext;
    private SeatMvp.IView.OnSeatItemListener mListener;
    private VoiceChatSeatPresenter mPresenter;
    private int mSeatState = 0;
    private long mLastUpdateTs = 0L;
    private View.OnTouchListener mOnTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View view, MotionEvent event) {
            if (!VoiceChatSeatViewWrapper.this.isFold) {
                return false;
            }
            switch (event.getAction() & 0xFF) {
                case 0: {
                    VoiceChatSeatViewWrapper.this.mLastX = (int)event.getRawX();
                    VoiceChatSeatViewWrapper.this.mLastY = (int)event.getRawY();
                    VoiceChatSeatViewWrapper.this.mIsMotionMove = false;
                    VoiceChatSeatViewWrapper.this.setDrawableAlpha(153);
                    break;
                }
                case 2: {
                    int dx = (int)event.getRawX() - VoiceChatSeatViewWrapper.this.mLastX;
                    int dy = (int)event.getRawY() - VoiceChatSeatViewWrapper.this.mLastY;
                    int left = view.getLeft() + dx;
                    int top = view.getTop() + dy;
                    if (Math.abs(dx) > ViewConfiguration.getTouchSlop() || Math.abs(dy) > ViewConfiguration.getTouchSlop()) {
                        VoiceChatSeatViewWrapper.this.mIsMotionMove = true;
                    }
                    int maxLeft = VoiceChatSeatViewWrapper.this.getNewMaxLeft();
                    int minLeft = 0;
                    int minTop = ResolutionUtils.dip2Px((float)58.0f);
                    int maxTop = ResolutionUtils.getScreenHeight((Context)VoiceChatSeatViewWrapper.this.mPageContext.getContext()) - ResolutionUtils.dip2Px((float)70.0f) - VoiceChatSeatViewWrapper.this.mFoldLayout.getHeight() - ResolutionUtils.dip2Px((float)24.0f);
                    if (LanguageUtils.isRtl()) {
                        left = VoiceChatSeatViewWrapper.this.getNewMaxLeft() - left;
                        if (left >= minLeft && left <= maxLeft && top >= minTop && top <= maxTop) {
                            VoiceChatSeatViewWrapper.this.setLocation(left, top);
                        }
                    } else if (left >= 0 || top >= 0) {
                        if (left > maxLeft) {
                            left = maxLeft;
                        }
                        if (top > maxTop) {
                            top = maxTop;
                        }
                        if (left < minLeft) {
                            left = minLeft;
                        }
                        if (top < minTop) {
                            top = minTop;
                        }
                        VoiceChatSeatViewWrapper.this.setLocation(left, top);
                    }
                    VoiceChatSeatViewWrapper.this.mLastX = (int)event.getRawX();
                    VoiceChatSeatViewWrapper.this.mLastY = (int)event.getRawY();
                    break;
                }
                case 1: {
                    if (!VoiceChatSeatViewWrapper.this.mIsMotionMove && VoiceChatSeatViewWrapper.this.isFold) {
                        if (!LanguageUtils.isRtl() && (event.getX() < (float)VoiceChatSeatViewWrapper.this.mFoldLayout.getLeft() || event.getX() > (float)VoiceChatSeatViewWrapper.this.mFoldLayout.getRight())) break;
                        if (event.getY() >= (float)VoiceChatSeatViewWrapper.this.mFoldLayout.getTop() && event.getY() <= (float)VoiceChatSeatViewWrapper.this.mFoldJoinTv.getTop() || VoiceChatSeatViewWrapper.this.mSeatState == 3) {
                            VoiceChatSeatViewWrapper.this.showSpread();
                            VoiceChatSeatViewWrapper.this.initSeatViewLocation(false, false);
                        } else if (event.getY() < (float)VoiceChatSeatViewWrapper.this.mFoldLayout.getBottom()) {
                            VoiceChatSeatViewWrapper.this.clickJoin();
                            if (VoiceChatSeatViewWrapper.this.mSeatState == 1) {
                                VoiceChatSeatViewWrapper.this.staticEnvt("voicecall_up_voice_click");
                            }
                        }
                        if (LanguageUtils.isRtl()) {
                            VoiceChatSeatViewWrapper.this.mFoldLeft = ScreenUtils.getInstance().getWidthPixels() - view.getRight() - 0;
                        } else {
                            VoiceChatSeatViewWrapper.this.mFoldLeft = view.getLeft();
                        }
                    }
                    VoiceChatSeatViewWrapper.this.setDrawableAlpha(255);
                    break;
                }
            }
            return true;
        }
    };
    private Runnable mAvatarAnimRunnable = this::doAvatarAnim;

    public VoiceChatSeatViewWrapper(IChannelPageContext pageContext, SeatMvp.IView.OnSeatItemListener listener) {
        this.mPageContext = pageContext;
        this.mListener = listener;
    }

    public void createView(Context context, ViewGroup parent) {
        if (context == null || parent == null) {
            return;
        }
        if (this.mSeatView != null) {
            return;
        }
        this.mRoot = View.inflate((Context)context, (int)R.layout.layout_voice_room_chat_seat, (ViewGroup)parent);
        this.mRoot.setVisibility(4);
        this.mRoot.setOnTouchListener(this.mOnTouchListener);
        this.mSeatView = (VoiceSeatView)parent.findViewById(R.id.voice_seat_view);
        this.mSeatView.setOnSeatItemListener(this.mListener);
        this.mSeatView.setPageContext(this.mPageContext);
        this.mSpreadJoinTv = (YYTextView)parent.findViewById(R.id.spreadJoinTv);
        this.mFoldJoinTv = (YYTextView)parent.findViewById(R.id.foldJoinTv);
        this.mSpreadLayout = (YYLinearLayout)parent.findViewById(R.id.spreadLayout);
        this.mFoldLayout = (YYLinearLayout)parent.findViewById(R.id.foldLayout);
        this.mVoiceOnLayout = (YYFrameLayout)parent.findViewById(R.id.VoiceOnContainer);
        this.mFoldBtn = (YYLinearLayout)parent.findViewById(R.id.foldBtn);
        this.mFoldRv = (RecyclerView)parent.findViewById(R.id.foldRv);
        this.mFoldRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, 0, false));
        this.mFoldAvatarAdapter = new FoldAvatarAdapter(context, this.mFoldShowList);
        this.mFoldRv.setAdapter((RecyclerView.Adapter)this.mFoldAvatarAdapter);
        this.mFoldBtn.setOnClickListener((View.OnClickListener)this);
        this.mSpreadJoinTv.setOnClickListener((View.OnClickListener)this);
        this.mSpreadLayout.setOnClickListener((View.OnClickListener)this);
        this.mPresenter.viewCreated();
        this.mRoot.post(() -> this.seatVisibilityChanged(true));
    }

    private void setDrawableAlpha(int alpha) {
        if (this.mFoldJoinTv == null || this.mSeatState != 1) {
            return;
        }
        for (Drawable drawable2 : this.mFoldJoinTv.getCompoundDrawables()) {
            if (drawable2 == null) continue;
            drawable2.setAlpha(alpha);
        }
    }

    private void initSeatViewLocation(boolean isFold, boolean needChangeTop) {
        int left = isFold ? this.mFoldLeft : 0;
        if (needChangeTop) {
            int top = ResolutionUtils.getScreenHeight((Context)this.mPageContext.getContext()) - ResolutionUtils.dip2Px((float)70.0f) - this.mFoldLayout.getHeight() - ResolutionUtils.dip2Px((float)20.0f);
            this.setLocation(left, top);
        } else {
            this.setLocation(left);
        }
    }

    private void setLocation(int left, int top) {
        if (this.mRoot.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRoot.getLayoutParams();
            layoutParams.setMarginStart(left);
            layoutParams.topMargin = top;
            this.mRoot.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.checkLeft();
        }
    }

    private void setLocation(int left) {
        if (this.mRoot.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRoot.getLayoutParams();
            this.setLocation(left, layoutParams.topMargin);
        }
    }

    public void seatVisibilityChanged(boolean visiable) {
        if (visiable) {
            this.showFold();
            this.mFoldLeft = this.getNewMaxLeft();
            this.initSeatViewLocation(true, true);
        }
    }

    private void showFold() {
        IMediaIntercepter mediaIntercepter;
        this.isFold = true;
        this.mSpreadLayout.setVisibility(8);
        this.mFoldLayout.setVisibility(0);
        IMediaIntercepter iMediaIntercepter = mediaIntercepter = this.mPresenter != null && this.mPresenter.getChannel().getMediaService() != null ? this.mPresenter.getChannel().getMediaService().getMediaIntercepter() : null;
        if (mediaIntercepter != null && mediaIntercepter.isMediaIntercepted((IChannel)this.mPresenter.getChannel())) {
            this.mFoldJoinTv.setVisibility(8);
            this.mVoiceOnLayout.setVisibility(0);
            if (this.mVoiceOnView == null) {
                this.mVoiceOnView = new YYTextView((Context)this.mPageContext.getContext());
                this.mVoiceOnView.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_textroom_play_voice));
                this.mVoiceOnView.setTextSize(1, 11.0f);
                this.mVoiceOnView.setTextColor(ResourceUtils.getColor((int)R.color.color_ffffff));
                this.mVoiceOnView.setGravity(16);
                this.mVoiceOnView.setLayoutParams(new ViewGroup.LayoutParams(-2, ResourceUtils.getDimen((int)R.dimen.voice_on_height)));
                this.mVoiceOnView.setBackgroundResource(R.drawable.voicecall_btn_voice_on);
                this.mVoiceOnView.setPadding(ResourceUtils.getDimen((int)R.dimen.voice_on_left_padding), ResourceUtils.getDimen((int)R.dimen.voice_on_top_padding), ResourceUtils.getDimen((int)R.dimen.voice_on_right_padding), ResourceUtils.getDimen((int)R.dimen.voice_on_top_padding));
                this.mVoiceOnLayout.addView((View)this.mVoiceOnView);
                this.mVoiceOnLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        IMediaIntercepter mediaIntercepter;
                        IMediaIntercepter iMediaIntercepter = mediaIntercepter = VoiceChatSeatViewWrapper.this.mPresenter != null && VoiceChatSeatViewWrapper.this.mPresenter.getChannel().getMediaService() != null ? VoiceChatSeatViewWrapper.this.mPresenter.getChannel().getMediaService().getMediaIntercepter() : null;
                        if (mediaIntercepter != null) {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045439").put("function_id", "voiceon_click"));
                            mediaIntercepter.tryOpenVoiceChat(true, (IChannel)VoiceChatSeatViewWrapper.this.mPresenter.getChannel(), new Runnable(){

                                @Override
                                public void run() {
                                    MLog.info((Object)"VoiceChatSeatViewWrapper", (String)"hasOpenVoice!", (Object[])new Object[0]);
                                }
                            }, null);
                        } else if (RuntimeContext.sIsDebuggable) {
                            throw new RuntimeException("\u6ca1\u6709\u5904\u7406\u8005\uff01");
                        }
                    }
                });
            }
        } else {
            this.mFoldJoinTv.setVisibility(0);
            this.mVoiceOnLayout.setVisibility(8);
        }
        if (mediaIntercepter != null) {
            mediaIntercepter.registerMediaInterceptStateChange((IMediaIntercepter.IInterceptStateChange)this);
        }
    }

    private void showSpread() {
        this.isFold = false;
        this.mSpreadLayout.setVisibility(0);
        this.mFoldLayout.setVisibility(8);
        this.mVoiceOnLayout.setVisibility(8);
        this.staticEnvt("voicecall_pencil_show");
        this.staticEnvt("voicecall_open_pencil_click");
    }

    private void checkLeft() {
        if (null != this.mRoot) {
            this.mRoot.post(() -> {
                long curTs = System.currentTimeMillis();
                if (curTs - this.mLastUpdateTs <= 30L) {
                    return;
                }
                this.mLastUpdateTs = curTs;
                if (LanguageUtils.isRtl()) {
                    if (this.mRoot.getLeft() < 0) {
                        this.setLocation(this.getNewMaxLeft());
                    }
                } else if (this.mRoot.getRight() > ScreenUtils.getInstance().getWidthPixels()) {
                    this.setLocation(this.getNewMaxLeft());
                }
            });
        }
    }

    private int getNewMaxLeft() {
        return ResolutionUtils.getScreenWidth((Context)this.mPageContext.getContext()) - this.mFoldLayout.getWidth() - ResolutionUtils.dip2Px((float)20.0f) - 0;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.foldBtn) {
            this.showFold();
            this.initSeatViewLocation(true, false);
        } else if (v.getId() == R.id.spreadJoinTv) {
            this.clickJoin();
            if (this.mSeatState == 1) {
                this.staticEnvt("voicecall_pencil_up_voice_click");
            }
        }
    }

    public void setOnLayoutChangeListener(View.OnLayoutChangeListener listener) {
    }

    public void startSpeakingAnimation(int position) {
        if (this.mSeatView != null) {
            this.mSeatView.startSpeakAnim(position);
        }
    }

    public void stopSpeakingAnimation(int position) {
        if (this.mSeatView != null) {
            this.mSeatView.stopSpeakAnim(position);
        }
    }

    public int getVisibility() {
        if (this.mSeatView != null) {
            return this.mSeatView.getVisibility();
        }
        return 8;
    }

    public void setVisibility(int visibility) {
        if (this.mSeatView != null) {
            this.mSeatView.setVisibility(visibility);
        }
    }

    public View getRealSeatView() {
        return this.mSeatView;
    }

    public void destroy() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mAvatarAnimRunnable);
    }

    public void updateSeats(List<SeatItem> seatItems) {
        if (null != seatItems) {
            this.mOriginList.clear();
            this.mOriginList.addAll(seatItems);
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mAvatarAnimRunnable);
            this.mFoldShowList.clear();
            if (seatItems.size() > 3) {
                for (int i = 0; i < 3; ++i) {
                    this.mFoldShowList.add(0, seatItems.get(i));
                }
                this.mNextShowIndex = 3;
                YYTaskExecutor.postToMainThread((Runnable)this.mAvatarAnimRunnable, (long)10000L);
            } else {
                this.mFoldShowList.addAll(seatItems);
            }
            this.mFoldAvatarAdapter.notifyDataSetChanged();
        }
        if (this.mSeatView != null) {
            this.mSeatView.setSeatData(seatItems);
        }
        this.checkLeft();
    }

    public void updateSeat(int position, SeatItem data) {
        if (this.mSeatView != null) {
            this.mSeatView.updateSeat(position, data);
        }
    }

    private void doAvatarAnim() {
        if (this.mOriginList.size() <= 3) {
            return;
        }
        this.mFoldShowList.add(0, this.mOriginList.get(this.mNextShowIndex));
        this.mFoldShowList.remove(this.mFoldShowList.size() - 1);
        this.mFoldAvatarAdapter.notifyItemRangeChanged(0, 3);
        YYTaskExecutor.postToMainThread((Runnable)this.mAvatarAnimRunnable, (long)10000L);
        this.mNextShowIndex = this.mNextShowIndex < this.mOriginList.size() - 1 ? ++this.mNextShowIndex : 0;
    }

    public Map<Long, Point> getSeatViewLoaction(boolean isAbsolute) {
        HashMap<Long, Point> realLoctionMap = new HashMap<Long, Point>();
        if (this.mSeatView == null) {
            return realLoctionMap;
        }
        int size = this.mSeatView.getViewSize();
        for (int i = 0; i < size; ++i) {
            int[] loction = new int[2];
            View avator = this.mSeatView.getAvatar(i);
            avator.getLocationInWindow(loction);
            int width = avator.getWidth();
            int hight = avator.getHeight();
            ScreenWrapperUtils.INSTANCE.paraseLocationInWindow(loction);
            loction[0] = loction[0] + width / 2;
            loction[1] = loction[1] + hight / 2;
            long uid = (Long)avator.getTag();
            realLoctionMap.put(uid, new Point(loction[0], loction[1]));
        }
        return realLoctionMap;
    }

    public int getSeatFaceSize() {
        return 0;
    }

    public int[] getSeatViewPosition() {
        return new int[]{(int)this.mSeatView.getX(), (int)this.mSeatView.getY()};
    }

    public void setPresenter(SeatMvp.IPresenter presenter) {
        if (presenter instanceof VoiceChatSeatPresenter) {
            this.mPresenter = (VoiceChatSeatPresenter)presenter;
        }
    }

    public void updateSeatState(int state, int myRole) {
        IMediaIntercepter mediaIntercepter;
        IMediaIntercepter iMediaIntercepter = mediaIntercepter = this.mPresenter != null && this.mPresenter.getChannel().getMediaService() != null ? this.mPresenter.getChannel().getMediaService().getMediaIntercepter() : null;
        if (mediaIntercepter == null || !mediaIntercepter.isMediaIntercepted((IChannel)this.mPresenter.getChannel())) {
            this.mFoldJoinTv.setVisibility(0);
        }
        this.mSpreadJoinTv.setVisibility(8);
        this.mSeatState = state;
        switch (state) {
            case 3: {
                this.mSpreadJoinTv.setVisibility(8);
                if (myRole == 10 || myRole == 15) {
                    this.mFoldJoinTv.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_voicecall_calling));
                    this.mFoldJoinTv.setEnabled(true);
                } else {
                    this.mFoldJoinTv.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_voicecall_calling));
                    this.mFoldJoinTv.setEnabled(false);
                }
                this.setTvDrawableStart((TextView)this.mFoldJoinTv, R.drawable.ico_voicecall_fold_join);
                break;
            }
            case 1: {
                this.mSpreadJoinTv.setVisibility(0);
                this.setTvDrawableTop((TextView)this.mSpreadJoinTv, R.drawable.ico_voicecall_spread_join);
                this.mSpreadJoinTv.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_voicecall_spread_join));
                this.mFoldJoinTv.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_voicecall_fold_join));
                this.mFoldJoinTv.setEnabled(true);
                this.setTvDrawableStart((TextView)this.mFoldJoinTv, R.drawable.icon_voice_join);
                if (!this.isFold) break;
                this.staticEnvt("voicecall_up_voice_show");
                break;
            }
            case 2: {
                this.mSpreadJoinTv.setVisibility(0);
                this.setTvDrawableTop((TextView)this.mSpreadJoinTv, R.drawable.ico_voicecall_spread_invite);
                this.mSpreadJoinTv.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_voicecall_spread_invite));
                this.mFoldJoinTv.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_voicecall_fold_invite));
                this.mFoldJoinTv.setEnabled(true);
                this.setTvDrawableStart((TextView)this.mFoldJoinTv, R.drawable.icon_voice_invite);
                this.staticEnvt("voicecall_invite_show");
                break;
            }
            default: {
                this.mSpreadJoinTv.setVisibility(8);
                this.mFoldJoinTv.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_voicecall_calling));
                this.mFoldJoinTv.setEnabled(false);
                this.setTvDrawableStart((TextView)this.mFoldJoinTv, R.drawable.ico_voicecall_fold_join);
            }
        }
    }

    private void clickJoin() {
        if (null != this.mPresenter) {
            this.mPresenter.clickJoin();
            if (this.mSeatState == 2) {
                this.staticEnvt("voicecall_invite_click");
            }
        }
    }

    private void setTvDrawableTop(TextView textView, int source) {
        Drawable drawableTop = ResourceUtils.getDrawable((int)source);
        textView.setCompoundDrawablesWithIntrinsicBounds(null, drawableTop, null, null);
    }

    private void setTvDrawableStart(TextView textView, int source) {
        Drawable drawableStart = ResourceUtils.getDrawable((int)source);
        textView.setCompoundDrawablesWithIntrinsicBounds(drawableStart, null, null, null);
    }

    private void staticEnvt(String functionId) {
        IEnteredChannel channel;
        if (this.mPresenter != null && (channel = this.mPresenter.getChannel()) != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", functionId).put("room_id", channel.getChannelId()).put("user_role", "" + channel.getRoleService().getMyRoleCache()));
        }
    }

    @Nullable
    public View getItemView(int index) {
        return this.mSeatView.getItemView(index);
    }

    public void onInterceptStateChange() {
        if (this.mFoldLayout == null) {
            return;
        }
        if (this.mFoldLayout.getVisibility() == 8) {
            return;
        }
        this.showFold();
    }
}

