/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.general.family;

import android.app.Dialog;
import android.content.Context;
import android.os.Message;
import android.view.Window;
import androidx.annotation.NonNull;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.plugins.general.R;

public class FamilyJoinDialog
extends Dialog {
    private String mGid;

    public FamilyJoinDialog(@NonNull Context context, String gid) {
        super(context);
        this.mGid = gid;
        this.init();
    }

    private void init() {
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(false);
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        window.setGravity(17);
        this.setContentView(R.layout.dialog_my_family_apply);
        this.findViewById(R.id.dla_close).setOnClickListener(v -> this.dismiss());
        this.findViewById(R.id.dla_ok).setOnClickListener(v -> ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(this.mGid).getRoleService().applyJoin("0", new IRoleService.IJoinApplyCallBack(){

            public void onSuccess(String cId, String applyId, ChannelUser user) {
                FamilyJoinDialog.this.dismiss();
                Message message = Message.obtain();
                message.what = AppbaseMsgDef.ChannelMsgDef.ON_MY_FAMILY_JOIN_SUCCESS;
                MsgDispatcher.getInstance().sendMessage(message);
            }

            public void onFailByMemberReachLimit(String cId) {
                FamilyJoinDialog.this.dismiss();
            }

            public void onFailByJoinedChannelLimit(String cId) {
                FamilyJoinDialog.this.dismiss();
            }

            public void onJoinBanForever(String cId) {
                FamilyJoinDialog.this.dismiss();
            }

            public void onAlreadyJoined(String cId) {
                FamilyJoinDialog.this.dismiss();
            }

            public void onHaveJoinedFamily(String applyCId) {
                FamilyJoinDialog.this.dismiss();
            }

            public void onFailByJoinedLvLimit(String applyCId) {
                FamilyJoinDialog.this.dismiss();
            }

            public void onFailByJoinedFrozeLimit(String applyCId, int leftFrozeTime) {
                FamilyJoinDialog.this.dismiss();
            }

            public void onFailByInOwnerBlackList(String applyCId, String msgTips) {
                FamilyJoinDialog.this.dismiss();
            }

            public void onError(String cId, int errorCode, String errorTips, Exception e) {
                FamilyJoinDialog.this.dismiss();
            }
        }));
    }

    public void show() {
        super.show();
    }
}

