/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.general.family;

import android.os.Message;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.OnlineWithStatusInfo;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.plugins.general.family.MyFamilyWindow;
import com.yy.hiyo.mvp.base.MvpController;
import com.yy.hiyo.proto.ProtoManager;
import java.util.ArrayList;
import java.util.Iterator;
import net.ihago.channel.srv.mgr.MemberWithStatus;

public class MyFamilyController
extends MvpController {
    public static boolean sIsInMyFamilyPage = false;
    public static ChannelDetailInfo sCurrentMyFamilyDetailInfo = null;
    public static int sCurremtMyFamilyRole = 0;
    private MyFamilyWindow mWindow;

    public MyFamilyController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.ChannelMsgDef.OPEN_WINDOW_VIEW_MY_FAMILY) {
            ChannelDetailInfo info;
            sIsInMyFamilyPage = true;
            if (this.mWindow != null) {
                this.mWindowMgr.removeWindow((AbstractWindow)this.mWindow, false);
            }
            sCurrentMyFamilyDetailInfo = info = (ChannelDetailInfo)msg.obj;
            sCurremtMyFamilyRole = msg.arg1;
            this.mWindow = new MyFamilyWindow(this.getMvpContext(), (UICallBacks)this, msg.arg2);
            this.loadMemberData();
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        }
        if (msg.what == AppbaseMsgDef.ChannelMsgDef.CLOSE_WINDOW_VIEW_MY_FAMILY) {
            sIsInMyFamilyPage = false;
            sCurremtMyFamilyRole = 0;
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
        if (msg.what == AppbaseMsgDef.ChannelMsgDef.ON_MY_FAMILY_JOIN_SUCCESS && this.mWindow != null && sIsInMyFamilyPage) {
            this.mWindow.refresh();
        }
    }

    private void loadMemberData() {
        IChannelCenterService service = (IChannelCenterService)ServiceManagerProxy.getInstance().getService(IChannelCenterService.class);
        if (service == null) {
            return;
        }
        ProtoManager.Page page = new ProtoManager.Page();
        page.snap = 0L;
        page.offset = 0L;
        page.limit = 10L;
        service.getChannel(MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo.gid).getRoleService().getChannelOnlineWithStatusUserList(page, new IRoleService.IGetOnlineUserWithStatusListCallBack(){

            private void onFailed() {
                if (MyFamilyController.this.mWindow != null) {
                    MyFamilyController.this.mWindow.setOnlineMember(null, 0);
                }
            }

            public void onSuccess(String channel, ProtoManager.Page resultPage, OnlineWithStatusInfo data) {
                if (data == null) {
                    this.onFailed();
                    return;
                }
                if (MyFamilyController.this.mWindow != null) {
                    int maxSize = 10;
                    Iterator allData = data.getAll().iterator();
                    ArrayList<MemberWithStatus> list = new ArrayList<MemberWithStatus>(10);
                    int count = 0;
                    int removeCount = 0;
                    while (allData.hasNext()) {
                        MemberWithStatus member = (MemberWithStatus)allData.next();
                        if (member.member.uid != AccountUtil.getUid()) {
                            list.add(member);
                            ++count;
                        } else {
                            ++removeCount;
                        }
                        if (count < 10) continue;
                        break;
                    }
                    long totalNum = data.getOnlineTotalNum() - (long)removeCount;
                    MyFamilyController.this.mWindow.setOnlineMember(list, (int)totalNum);
                }
            }

            public void onError(String channel, int errorCode, String errorTips, Exception e) {
                this.onFailed();
            }
        });
    }

    protected boolean onWindowBackKeyEvent() {
        return this.mWindow != null && this.mWindow.onBack() || super.onWindowBackKeyEvent();
    }
}

