/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.wight;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Point;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.EmojiList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.Set;

public class GameEmotionAnimView
extends YYFrameLayout {
    private static final String TAG = "GameEmotionAnimView";
    private static final int MAX_EMOTION_VIEW_NUM = 10;
    private static final int EMOTION_DURATION = 2000;
    private Point[] startPoints = new Point[]{new Point(0, 0)};
    private Point[] endPoints = new Point[]{new Point(-120, 450), new Point(120, 450), new Point(0, 450), new Point(-70, 450), new Point(70, 450), new Point(-50, 450), new Point(50, 450)};
    public static int EmotionWidth = -1;
    public static int EmotionHeight = -1;
    private Map<ValueAnimator, ImageView> emotionItems = new HashMap<ValueAnimator, ImageView>(10);
    private boolean isAttached = false;
    private Random random;
    private Queue<EmotionAnimData> emotionAnimData = new LinkedList<EmotionAnimData>();
    private long lastSendTime = 0L;
    private Runnable showEmotionRunnable = new Runnable(){

        @Override
        public void run() {
            if (GameEmotionAnimView.this.emotionAnimData.isEmpty()) {
                return;
            }
            GameEmotionAnimView.this.removeCallbacks(this);
            try {
                EmotionAnimData data = (EmotionAnimData)GameEmotionAnimView.this.emotionAnimData.poll();
                if (data != null) {
                    GameEmotionAnimView.this.showEmotion(data.mEmojiBean);
                }
            }
            catch (NoSuchElementException e) {
                MLog.error((Object)GameEmotionAnimView.TAG, (Throwable)e);
            }
            if (!GameEmotionAnimView.this.emotionAnimData.isEmpty()) {
                GameEmotionAnimView.this.postDelayed(GameEmotionAnimView.this.showEmotionRunnable, 200L);
            }
        }
    };

    public GameEmotionAnimView(@NonNull Context context) {
        this(context, null);
    }

    public GameEmotionAnimView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        if (EmotionWidth == -1) {
            EmotionWidth = ResolutionUtils.dip2Px((float)80.0f);
            EmotionHeight = ResolutionUtils.dip2Px((float)40.0f);
        }
    }

    public GameEmotionAnimView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void playEmotion(EmojiBean emojiBean) {
        EmotionAnimData data = new EmotionAnimData(emojiBean);
        if (this.emotionAnimData.size() > 10) {
            return;
        }
        long time = SystemClock.uptimeMillis();
        if (time - this.lastSendTime < 100L) {
            return;
        }
        this.lastSendTime = time;
        this.emotionAnimData.add(data);
        if (this.emotionAnimData.size() == 1) {
            this.postDelayed(this.showEmotionRunnable, 200L);
        }
    }

    private void showEmotion(EmojiBean emojiBean) {
        if (emojiBean.getId() < 0 || emojiBean.getId() >= EmojiList.imglist.size()) {
            return;
        }
        if (!this.isAttached) {
            return;
        }
        if (this.random == null) {
            this.random = new Random();
        }
        Point startPoint = this.getStartPointByRandom();
        Point endPoint = this.getEndPointByRandom();
        RecycleImageView imageView = this.createImageViewAndAdd();
        imageView.setImageDrawable(ResourceUtils.getDrawable((int)EmojiList.imglist.get(emojiBean.getId())));
        ValueAnimator anim2 = this.createAnim((View)imageView, startPoint, endPoint);
        anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                View v = (View)GameEmotionAnimView.this.emotionItems.remove(animation);
                if (v != null) {
                    GameEmotionAnimView.this.removeView(v);
                }
            }
        });
        this.emotionItems.put(anim2, (ImageView)imageView);
        anim2.setDuration(2000L);
        anim2.setInterpolator((TimeInterpolator)new LinearInterpolator());
        anim2.start();
    }

    private RecycleImageView createImageViewAndAdd() {
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(EmotionWidth, EmotionHeight);
        lp.gravity = 1;
        RecycleImageView imageView = new RecycleImageView(this.getContext());
        this.addView((View)imageView, (ViewGroup.LayoutParams)lp);
        return imageView;
    }

    private ValueAnimator createAnim(View v, Point start, Point end) {
        PropertyValuesHolder alphaHolder = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f});
        PropertyValuesHolder translationX = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{start.x, end.x + start.x});
        PropertyValuesHolder translationY = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{start.y, end.y + start.y});
        return ObjectAnimator.ofPropertyValuesHolder((Object)v, (PropertyValuesHolder[])new PropertyValuesHolder[]{alphaHolder, translationX, translationY});
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttached = true;
    }

    protected void onDetachedFromWindow() {
        this.isAttached = false;
        if (!this.emotionItems.isEmpty()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onDetachedFromWindow remove emotionItems", (Object[])new Object[0]);
            }
            Set<ValueAnimator> anims = this.emotionItems.keySet();
            ArrayList<ValueAnimator> copyList = new ArrayList<ValueAnimator>();
            copyList.addAll(anims);
            for (ValueAnimator anim2 : copyList) {
                anim2.cancel();
            }
        }
        super.onDetachedFromWindow();
    }

    private Point getStartPointByRandom() {
        return this.startPoints[this.random.nextInt(this.startPoints.length)];
    }

    private Point getEndPointByRandom() {
        return this.endPoints[this.random.nextInt(this.endPoints.length)];
    }

    private static class EmotionAnimData {
        EmojiBean mEmojiBean;

        EmotionAnimData(EmojiBean emojiBean) {
            this.mEmojiBean = emojiBean;
        }
    }
}

