/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.wight;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.framework.core.ui.AbstractWindow;

public abstract class AbsPopView {
    protected Context mContext;
    protected FrameLayout mRoot;
    protected View mContent;
    private boolean mCanceledOnTouchOutside = true;
    private OnDismissListener mDismissListener;
    private boolean mShowing = false;

    public AbsPopView(Context context) {
        this.mContext = context;
        this.mRoot = new YYFrameLayout(context);
        this.mRoot.setBackgroundColor(-1728053248);
        this.mRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AbsPopView.this.mCanceledOnTouchOutside) {
                    AbsPopView.this.dismiss();
                }
            }
        });
        this.mContent = this.createContentView(this.mRoot);
        if (this.mContent != null) {
            this.mContent.setClickable(true);
        }
    }

    public void setBackgroundColor(int color2) {
        this.mRoot.setBackgroundColor(color2);
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        this.mCanceledOnTouchOutside = cancel;
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void setDismissListener(OnDismissListener dismissListener) {
        this.mDismissListener = dismissListener;
    }

    protected abstract View createContentView(FrameLayout var1);

    public void show(AbstractWindow window) {
        if (window == null) {
            return;
        }
        if (this.isShowing()) {
            return;
        }
        window.getExtLayer().addView((View)this.mRoot, -1, -1);
        this.mShowing = true;
    }

    public void dismiss() {
        if (this.mRoot.getParent() != null && this.mRoot.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.mRoot.getParent()).removeView((View)this.mRoot);
        }
        this.mShowing = false;
        if (this.mDismissListener != null) {
            this.mDismissListener.onDismiss();
        }
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

