/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.utils;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class WeakReferenceListHelper {
    public static synchronized <T> boolean isWeakListContainsObject(List<WeakReference<T>> list, T t) {
        for (WeakReference<T> weakReference : list) {
            Object iWeakReference = weakReference.get();
            if (iWeakReference == null || iWeakReference != t) continue;
            return true;
        }
        return false;
    }

    public static synchronized <T> void removeWeakListObject(CopyOnWriteArrayList<WeakReference<T>> list, T t) {
        WeakReference<T> weakReferceObject = null;
        for (WeakReference<T> weakReference : list) {
            Object iWeakReference = weakReference.get();
            if (iWeakReference == null || iWeakReference != t) continue;
            weakReferceObject = weakReference;
        }
        if (weakReferceObject != null) {
            list.remove(weakReferceObject);
        }
    }

    public static synchronized <T> void addWeakListUniqObject(CopyOnWriteArrayList<WeakReference<T>> list, T t) {
        if (list != null && t != null && !WeakReferenceListHelper.isWeakListContainsObject(list, t)) {
            list.add(new WeakReference<T>(t));
        }
    }
}

