/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.utils;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.YYFileUtils;
import com.yy.game.download.GameDownloadUtils;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import java.io.File;

public class Utils {
    public static String getSessionId(long firstUid, long secondUid) {
        StringBuilder sessionIdStr = new StringBuilder("s_");
        long minUid = firstUid >= secondUid ? secondUid : firstUid;
        long maxUid = firstUid <= secondUid ? secondUid : firstUid;
        sessionIdStr.append(minUid).append("_").append(maxUid);
        return sessionIdStr.toString();
    }

    public static void checkGameFileValidOrDelete(GamePlayContext context) {
        GameInfo gInfo = null;
        if (context == null || (gInfo = context.getGameInfo()) == null) {
            return;
        }
        GameInfo finalGInfo = gInfo;
        Runnable runnable2 = () -> {
            String gamePath = GameDownloadUtils.getGameLocalFullPath((BasicGameInfo)finalGInfo);
            File file = new File(gamePath);
            boolean valid = YYFileUtils.checkFileMd5((File)file, (String)finalGInfo.getModulerMd5(), (long)0L);
            if (!valid) {
                GameDownloadUtils.deleteGame((BasicGameInfo)finalGInfo);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"cocosLua", (String)"delete game!!!,info:%s, path:%s", (Object[])new Object[]{finalGInfo, gamePath});
                }
            } else if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"cocosLua", (String)"game is valid,do not delete it, path:%s", (Object[])new Object[]{gamePath});
            }
        };
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)runnable2);
        } else {
            runnable2.run();
        }
    }
}

