/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.utils;

import android.content.Context;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;

public class LogSizeHelper {
    private static final long MAX_SIZE = 0x200000L;
    private boolean hasShowLog = false;
    private long vSize;
    private long dSize;
    private long iSize;
    private long wSize;
    private long eSize;
    private long preSize;
    private static final int prefixLogSize = "2018-11-29 10:36:54.532 21955-22019/com.yy.hiyo D/[GLThread\u00a05128,\u00a0hc\u00a0=\u00a0189377395,\u00a0XXXXXXXXXX]:".getBytes().length;

    public synchronized void appendLog(int property, String log2) {
        if (!RuntimeContext.sIsDebuggable) {
            return;
        }
        if (StringUtils.isNotEmpty((String)log2)) {
            int size = log2.getBytes().length;
            if (2 == property) {
                this.vSize += (long)size;
            } else if (3 == property) {
                this.dSize += (long)size;
            } else if (4 == property) {
                this.iSize += (long)size;
            } else if (5 == property) {
                this.wSize += (long)size;
            } else if (6 == property) {
                this.eSize += (long)size;
            }
            this.preSize += (long)prefixLogSize;
            long total = this.vSize + this.dSize + this.iSize + this.wSize + this.eSize + this.preSize;
            if (total >= 0x200000L && !this.hasShowLog) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"current log size is too big", (int)0);
                this.hasShowLog = true;
                MLog.error((Object)"LogSizeHelper", (String)"game log size too big !!!total:%d ,v:%d, d:%d, i:%d, w:%d, e:%d ,pre:%d", (Object[])new Object[]{total, this.vSize, this.dSize, this.iSize, this.wSize, this.eSize, this.preSize});
            }
        }
    }

    public synchronized void logTotalLogSize() {
        if (!RuntimeContext.sIsDebuggable) {
            return;
        }
        long total = this.vSize + this.dSize + this.iSize + this.wSize + this.eSize + this.preSize;
        MLog.error((Object)"LogSizeHelper", (String)"current game log total size:%d, v:%d, d:%d, i:%d, w:%d, e:%d ,pre:%d", (Object[])new Object[]{total, this.vSize, this.dSize, this.iSize, this.wSize, this.eSize, this.preSize});
    }

    public synchronized void reset() {
        this.hasShowLog = false;
        this.vSize = 0L;
        this.dSize = 0L;
        this.iSize = 0L;
        this.wSize = 0L;
        this.eSize = 0L;
        this.preSize = 0L;
    }
}

