/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.utils;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.game.bean.GameResultWebBean;
import com.yy.hiyo.game.base.GameResultBean;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GameResultHelper {
    private static final String TAG = "GameResultHelper";

    public static GameResultBean pkGameGenResult(GameResultWebBean resultBean, GamePlayContext gamePlayContext) {
        if (resultBean == null || resultBean.getResult() == null || resultBean.getResult().getUsers() == null || resultBean.getResult().getResulttype() == null) {
            ArrayList<String> users = new ArrayList<String>();
            Collection uids = gamePlayContext.getAllUsers();
            long selfUid = AccountUtil.getUid();
            long otherUid = 0L;
            for (UserInfoKS info : uids) {
                if (info.uid != selfUid) {
                    otherUid = info.uid;
                }
                users.add(String.valueOf(info.uid));
            }
            Collections.sort(users);
            ArrayList<String> winners = new ArrayList<String>();
            winners.add(String.valueOf(otherUid));
            Collections.sort(winners);
            ArrayList<String> losers = new ArrayList<String>();
            losers.add(String.valueOf(selfUid));
            Collections.sort(losers);
            GameResultBean.Builder builder = GameResultBean.newBuilder();
            builder.gameID(gamePlayContext.getGameInfo().getGid()).users(users).winners(winners).losers(losers).resultTime(Long.valueOf(System.currentTimeMillis()));
            return builder.build();
        }
        if (resultBean.getResult().getResulttype().equals("not_draw")) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"not_draw", (Object[])new Object[0]);
            }
            if (resultBean.getResult().getWinners() == null) {
                return null;
            }
            List<String> users = resultBean.getResult().getUsers();
            List<String> winners = resultBean.getResult().getWinners();
            if (users != null && users.size() > 0) {
                Collections.sort(users);
            }
            if (winners != null && winners.size() > 0) {
                Collections.sort(winners);
            }
            ArrayList<String> loses = new ArrayList<String>();
            if (users != null && users.size() > 0) {
                for (String id2 : users) {
                    loses.add(id2);
                }
            }
            if (winners != null && winners.size() > 0) {
                loses.removeAll(winners);
            }
            if (loses.size() > 0) {
                Collections.sort(loses);
            }
            GameResultBean.Builder builder = GameResultBean.newBuilder();
            builder.gameID(resultBean.getResult().getGameid()).users(resultBean.getResult().getUsers()).resultTime(Long.valueOf(System.currentTimeMillis())).winners(resultBean.getResult().getWinners()).losers(loses);
            if (resultBean.getExt() != null && StringUtils.isNotEmpty((String)resultBean.getExt().getReason())) {
                builder.exitReason(resultBean.getExt().getReason());
            }
            return builder.build();
        }
        if (StringUtils.equal((String)resultBean.getResult().getResulttype(), (String)"notstart")) {
            Collection uids = gamePlayContext.getAllUsers();
            ArrayList<String> users = new ArrayList<String>();
            for (UserInfoKS info : uids) {
                users.add(String.valueOf(info.uid));
            }
            Collections.sort(users);
            GameResultBean.Builder builder = GameResultBean.newBuilder();
            builder.gameID(resultBean.getResult().getGameid()).users(users).resultTime(Long.valueOf(System.currentTimeMillis())).draw(true);
            if (resultBean.getExt() != null && StringUtils.isNotEmpty((String)resultBean.getExt().getReason())) {
                builder.exitReason(resultBean.getExt().getReason());
            }
            return builder.build();
        }
        Collections.sort(resultBean.getResult().getUsers());
        GameResultBean.Builder builder = GameResultBean.newBuilder();
        builder.gameID(resultBean.getResult().getGameid()).users(resultBean.getResult().getUsers()).resultTime(Long.valueOf(System.currentTimeMillis())).draw(true);
        GameResultWebBean.ResultBean gameResult = resultBean.getResult();
        List<String> scoreList = gameResult.getScore();
        if (scoreList != null) {
            builder.score(scoreList);
        }
        return builder.build();
    }
}

