/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.utils;

import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.StringUtils;
import com.yy.game.utils.GameStateDef;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class GameReportHelper {
    public static final String GAME_ACTION = "hagogame";

    public static synchronized void reportGameInfo(GameModel gameModel, int consume, int from, int reason, int scene, boolean isGoldGame) {
        GameReportHelper.reportGameInfo(gameModel, consume, from, reason, scene, "", isGoldGame);
    }

    public static synchronized void reportGameInfo(GameModel gameModel, int consume, int from, int reason, int scene, String result, boolean isGoldGame) {
        GameInfo gameInfo = gameModel.getGameInfo();
        StatisContent reportMap = new StatisContent();
        if (gameModel.getMyUserInfo() != null) {
            reportMap.put("muid", String.valueOf(gameModel.getMyUserInfo().getUid()));
            reportMap.put("avator", StringUtils.isEmpty((String)gameModel.getMyUserInfo().getAvatar()) ? "" : gameModel.getMyUserInfo().getAvatar());
            reportMap.put("nick", StringUtils.isEmpty((String)gameModel.getMyUserInfo().getNick()) ? "" : gameModel.getMyUserInfo().getNick());
            reportMap.put("sex", gameModel.getMyUserInfo().getSex());
        }
        if (gameModel.getOtherInfo() != null) {
            reportMap.put("tuid", String.valueOf(gameModel.getOtherInfo().getUid()));
        }
        if (gameInfo != null) {
            reportMap.put("gid", gameInfo.getGid());
            reportMap.put("roomid", StringUtils.isEmpty((String)gameModel.getRoomid()) ? "" : gameModel.getRoomid());
        }
        if (gameInfo != null) {
            reportMap.put("game_type", gameInfo.getGameMode());
        }
        if (!StringUtils.isEmpty((String)result)) {
            reportMap.put("game_result", result);
        }
        if (consume >= 0) {
            reportMap.put("consume", consume);
        }
        reportMap.put("gfrom", from);
        reportMap.put("reason", reason);
        reportMap.put("scene", scene);
        reportMap.put("if_coin", isGoldGame ? 1 : 2);
        reportMap.put("act", GAME_ACTION);
        HiidoStatis.reportContent((StatisContent)reportMap);
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            if (scene == 0) {
                String metricReason = "";
                metricReason = reason == GameStateDef.GAME_FINISH_REASON.LOAD_FAIL.value() || reason == GameStateDef.GAME_FINISH_REASON.EXECPTION_FINISH.value() || reason == GameStateDef.GAME_FINISH_REASON.NOT_START.value() || reason == GameStateDef.GAME_FINISH_REASON.OVER_TIME.value() ? String.valueOf(reason) : "0";
                HiidoStatis.reportAppMonitorReturnCode((String)"hygameload/", (long)consume, (String)String.valueOf(metricReason));
            } else if (scene == 1) {
                String metricReason = String.valueOf(reason);
                if (reason == GameStateDef.GAME_FINISH_REASON.FINISH.value()) {
                    metricReason = "0";
                }
                HiidoStatis.reportAppMonitorReturnCode((String)"hygamematch/", (long)consume, (String)metricReason);
            }
        }
    }

    public static void reportCoCosException(int type, String location, String message, String content, String extJson, String gid) {
        StatisContent reportMap = new StatisContent();
        if (StringUtils.isNotEmpty((String)gid)) {
            reportMap.put("sfield", gid);
        }
        reportMap.put("ifield", type);
        if (StringUtils.isNotEmpty((String)message)) {
            reportMap.put("sfieldtwo", message);
        }
        if (StringUtils.isNotEmpty((String)content)) {
            reportMap.put("sfieldthree", content);
        }
        reportMap.put("act", "hagoperf");
        reportMap.put("perftype", "cocos_exception");
        HiidoStatis.reportContent((StatisContent)reportMap);
    }

    public static void reportGameLoad(StatisContent reportMap) {
        reportMap.put("act", "hagogameloaddata");
        HiidoStatis.reportContent((StatisContent)reportMap);
    }

    public static void reportDownStart(StatisContent reportMap) {
        reportMap.put("act", "hagogamedownandstart");
        HiidoStatis.reportContent((StatisContent)reportMap);
    }

    void reportGameInit() {
    }
}

