/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.share;

import android.content.Context;
import android.os.Build;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.okhttp.GraceUtil;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.game.R;
import com.yy.game.share.ICommonShareDownloadCallback;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Response;
import java.io.File;

public final class CommonShareHelper {
    private static final String SHARE_IMG_DIR = "common_share_img";
    private static final String SHARE_IMG_FILE_TMP = "common_share_img_tmp";

    public void downloadImage(String url, final ICommonShareDownloadCallback callback2) {
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        final String imgPath = this.getPath(url);
        if (YYFileUtils.isFileExisted((String)imgPath)) {
            if (callback2 != null) {
                callback2.onSuccess(imgPath);
            }
        } else {
            YYTaskExecutor.execute(() -> {
                String tmpFilePath = this.getTmpPath();
                if (YYFileUtils.isPathExist((String)tmpFilePath)) {
                    YYFileUtils.removeFile((String)tmpFilePath);
                }
                GraceUtil.downloadFile((String)url, (String)tmpFilePath, (Callback)new Callback<File>(){

                    public void onResponse(Call<File> call, Response<File> response) {
                        FeatureLog.e((String)"FTQuicFileDownload", (String)"common share download image sucess", (Object[])new Object[0]);
                        YYTaskExecutor.execute(() -> YYFileUtils.renameFile((String)((File)response.body()).getAbsolutePath(), (String)imgPath), () -> {
                            if (callback2 != null) {
                                callback2.onSuccess(((File)response.body()).getAbsolutePath());
                            }
                        });
                    }

                    public void onFailure(Call<File> call, Throwable e) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.network_error), (int)0);
                        FeatureLog.e((String)"FTSHARECommon", (String)("common share download image error : " + e.getMessage()), (Object[])new Object[0]);
                        FeatureLog.e((String)"FTQuicFileDownload", (String)("common share download image error : " + e.getMessage()), (Object[])new Object[0]);
                    }
                });
            });
        }
    }

    private String getTmpPath() {
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + File.separator + SHARE_IMG_DIR + File.separator + SHARE_IMG_FILE_TMP;
    }

    private String getPath(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        String extensionName = ".jpg";
        int index = url.lastIndexOf(".");
        if (index != -1) {
            extensionName = url.substring(index);
        }
        String fileName = "";
        if (Build.VERSION.SDK_INT <= 21 && SettingFlags.getBoolean((String)"md5string", (boolean)true)) {
            String urlFixed = FileUtils.fixFileName((String)url);
            fileName = "share" + urlFixed + extensionName;
        } else {
            fileName = MD5Utils.getMD5String((String)url) + extensionName;
        }
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + File.separator + SHARE_IMG_DIR + File.separator + fileName;
    }
}

