/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.share;

import android.app.Activity;
import android.content.Context;
import android.os.Message;
import androidx.annotation.NonNull;
import com.yy.appbase.R;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.permission.helper.SimplePermissionListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.game.share.CommonShareData;
import com.yy.game.share.CommonShareMsgDef;
import com.yy.game.share.ICommonShare;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.base.ShareItemClickListener;
import com.yy.socialplatformbase.data.ShareData;
import java.io.File;
import java.io.IOException;

public class CommonShareController
extends DefaultController
implements ISharePage,
ICommonShare {
    private static final String TAG = "CommonShareController";

    public CommonShareController(Environment env) {
        super(env);
    }

    public void handleMessage(final Message msg) {
        super.handleMessage(msg);
        if (msg.what == CommonShareMsgDef.OPEN_COMMON_SHARE_MENU) {
            PermissionHelper.checkStoragePermission((Activity)this.mContext, (IPermissionListener)new SimplePermissionListener(){

                public void onPermissionGranted(@NonNull String[] permission) {
                    if (msg.obj instanceof String) {
                        String jsonParams = (String)msg.obj;
                        CommonShareController.this.parseParams(jsonParams);
                    }
                }
            });
        } else if (msg.what == CommonShareMsgDef.HIDE_COMMON_SHARE_MENU) {
            this.hideShareMenu();
        } else {
            FeatureLog.e((String)"FTSHARECommon", (String)"unable to handle this message.", (Object[])new Object[0]);
        }
    }

    private void parseParams(final String jsonParams) {
        if (StringUtils.isEmpty((String)jsonParams)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTSHARECommon", (String)"json params is empty.", (Object[])new Object[0]);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final CommonShareData shareData = (CommonShareData)JsonParser.parseJsonTye((String)jsonParams, CommonShareData.class);
                if (shareData == null) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTSHARECommon", (String)"parse share data error.", (Object[])new Object[0]);
                    }
                    return;
                }
                String imageUrl = shareData.getImageUrl();
                if (StringUtils.isNotEmpty((String)imageUrl) && !imageUrl.startsWith("http")) {
                    String extPath = FileStorageUtils.getInstance().getTempDir() + File.separator + "shareTmp.png";
                    boolean hasException = false;
                    try {
                        YYFileUtils.copy((File)new File(imageUrl), (File)new File(extPath));
                        shareData.setImageUrl(extPath);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        hasException = true;
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)CommonShareController.TAG, (String)"exception:%b ,copy %s to %s", (Object[])new Object[]{hasException, imageUrl, extPath});
                    }
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CommonShareController.this.openShareMenu(shareData);
                    }
                });
            }
        });
    }

    private void openShareMenu(final CommonShareData shareData) {
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).showShareBottomDialog((ISharePage)this, new ShareItemClickListener(){

            public void onShareItemClick(int channelId) {
                CommonShareController.this.onShareItemClicked(channelId, shareData);
            }
        });
    }

    private void hideShareMenu() {
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).closeShareDialog();
    }

    private void onShareItemClicked(final int channelId, final CommonShareData shareData) {
        boolean hasInstalledSharePlatformApp;
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
        }
        if (!(hasInstalledSharePlatformApp = this.checkSharePlatformAppInstalled(channelId))) {
            return;
        }
        ShortUrlUtil.getShortUrl((String)shareData.getGoToUrl(), (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTSHARECommon", (String)"getShortUrl onSuccess", (Object[])new Object[0]);
                }
                shareData.setGoToUrl(shortUrl);
                CommonShareController.this.share(channelId, shareData);
            }

            public void onError(String input, int code, String msg) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTSHARECommon", (String)"getShortUrl onError: %s", (Object[])new Object[]{msg});
                }
                CommonShareController.this.share(channelId, shareData);
            }
        });
    }

    @Override
    public void share(int channelId, CommonShareData shareData) {
        switch (channelId) {
            case 5: {
                this.shareFacebook(shareData);
                break;
            }
            case 2: {
                this.shareWhatsApp(shareData);
                break;
            }
            case 3: {
                this.shareInstagram(shareData);
                break;
            }
            case 1: {
                this.shareLine(shareData);
                break;
            }
            case 6: {
                this.shareMessenger(shareData);
                break;
            }
            case 9: {
                this.shareVK(shareData);
                break;
            }
            case 10: {
                this.shareCopyLink(shareData);
                break;
            }
            case 0: {
                this.shareOthers(shareData);
                break;
            }
            default: {
                FeatureLog.e((String)"FTSHARECommon", (String)"unable to handle this share type.", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public boolean checkSharePlatformAppInstalled(int channelId) {
        return ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).checkAppNeedInstalledOrToast(channelId);
    }

    private void shareFacebook(CommonShareData shareData) {
        ShareData platformShareData = ShareData.builder().type(2).systemShare(false).title(shareData.getTitle()).text(shareData.getContent()).gotoUrl(shareData.getGoToUrl()).to(2).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(5, platformShareData);
    }

    private void shareWhatsApp(CommonShareData shareData) {
        ShareData platformShareData = ShareData.builder().type(1).systemShare(true).text(shareData.getTitle() + "\n" + shareData.getContent() + "\n" + shareData.getGoToUrl()).imgPath(shareData.getImageUrl()).to(2).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(2, platformShareData);
    }

    private void shareInstagram(CommonShareData shareData) {
        ShareData platformShareData = ShareData.builder().type(1).systemShare(true).text(shareData.getTitle() + "\n" + shareData.getContent() + "\n" + shareData.getGoToUrl()).imgPath(shareData.getImageUrl()).to(2).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(3, platformShareData);
    }

    private void shareLine(CommonShareData shareData) {
        ShareData platformShareData = ShareData.builder().type(0).systemShare(true).text(shareData.getTitle() + "\n" + shareData.getContent() + "\n" + shareData.getGoToUrl()).to(1).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(1, platformShareData);
    }

    private void shareMessenger(CommonShareData shareData) {
        ShareData platformShareData = ShareData.builder().type(2).systemShare(false).title(shareData.getTitle()).text(shareData.getContent()).gotoUrl(shareData.getGoToUrl()).to(1).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(6, platformShareData);
    }

    private void shareVK(CommonShareData shareData) {
        ShareData platformShareData = ShareData.builder().type(2).systemShare(false).title(shareData.getTitle()).text(shareData.getContent()).imgPath(shareData.getImageUrl()).gotoUrl(shareData.getGoToUrl()).to(2).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(9, platformShareData);
    }

    private void shareCopyLink(CommonShareData shareData) {
        ShareData platformShareData = ShareData.builder().type(0).systemShare(true).text(shareData.getTitle() + "\n" + shareData.getContent() + "\n" + shareData.getGoToUrl()).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(10, platformShareData);
    }

    private void shareOthers(CommonShareData shareData) {
        ShareData platformShareData = ShareData.builder().type(0).systemShare(true).text(shareData.getTitle() + "\n" + shareData.getContent() + "\n" + shareData.getGoToUrl()).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(0, platformShareData);
    }

    public String getPageName() {
        return "game_common_share";
    }
}

