/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.report;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.GamePlayInfoDBBean;
import com.yy.appbase.kvomodule.IKvoModule;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.game.gamemodule.base.GamePlayInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.yylite.commonbase.hiido.CalActionDefine;
import com.yy.yylite.commonbase.hiido.HiidoGroupReporter;
import com.yy.yylite.commonbase.hiido.HiidoNormalEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020\u001aJ\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\rH\u0002J(\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ&\u0010*\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020!2\u0006\u0010+\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010-\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020\u0004J\u0016\u0010/\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001cJ \u00100\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\bR\u001a\u0010\u0016\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\b\u00a8\u00061"}, d2={"Lcom/yy/game/report/GameReport;", "", "()V", "gameId", "", "getGameId", "()Ljava/lang/String;", "setGameId", "(Ljava/lang/String;)V", "gameVersion", "getGameVersion", "setGameVersion", "mGamePlayContext", "Lcom/yy/hiyo/game/service/bean/GamePlayContext;", "getMGamePlayContext", "()Lcom/yy/hiyo/game/service/bean/GamePlayContext;", "setMGamePlayContext", "(Lcom/yy/hiyo/game/service/bean/GamePlayContext;)V", "mLastError", "roomId", "getRoomId", "setRoomId", "sessionId", "getSessionId", "setSessionId", "destroy", "", "getStageDuration", "", "gamePlayInfo", "Lcom/yy/game/gamemodule/base/GamePlayInfo;", "getStageName", "stage", "", "initSession", "isFirstPlayCurVersion", "", "gamePlayContext", "reportGameDownload", "url", "code", "dur", "reportGameExit", "type", "reportGameStage", "reportRequestToken", "errMsg", "reportStartRuntime", "reportUnzip", "game_debug"})
public final class GameReport {
    @NotNull
    private String sessionId = "";
    @NotNull
    private String gameId = "";
    @NotNull
    private String roomId = "";
    @NotNull
    private String gameVersion = "";
    @Nullable
    private GamePlayContext mGamePlayContext;
    private String mLastError = "";

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.sessionId = string2;
    }

    @NotNull
    public final String getGameId() {
        return this.gameId;
    }

    public final void setGameId(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.gameId = string2;
    }

    @NotNull
    public final String getRoomId() {
        return this.roomId;
    }

    public final void setRoomId(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.roomId = string2;
    }

    @NotNull
    public final String getGameVersion() {
        return this.gameVersion;
    }

    public final void setGameVersion(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.gameVersion = string2;
    }

    @Nullable
    public final GamePlayContext getMGamePlayContext() {
        return this.mGamePlayContext;
    }

    public final void setMGamePlayContext(@Nullable GamePlayContext gamePlayContext) {
        this.mGamePlayContext = gamePlayContext;
    }

    public final void reportGameStage(@NotNull GamePlayInfo gamePlayInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gamePlayInfo, (String)"gamePlayInfo");
        Integer n = (Integer)gamePlayInfo.getGameStage().getValue();
        if (n == null) {
            n = 1;
        }
        HiidoNormalEvent event = new HiidoNormalEvent("game_play", this.getStageName(n), this.sessionId);
        event.withDimens("d1", this.gameId).withDimens("d2", this.gameVersion).withExtra("ud2", this.roomId).withDimens("d5", this.isFirstPlayCurVersion(this.mGamePlayContext) ? "1" : "0").withDimens("d3", String.valueOf(gamePlayInfo.getInitCode().getValue())).withValue("v1", (Number)this.getStageDuration(gamePlayInfo), CalActionDefine.SUM).withExtra("ud1", this.mLastError);
        HiidoGroupReporter.INSTANCE.reportGroupEvent(event);
        HiidoGroupReporter.INSTANCE.flushEvent(event);
    }

    public final void reportRequestToken(int code, long dur, @NotNull String errMsg) {
        Intrinsics.checkParameterIsNotNull((Object)errMsg, (String)"errMsg");
        HiidoNormalEvent event = new HiidoNormalEvent("game_play_init", "requestToken", this.sessionId);
        event.withDimens("d1", this.gameId).withDimens("d2", this.gameVersion).withExtra("ud2", this.roomId).withDimens("d3", String.valueOf(code)).withValue("v1", (Number)dur, CalActionDefine.SUM);
        CharSequence charSequence = errMsg;
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.mLastError = errMsg;
        }
        HiidoGroupReporter.INSTANCE.reportGroupEvent(event);
        HiidoGroupReporter.INSTANCE.flushEvent(event);
    }

    public static /* synthetic */ void reportRequestToken$default(GameReport gameReport, int n, long l, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        gameReport.reportRequestToken(n, l, string2);
    }

    public final void reportUnzip(int code, long dur, @NotNull String errMsg) {
        Intrinsics.checkParameterIsNotNull((Object)errMsg, (String)"errMsg");
        HiidoNormalEvent event = new HiidoNormalEvent("game_play_init", "unzip", this.sessionId);
        event.withDimens("d1", this.gameId).withDimens("d2", this.gameVersion).withExtra("ud2", this.roomId).withDimens("d3", String.valueOf(code)).withDimens("d5", this.isFirstPlayCurVersion(this.mGamePlayContext) ? "1" : "0").withValue("v1", (Number)dur, CalActionDefine.SUM);
        CharSequence charSequence = errMsg;
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.mLastError = errMsg;
        }
        HiidoGroupReporter.INSTANCE.reportGroupEvent(event);
        HiidoGroupReporter.INSTANCE.flushEvent(event);
    }

    public static /* synthetic */ void reportUnzip$default(GameReport gameReport, int n, long l, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        gameReport.reportUnzip(n, l, string2);
    }

    public final void reportStartRuntime(int code, long dur) {
        HiidoNormalEvent event = new HiidoNormalEvent("game_play_init", "startRuntime", this.sessionId);
        event.withDimens("d1", this.gameId).withDimens("d2", this.gameVersion).withExtra("ud2", this.roomId).withDimens("d3", String.valueOf(code)).withValue("v1", (Number)dur, CalActionDefine.SUM);
        HiidoGroupReporter.INSTANCE.reportGroupEvent(event);
        HiidoGroupReporter.INSTANCE.flushEvent(event);
    }

    private final String getStageName(int stage) {
        switch (stage) {
            case 1: {
                return "init";
            }
            case 3: {
                return "load";
            }
            case 4: {
                return "running";
            }
            case 5: {
                return "exit";
            }
        }
        return "";
    }

    private final long getStageDuration(GamePlayInfo gamePlayInfo) {
        Integer n;
        Integer n2 = n = (Integer)gamePlayInfo.getGameStage().getValue();
        int n3 = 1;
        if (n2 != null && n2 == n3) {
            return gamePlayInfo.getInitDuration();
        }
        Integer n4 = n;
        n3 = 3;
        if (n4 != null && n4 == n3) {
            return gamePlayInfo.getLoadDuration();
        }
        Integer n5 = n;
        n3 = 4;
        if (n5 != null && n5 == n3) {
            return gamePlayInfo.getPlayDuartion();
        }
        return 0L;
    }

    private final boolean isFirstPlayCurVersion(GamePlayContext gamePlayContext) {
        GamePlayContext gamePlayContext2 = gamePlayContext;
        if (gamePlayContext2 != null) {
            GamePlayContext gamePlayContext3 = gamePlayContext2;
            boolean bl = false;
            boolean bl2 = false;
            GamePlayContext playContext = gamePlayContext3;
            boolean bl3 = false;
            GameInfo gameInfo = playContext.getGameInfo();
            IKvoModule iKvoModule = KvoModuleManager.getModule(GameInfoModule.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)iKvoModule, (String)"KvoModuleManager.getModu\u2026meInfoModule::class.java)");
            List list = ((GameInfoModule)iKvoModule).getAllPlayInfos();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"KvoModuleManager.getModu\u2026:class.java).allPlayInfos");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GamePlayInfoDBBean it = (GamePlayInfoDBBean)element$iv;
                boolean bl4 = false;
                GamePlayInfoDBBean gamePlayInfoDBBean = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)gamePlayInfoDBBean, (String)"it");
                if (!Intrinsics.areEqual((Object)gamePlayInfoDBBean.getGameId(), (Object)gameInfo.gid)) continue;
                String string2 = it.getLastVersion();
                GameInfo gameInfo2 = gameInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo2, (String)"gameInfo");
                if (!Intrinsics.areEqual((Object)string2, (Object)gameInfo2.getModulerVer())) continue;
                return false;
            }
        }
        return true;
    }

    public final void reportGameExit(int code, int type, long dur, @NotNull GamePlayInfo gamePlayInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gamePlayInfo, (String)"gamePlayInfo");
        HiidoNormalEvent event = new HiidoNormalEvent("game_play", "exit", this.sessionId);
        HiidoNormalEvent hiidoNormalEvent = event.withDimens("d1", this.gameId).withDimens("d2", this.gameVersion).withExtra("ud2", this.roomId).withDimens("d3", String.valueOf(code)).withDimens("d4", String.valueOf(type));
        Integer n = (Integer)gamePlayInfo.getGameStage().getValue();
        if (n == null) {
            n = -1;
        }
        hiidoNormalEvent.withDimens("d5", String.valueOf(n)).withValue("v1", (Number)dur, CalActionDefine.SUM).withExtra("ud1", this.mLastError);
        HiidoGroupReporter.INSTANCE.reportGroupEvent(event);
        HiidoGroupReporter.INSTANCE.flushEvent(event);
    }

    public final void reportGameDownload(@NotNull String url, int code, long dur, @Nullable GamePlayInfo gamePlayInfo) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        HiidoNormalEvent event = new HiidoNormalEvent("game_play_gameFileDownload", "mainfest", this.sessionId);
        HiidoNormalEvent hiidoNormalEvent = event.withDimens("d1", this.gameId).withDimens("d2", this.gameVersion).withExtra("ud2", this.roomId).withDimens("d3", String.valueOf(code)).withDimens("d4", url);
        Object object = gamePlayInfo;
        if (object == null || (object = ((GamePlayInfo)object).getGameStage()) == null || (object = (Integer)object.getValue()) == null) {
            object = -1;
        }
        hiidoNormalEvent.withDimens("d5", String.valueOf((Integer)object)).withValue("v1", (Number)dur, CalActionDefine.SUM);
        HiidoGroupReporter.INSTANCE.reportGroupEvent(event);
        HiidoGroupReporter.INSTANCE.flushEvent(event);
    }

    public final void destroy() {
        HiidoGroupReporter.INSTANCE.closeSession(this.sessionId);
    }

    public final void initSession() {
        this.sessionId = "" + AccountUtil.getUid() + '_' + System.currentTimeMillis();
    }
}

