/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.porxy;

import android.content.Context;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.service.cocosproxy.IAppNotifyGameFunction;
import com.yy.appbase.service.cocosproxy.IGameCallAppFunction;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gameproxy.GameProxyDef;
import com.yy.game.gameproxy.appcallgame.AppCallGameProxy;
import com.yy.game.porxy.IGameMsgInterface;
import com.yy.hiyo.game.base.GameCallAPPMsgType;
import com.yy.hiyo.game.service.ICocosProxyService;
import com.yy.hiyo.game.service.IGameMessageHandler;
import com.yy.hiyo.game.service.IGameMessageSyncHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class CocosProxyController
extends DefaultController
implements ICocosProxyService {
    private static final String TAG = "CocosProxyController";
    private final ConcurrentHashMap<Integer, IGameCallAppFunction> mGameCallAppFunctionList;
    private final Set<Integer> mNotiySet;
    private final Set<IAppNotifyGameFunction> mNotifyFuntionSet;
    private final ConcurrentHashMap<String, IGameMessageHandler> mGameMessageHandlerMap;
    private final ConcurrentHashMap<String, IGameMessageSyncHandler> mGameMessageSyncHandlerMap;
    private IQueueTaskExecutor mQueueExecutor = YYTaskExecutor.createAQueueExcuter();
    private IGameMsgInterface iGameMsgInterface;

    public CocosProxyController(Environment env, IGameMsgInterface iGameMsgInterface) {
        super(env);
        this.mGameCallAppFunctionList = new ConcurrentHashMap();
        this.mNotiySet = new HashSet<Integer>();
        this.mNotifyFuntionSet = new HashSet<IAppNotifyGameFunction>();
        this.mGameMessageHandlerMap = new ConcurrentHashMap();
        this.mGameMessageSyncHandlerMap = new ConcurrentHashMap();
        this.iGameMsgInterface = iGameMsgInterface;
    }

    public void notify(Notification notification) {
        super.notify(notification);
    }

    public void addGameCallAppFunction(CocosProxyType type, IGameCallAppFunction function) {
        if (type != null && function != null) {
            this.mGameCallAppFunctionList.put(type.getEvent(), function);
        }
    }

    public void removeGameCallAppFunction(CocosProxyType type) {
        if (type != null) {
            this.mGameCallAppFunctionList.remove(type.getEvent());
        }
    }

    public boolean isSupportFunction(int eventType) {
        return this.mGameCallAppFunctionList.containsKey(eventType);
    }

    public synchronized void addGameTypeMessageHandler(IGameMessageHandler handler2) {
        String[] types;
        if (handler2 != null && (types = handler2.supportTypes()) != null && types.length > 0) {
            for (String type : types) {
                this.mGameMessageHandlerMap.put(type, handler2);
            }
        }
    }

    public void removeGameTypeMessageHandler(IGameMessageHandler handler2) {
        String[] types;
        if (handler2 != null && (types = handler2.supportTypes()) != null && types.length > 0) {
            for (String type : types) {
                this.mGameMessageHandlerMap.remove(type);
            }
        }
    }

    public synchronized boolean handleGameTypeMessage(String type, Map<String, Object> msgObj, int tag) {
        MLog.debug((Object)TAG, (String)"gameCallApp type:%s, msgobj:%s, tag: %s", (Object[])new Object[]{type, msgObj != null ? msgObj.toString() : "null", tag});
        IGameMessageHandler handler2 = this.mGameMessageHandlerMap.get(type);
        if (handler2 != null) {
            if (msgObj.containsKey(GameCallAPPMsgType.Companion.getVERSION())) {
                long version = (Long)msgObj.get(GameCallAPPMsgType.Companion.getVERSION());
                if (version == GameCallAPPMsgType.Companion.getVERSION_NUM()) {
                    Object reqJson;
                    Object objectId = msgObj.get("objectId");
                    Long id2 = 0L;
                    if (objectId instanceof Long) {
                        id2 = (Long)objectId;
                    }
                    if ((reqJson = msgObj.get("jsondata")) instanceof String) {
                        handler2.onMessageHandlerV1(type, (String)reqJson, tag, id2);
                        return true;
                    }
                    handler2.onMessageHandlerV1(type, "{}", tag, id2);
                    return true;
                }
            } else {
                handler2.onMessageHandler(type, msgObj, tag);
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public void addGameNotifyFunction(IAppNotifyGameFunction function) {
        if (function != null) {
            this.mNotifyFuntionSet.add(function);
        }
    }

    @Deprecated
    public void removeGameNotifyFunction(IAppNotifyGameFunction function) {
        if (function != null) {
            this.mNotifyFuntionSet.remove(function);
        }
    }

    public void callGameFunction(CocosProxyType type, String resJson) {
        this.callGameFunction(AppCallGameProxy.roomId, AppCallGameProxy.getSingleton().uniqueSeq(), type, resJson);
    }

    public void callGameFunction(String context, CocosProxyType type, Object object) {
        this.callGameFunction(context, AppCallGameProxy.getSingleton().uniqueSeq(), type, object);
    }

    public void callGameFunction(String context, long reqId, CocosProxyType type, String resJson) {
        this.callGameFunction(context, reqId, type, resJson, (Long)0L);
    }

    public void callGameFunction(String context, long reqId, CocosProxyType type, Object object) {
        this.callGameFunction(context, reqId, type, object, (Long)0L);
    }

    public void callGameFunction(String context, long reqId, CocosProxyType type, String resJson, Long objectId) {
        if (type == null) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"callGameFunction type: %s, reqJson: %s", (Object[])new Object[]{type.getType(), resJson});
        }
        resJson = resJson == null ? "" : resJson;
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        stringObjectMap.put("context", context);
        stringObjectMap.put("seqId", reqId);
        stringObjectMap.put("event", type.getEvent());
        stringObjectMap.put("objectId", objectId);
        stringObjectMap.put("jsonData", resJson);
        this.iGameMsgInterface.appCallGame("appSentEventToGame", stringObjectMap, GameProxyDef.DEF_TAG);
    }

    public void callGameFunction(final String context, final long reqId, final CocosProxyType type, final Object object, final Long objectId) {
        if (type == null) {
            return;
        }
        this.mQueueExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CocosProxyController.this.callGameFunction(context, reqId, type, JsonParser.toJson((Object)object), objectId);
                }
                catch (Exception e) {
                    MLog.error((Object)CocosProxyController.TAG, (Throwable)e);
                }
            }
        }, 0L);
    }

    public void callGameWithType(String type, Object object, int tag) {
        this.callGameWithType(type, object, tag, (Long)0L);
    }

    public void callGameWithType(String type, Object object, int tag, Long objectId) {
        this.mQueueExecutor.execute(() -> {
            try {
                this.callGameWithType(type, JsonParser.toJson((Object)object), tag, objectId);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }, 0L);
    }

    public void callGameWithTypeMap(String type, Map<String, Object> map, int tag) {
        this.mQueueExecutor.execute(() -> {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"callGameFunction type: %s, reqJson: %s", (Object[])new Object[]{type, map != null ? map : "null"});
            }
            this.iGameMsgInterface.appCallGame(type, map, tag);
        }, 0L);
    }

    public void callGameWithType(String type, String json, int tag) {
        this.callGameWithType(type, json, tag, (Long)0L);
    }

    public void callGameWithType(String type, String json, int tag, Long objectId) {
        this.mQueueExecutor.execute(() -> {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"callGameFunction type: %s, reqJson: %s\uff0c objectId\uff1a %s", (Object[])new Object[]{type, json, objectId});
            }
            HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
            stringObjectMap.put("jsonData", json);
            stringObjectMap.put("objectId", objectId);
            stringObjectMap.put("version", 1);
            this.iGameMsgInterface.appCallGame(type, stringObjectMap, tag);
        }, 0L);
    }

    public String gameCallApp(final String context, final long seqId, final int event, final Vector<String> args) {
        final IGameCallAppFunction function = this.mGameCallAppFunctionList.get(event);
        GameLoger.info(TAG, "conext =%s,seqid=%s,event=%s", context, seqId, event);
        if (function == null) {
            GameLoger.error(TAG, "conext =%s,seqid=%s,event=%s", context, seqId, event);
            MLog.error((Object)TAG, (String)"conext =%s,seqid=%s,event=%s", (Object[])new Object[]{context, seqId, event});
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)this.mContext, (String)("\u6d4b\u8bd5\u63d0\u793a,\u8bf7\u7a0d\u5b89\u52ff\u8e81\uff0c\u8bf7\u4ea4\u7ed9\u5f00\u53d1\u5904\u7406\uff0c\u6e38\u620f\u4e8b\u4ef6\u672a\u6ce8\u518c evnet = " + event), (int)0);
            }
            return "";
        }
        if (function != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    function.call(context, seqId, event, args);
                }
            });
        }
        return "";
    }

    public void appNotifyGame(String context, int event, Object object) {
        this.appNotifyGame(context, event, object, 0L);
    }

    public void appNotifyGame(String context, int event, Object object, Long objectId) {
        this.mQueueExecutor.execute(() -> {
            if (this.mNotiySet.contains(event)) {
                String resJson = JsonParser.toJson((Object)object);
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)"appNotifyGame,context = %s,,event=%s,resJson=%s", (Object[])new Object[]{context, event, resJson});
                }
                this.appRegisteredEventCallback(context, AppCallGameProxy.getSingleton().uniqueSeq(), event, resJson, objectId);
            }
        }, 0L);
    }

    public void didRegisterEvent(String context, long seqId, int event) {
        this.mNotiySet.add(event);
        for (IAppNotifyGameFunction notifyGameFunction : this.mNotifyFuntionSet) {
            notifyGameFunction.registerNotify(context, seqId, event);
        }
    }

    public void didUnRegisterEvent(String context, long seqId, int event) {
        for (IAppNotifyGameFunction notifyGameFunction : this.mNotifyFuntionSet) {
            notifyGameFunction.unRegisterNotify(context, seqId, event);
        }
        this.mNotiySet.remove(event);
    }

    public Object handleGameTypeMessageSync(String type, Map<String, Object> msgObj, int tag) {
        IGameMessageSyncHandler handler2 = this.mGameMessageSyncHandlerMap.get(type);
        if (handler2 != null) {
            return handler2.onMessageHandlerSync(type, msgObj, tag);
        }
        for (IGameMessageSyncHandler h : this.mGameMessageSyncHandlerMap.values()) {
            if (h == null || !h.isSuperHandler()) continue;
            return h.onMessageHandlerSync(type, msgObj, tag);
        }
        return null;
    }

    public void addGameTypeMessageSyncHandler(IGameMessageSyncHandler handler2) {
        String[] types;
        if (handler2 != null && (types = handler2.supportTypes()) != null && types.length > 0) {
            for (String type : types) {
                this.mGameMessageSyncHandlerMap.put(type, handler2);
            }
        }
    }

    public void removeGameTypeMessageSyncHandler(IGameMessageSyncHandler handler2) {
        String[] types;
        if (handler2 != null && (types = handler2.supportTypes()) != null && types.length > 0) {
            for (String type : types) {
                this.mGameMessageSyncHandlerMap.remove(type);
            }
        }
    }

    public void appRegisteredEventCallback(String context, long seqId, int event, String dataJson, Long objectId) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"appRegisteredEventCallback event = %s dataJson = %s, objectId\uff1a %s", (Object[])new Object[]{event, dataJson, objectId});
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", context);
        map.put("seqId", seqId);
        map.put("event", event);
        map.put("objectId", objectId);
        map.put("jsonData", dataJson);
        this.iGameMsgInterface.appCallGame("appRegisteredEventCallback", map, GameProxyDef.DEF_TAG);
    }

    public void appCallGameWithType(String type, Map<String, Object> msgObj, int tag) {
        if (this.iGameMsgInterface != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"appCallGame type=%s,msg=%s", (Object[])new Object[]{type, msgObj});
            }
            this.iGameMsgInterface.appCallGame(type, msgObj, tag);
        }
    }
}

