/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.porxy;

import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.game.gameproxy.gamecallapp.GameCallAppProxy;
import com.yy.game.gameproxy.gamecallapp.IGameCallAppProxy;
import com.yy.game.porxy.CocosProxyController;
import com.yy.game.porxy.GameProxyController;
import com.yy.game.porxy.IGameMsgInterface;
import com.yy.game.porxy.proxy.IGameProxyService;
import com.yy.hiyo.game.base.GameLifeBean;
import com.yy.hiyo.game.base.gamemode.IGameMessageInterface;
import com.yy.hiyo.game.base.protocol.IGameLifeCallBack;
import com.yy.hiyo.game.service.ICocosProxyService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.json.JSONObject;

public class CocosMessageProxy
implements IGameMsgInterface {
    private static final String TAG = "CocosMessageProxy";
    private IGameCallAppProxy mGameCallAppProxy;
    private IGameMessageInterface iGameMessageInterface;
    private ICocosProxyService mCocosProxyController;
    private IGameProxyService iGameProxyService;
    private Set<IGameLifeCallBack> iGameLifeCallBacks = new HashSet<IGameLifeCallBack>();
    private IGameMessageInterface.IGameMessageNotify iGameMessageNotify = new IGameMessageInterface.IGameMessageNotify(){

        public void onReceiveMessage(String type, Map<String, Object> msgObj, int tag) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)CocosMessageProxy.TAG, (String)"onReceiveMessage type: %s, msgObj: %s, tag: %s", (Object[])new Object[]{type, msgObj, tag});
            }
            try {
                switch (type) {
                    case "sendGameEventToApp": {
                        String context = (String)msgObj.get("context");
                        long seqId = ((Number)msgObj.get("seqId")).longValue();
                        int event = ((Number)msgObj.get("event")).intValue();
                        Vector req = (Vector)msgObj.get("args");
                        CocosMessageProxy.this.mCocosProxyController.gameCallApp(context, seqId, event, req);
                        break;
                    }
                    case "onGameComeTo": {
                        String context = (String)msgObj.get("context");
                        long seqId = ((Number)msgObj.get("seqId")).longValue();
                        int stage = ((Number)msgObj.get("stage")).intValue();
                        Vector args = (Vector)msgObj.get("args");
                        CocosMessageProxy.this.onGameComeTo(context, seqId, stage, args);
                        break;
                    }
                    case "hg.onGameStageChange": {
                        String json = (String)msgObj.get("jsondata");
                        JSONObject jsonObject = JsonParser.obtainJSONObject((String)json);
                        int stage = jsonObject.getInt("stage");
                        int code = 0;
                        if (jsonObject.has("code")) {
                            code = jsonObject.getInt("code");
                        }
                        String result = "";
                        if (jsonObject.has("result")) {
                            result = jsonObject.getString("result");
                        }
                        CocosMessageProxy.this.onGameComeTo(stage, code, result);
                        break;
                    }
                    case "didRegisterEvent": {
                        String context = (String)msgObj.get("context");
                        long seqId = ((Number)msgObj.get("seqId")).longValue();
                        int event = ((Number)msgObj.get("event")).intValue();
                        CocosMessageProxy.this.mCocosProxyController.didRegisterEvent(context, seqId, event);
                        break;
                    }
                    case "didUnRegisterEvent": {
                        String context = (String)msgObj.get("context");
                        long seqId = ((Number)msgObj.get("seqId")).longValue();
                        int event = ((Number)msgObj.get("event")).intValue();
                        CocosMessageProxy.this.mCocosProxyController.didUnRegisterEvent(context, seqId, event);
                        break;
                    }
                    default: {
                        CocosMessageProxy.this.mGameCallAppProxy.onReceiveGameMessage(type, msgObj, tag);
                        CocosMessageProxy.this.mCocosProxyController.handleGameTypeMessage(type, msgObj, tag);
                        break;
                    }
                }
            }
            catch (Exception e) {
                MLog.error((Object)CocosMessageProxy.TAG, (Throwable)e);
            }
        }

        public Object onReceiveMessageSync(String type, Map<String, Object> msgObj, int tag) {
            return CocosMessageProxy.this.mCocosProxyController.handleGameTypeMessageSync(type, msgObj, tag);
        }
    };

    public CocosMessageProxy(Environment env) {
        this.iGameProxyService = new GameProxyController(env, this);
        this.mGameCallAppProxy = new GameCallAppProxy(env, this.iGameProxyService);
        this.mCocosProxyController = new CocosProxyController(env, this);
    }

    public void init(GamePlayContext context) {
        if (context != null) {
            this.mGameCallAppProxy.setRoomId(context.getRoomId());
            this.mGameCallAppProxy.setGameId(context.getGameInfo().gid);
        }
    }

    public synchronized void updateGameMessageInterface(IGameMessageInterface gameMessageInterface) {
        if (this.iGameMessageInterface != null) {
            this.iGameMessageInterface.unRegisterGameMessageNotify(this.iGameMessageNotify);
        }
        this.iGameMessageInterface = gameMessageInterface;
        if (this.iGameMessageInterface != null) {
            this.iGameMessageInterface.registerGameMessageNotify(this.iGameMessageNotify);
        }
    }

    @Override
    public void appCallGame(String type, Map<String, Object> msgObj, int tag) {
        if (this.iGameMessageInterface != null) {
            this.iGameMessageInterface.sendMessage(type, msgObj, tag);
        }
    }

    public void onGameComeTo(final String context, long seqId, int stage, Vector<String> args) {
        GameLifeBean.Builder gameLifeBeanBuild = GameLifeBean.newBuilder().context(context).seqId(seqId).stage(stage);
        if (args != null && args.size() > 0) {
            gameLifeBeanBuild.result(args.get(0));
        }
        final GameLifeBean gameLifeBean = gameLifeBeanBuild.build();
        if (stage == 7) {
            AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent().eventId("CompleteGames"));
        }
        for (final IGameLifeCallBack gameLifeCallBack : this.iGameLifeCallBacks) {
            YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    gameLifeCallBack.onGameLifeChange(context, gameLifeBean);
                }
            });
        }
    }

    public void onGameComeTo(int stage, int code, String result) {
        GameLifeBean.Builder gameLifeBeanBuild = GameLifeBean.newBuilder().stage(stage).result(result);
        final GameLifeBean gameLifeBean = gameLifeBeanBuild.build();
        if (stage == 7) {
            AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent().eventId("CompleteGames"));
        }
        for (final IGameLifeCallBack gameLifeCallBack : this.iGameLifeCallBacks) {
            YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    gameLifeCallBack.onGameLifeChange("", gameLifeBean);
                }
            });
        }
    }

    public void unregisterGameLife(IGameLifeCallBack iGameLifeCallBack) {
        if (iGameLifeCallBack != null) {
            this.iGameLifeCallBacks.remove(iGameLifeCallBack);
        }
    }

    public void registerGameLife(IGameLifeCallBack iGameLifeCallBack) {
        if (iGameLifeCallBack != null) {
            this.iGameLifeCallBacks.add(iGameLifeCallBack);
        }
    }

    public ICocosProxyService getCocosProxyController() {
        return this.mCocosProxyController;
    }

    public IGameProxyService getGameProxyService() {
        return this.iGameProxyService;
    }
}

