/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.game.R;
import com.yy.game.module.streakwin.IStreakWinUICallbacks;
import com.yy.game.module.streakwin.StreakWinShareHelper;
import com.yy.game.module.streakwin.ui.GameMasterView;
import com.yy.game.module.streakwin.ui.StreakWinShareView;
import com.yy.game.module.streakwin.ui.StreakWinShowView;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.gameresult.PKWinStreakPush;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StreakWinWindow
extends DefaultWindow
implements View.OnClickListener {
    StreakWinShareHelper streakWinShareHelper;
    StreakWinShareView mShareContent;
    StreakWinShowView mShowContent;
    GameMasterView gameMasterView;
    View contentView;
    TextView mCountDown;
    LinearLayout llShareContainer;
    ImageView ivSaveAlbum;
    ImageView ivSaveAlbumDecoration;
    private DialogLinkManager mDialogLinkManager;
    IStreakWinUICallbacks mStreakWinUICallbacks;
    Runnable mRunnableCountDown;
    int mCurCountDown = 10;
    String mNickName = "";
    private Animation saveAlbumAnim;
    private boolean isNewUser = false;
    private boolean isgameMaster = false;
    private int iconId;

    public StreakWinWindow(Context context, @NotNull StreakWinShareHelper helper, IStreakWinUICallbacks uiCallBacks) {
        super(context, (UICallBacks)uiCallBacks, "StreakWin");
        this.mStreakWinUICallbacks = uiCallBacks;
        this.streakWinShareHelper = helper;
        this.createView();
        this.setNeedFullScreen(true);
    }

    private void createView() {
        this.contentView = StreakWinWindow.inflate((Context)this.getContext(), (int)R.layout.game_streakwin_layout, (ViewGroup)this.getBaseLayer());
        this.llShareContainer = (LinearLayout)this.contentView.findViewById(R.id.ll_share_container);
        this.ivSaveAlbum = (ImageView)this.contentView.findViewById(R.id.iv_save_album_btn);
        this.ivSaveAlbumDecoration = (ImageView)this.contentView.findViewById(R.id.iv_save_album_decoration);
        this.mShareContent = (StreakWinShareView)this.contentView.findViewById(R.id.share_content);
        this.mShowContent = (StreakWinShowView)this.contentView.findViewById(R.id.share_content2);
        this.mCountDown = (TextView)this.contentView.findViewById(R.id.count_down_second);
        this.gameMasterView = (GameMasterView)this.contentView.findViewById(R.id.game_master_view);
        this.ivSaveAlbum.setOnClickListener((View.OnClickListener)this);
        this.mCountDown.setOnClickListener((View.OnClickListener)this);
        this.initShareChannels();
    }

    private void initShareChannels() {
        List<BaseShareChannel> shareChannelList = this.streakWinShareHelper.getChannels();
        if (shareChannelList == null) {
            return;
        }
        for (BaseShareChannel shareChannel : shareChannelList) {
            int marginValue;
            YYImageView ivIcon = new YYImageView(this.getContext());
            int iconSize = ResourceUtils.getDimen((int)R.dimen.winning_streak_share_icon_size);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(iconSize, iconSize);
            lp.leftMargin = marginValue = ResolutionUtils.dip2Px((float)12.0f);
            lp.rightMargin = marginValue;
            int idResId = 0;
            int iconResId = 0;
            switch (shareChannel.getId()) {
                case 5: {
                    idResId = R.id.share_platform_facebook;
                    iconResId = R.drawable.ico_share_facebook;
                    break;
                }
                case 2: {
                    idResId = R.id.share_platform_whatsapp;
                    iconResId = R.drawable.ico_share_whatsapp;
                    break;
                }
                case 1: {
                    idResId = R.id.share_platform_line;
                    iconResId = R.drawable.ico_share_line;
                    break;
                }
                case 3: {
                    idResId = R.id.share_platform_instagram;
                    iconResId = R.drawable.ico_share_ins;
                    break;
                }
                case 6: {
                    idResId = R.id.share_platform_messenger;
                    iconResId = R.drawable.ico_share_messenger;
                    break;
                }
                case 9: {
                    idResId = R.id.share_platform_vk;
                    iconResId = R.drawable.ico_share_vk;
                    break;
                }
            }
            ivIcon.setId(idResId);
            ivIcon.setImageResource(iconResId);
            this.llShareContainer.addView((View)ivIcon, (ViewGroup.LayoutParams)lp);
            ivIcon.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onAttach() {
        super.onAttach();
        if (this.mRunnableCountDown == null) {
            this.mRunnableCountDown = new Runnable(){

                @Override
                public void run() {
                    --StreakWinWindow.this.mCurCountDown;
                    if (StreakWinWindow.this.mCurCountDown <= 0) {
                        StreakWinWindow.this.mStreakWinUICallbacks.closeStreakWindow();
                    } else {
                        StreakWinWindow.this.updateCountDown();
                        StreakWinWindow.this.postDelayed(this, 1000L);
                    }
                }
            };
        }
        this.mCurCountDown = 10;
        this.updateCountDown();
        this.removeCallbacks(this.mRunnableCountDown);
        this.postDelayed(this.mRunnableCountDown, 1000L);
        this.startSaveAlbumAnim();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mRunnableCountDown);
    }

    public void onDetached() {
        super.onDetached();
        this.removeCallbacks(this.mRunnableCountDown);
        this.stopSaveAlbumAnim();
    }

    private void startSaveAlbumAnim() {
        this.saveAlbumAnim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        this.saveAlbumAnim.setDuration(8000L);
        this.saveAlbumAnim.setFillAfter(true);
        this.saveAlbumAnim.setInterpolator((Interpolator)new LinearInterpolator());
        this.saveAlbumAnim.setRepeatMode(1);
        this.saveAlbumAnim.setRepeatCount(-1);
        this.ivSaveAlbumDecoration.setVisibility(0);
        this.ivSaveAlbumDecoration.startAnimation(this.saveAlbumAnim);
    }

    private void stopSaveAlbumAnim() {
        if (this.saveAlbumAnim != null) {
            this.saveAlbumAnim.cancel();
            this.saveAlbumAnim = null;
        }
        this.ivSaveAlbumDecoration.setVisibility(8);
    }

    private void updateCountDown() {
        this.mCountDown.setText((CharSequence)ResourceUtils.getString((int)R.string.tap_to_continue, (Object[])new Object[]{this.mCurCountDown}));
    }

    private void stopCountDown() {
        this.mCountDown.setText((CharSequence)ResourceUtils.getString((int)R.string.tap_to_continue_no_timer));
    }

    public void updateUIMyselfInfo(UserInfoBean myInfo) {
        if (myInfo == null) {
            return;
        }
        this.mNickName = myInfo.getNick();
        this.mShareContent.updateUIMyselfInfo(myInfo);
        this.mShowContent.updateUIMyselfInfo(myInfo);
    }

    public void updateUIWinStreak(PKWinStreakPush data) {
        this.isNewUser = false;
        this.mShareContent.updateUIWinStreak(data);
        this.mShowContent.updateUIWinStreak(data);
    }

    public void showThreeWin(int steakWin, List<GameInfo> gameInfos) {
        this.isNewUser = true;
        this.mShareContent.updateThreeWin(steakWin, gameInfos);
        this.mShowContent.updateThreeWin(steakWin);
    }

    public void showGameMaster(int iconId) {
        this.isgameMaster = true;
        this.iconId = iconId;
        this.gameMasterView.setVisibility(0);
        this.mShareContent.setVisibility(8);
        this.mShowContent.setVisibility(8);
        this.llShareContainer.setVisibility(8);
        this.gameMasterView.upDateMaster(iconId);
    }

    private void ensureDialogLinManager() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.getContext());
        }
    }

    public void showLoadDialog(int strId) {
        this.ensureDialogLinManager();
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)strId), false, false, null));
    }

    public void hideLoadDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.mDialogLinkManager = null;
    }

    public void onClick(View view) {
        int id2;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                }
            }
        });
        if (this.mRunnableCountDown != null) {
            this.removeCallbacks(this.mRunnableCountDown);
        }
        this.stopCountDown();
        int winStreakCount = this.mStreakWinUICallbacks.getLastStreakWincount() + 1;
        if (this.isNewUser) {
            winStreakCount = 3;
        }
        if ((id2 = view.getId()) == R.id.share_platform_facebook) {
            this.reportShare("1");
            if (this.isgameMaster) {
                this.mStreakWinUICallbacks.shareMaster(this.iconId, 5);
            } else {
                this.mStreakWinUICallbacks.share(winStreakCount, this.isNewUser, 5);
            }
        } else if (id2 == R.id.share_platform_messenger) {
            if (this.isgameMaster) {
                this.mStreakWinUICallbacks.shareMaster(this.iconId, 6);
            } else {
                this.mStreakWinUICallbacks.share(winStreakCount, this.isNewUser, 6);
            }
        } else if (id2 == R.id.share_platform_instagram) {
            this.reportShare("4");
            if (this.isgameMaster) {
                this.mStreakWinUICallbacks.shareMaster(this.iconId, 3);
            } else {
                this.mStreakWinUICallbacks.share(winStreakCount, this.isNewUser, 3);
            }
        } else if (id2 == R.id.share_platform_whatsapp) {
            this.reportShare("3");
            if (this.isgameMaster) {
                this.mStreakWinUICallbacks.shareMaster(this.iconId, 2);
            } else {
                this.mStreakWinUICallbacks.share(winStreakCount, this.isNewUser, 2);
            }
        } else if (id2 == R.id.share_platform_line) {
            this.reportShare("2");
            if (this.isgameMaster) {
                this.mStreakWinUICallbacks.shareMaster(this.iconId, 1);
            } else {
                this.mStreakWinUICallbacks.share(winStreakCount, this.isNewUser, 1);
            }
        } else if (id2 == R.id.share_platform_vk) {
            this.reportShare("6");
            if (this.isgameMaster) {
                this.mStreakWinUICallbacks.shareMaster(this.iconId, 9);
            } else {
                this.mStreakWinUICallbacks.share(winStreakCount, this.isNewUser, 9);
            }
        } else if (id2 == R.id.count_down_second) {
            this.mStreakWinUICallbacks.closeStreakWindow();
        } else if (id2 == R.id.iv_save_album_btn) {
            this.reportShare("8");
            this.stopSaveAlbumAnim();
            this.streakWinShareHelper.saveToAlbum((View)(this.isgameMaster ? this.gameMasterView : this.mShareContent), new StreakWinShareHelper.HelperListener(){

                @Override
                public void onSuccess() {
                    TopToastUtils.showSucceedToast((CharSequence)ResourceUtils.getString((int)R.string.saved_to_album_tips), (int)0);
                }

                @Override
                public void onFailed() {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.save_to_album_failed_tips), (int)0);
                }
            });
        }
    }

    private void reportShare(String channel) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "6").put("share_channel", channel).put("gid", this.getGid()));
    }

    private String getGid() {
        if (this.mStreakWinUICallbacks != null && this.mStreakWinUICallbacks.getResultBean() != null) {
            return this.mStreakWinUICallbacks.getResultBean().getGameID();
        }
        return "";
    }
}

