/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin.ui;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.module.streakwin.StreakWinLevelHelper;
import com.yy.game.module.streakwin.ui.StreakWinShareView;
import ikxd.gameresult.PKWinStreakPush;

public class StreakWinShowView
extends YYLinearLayout {
    private boolean mInit = false;
    TextView mStreakCount;
    CircleImageView mHead;
    View cupView;
    TextView mLevel;
    View bannerView;

    public StreakWinShowView(Context context) {
        super(context);
        this.initView();
    }

    public StreakWinShowView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public StreakWinShowView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
        if (this.mInit) {
            return;
        }
        this.mInit = true;
        this.setOrientation(1);
        StreakWinShowView.inflate((Context)this.getContext(), (int)R.layout.game_streakwin_show_layout, (ViewGroup)this);
        this.mLevel = (TextView)this.findViewById(R.id.level);
        this.mHead = (CircleImageView)this.findViewById(R.id.share_head_icon);
        this.mStreakCount = (TextView)this.findViewById(R.id.streak_count);
        this.cupView = this.findViewById(R.id.ll_cup);
        this.bannerView = this.findViewById(R.id.ll_banner);
        Typeface typeface = FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi);
        this.mLevel.setTypeface(typeface);
    }

    public void updateUIMyselfInfo(UserInfoBean myInfo) {
        if (myInfo == null) {
            return;
        }
        ImageLoader.loadImage((RecycleImageView)this.mHead, (String)(myInfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)));
    }

    public void updateUIWinStreak(PKWinStreakPush data) {
        if (data == null) {
            return;
        }
        int winStreakCount = (int)(data.win_streak_count + 1L);
        this.mStreakCount.setText(StreakWinShareView.getSpanString(winStreakCount + " " + ResourceUtils.getString((int)R.string.winning_streak), winStreakCount, false));
        this.mLevel.setText(StreakWinLevelHelper.getLevelString(winStreakCount));
        this.cupView.setBackgroundResource(StreakWinLevelHelper.getCup(winStreakCount));
        this.bannerView.setBackgroundResource(StreakWinLevelHelper.getBanner(winStreakCount));
        this.mHead.setVisibility(0);
        this.mHead.setBorderColor(ResourceUtils.getColor((int)StreakWinLevelHelper.getAvatarStrokeColor(winStreakCount)));
    }

    public void updateThreeWin(int winCount) {
        this.mLevel.setText(StreakWinLevelHelper.getLevelString(winCount));
        this.cupView.setBackgroundResource(R.drawable.new_register_three_win_new);
        this.bannerView.setBackgroundResource(R.drawable.bg_newuser_win_3_banner);
        this.mStreakCount.setText(StreakWinShareView.getSpanString(ResourceUtils.getString((int)R.string.title_won_3_crowns), winCount, true));
        this.mHead.setVisibility(4);
    }
}

