/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin.ui;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.module.streakwin.StreakWinLevelHelper;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.streakwin.StreakWinData;
import ikxd.gameresult.PKWinStreakContext;
import ikxd.gameresult.PKWinStreakGameInfo;
import ikxd.gameresult.PKWinStreakPush;
import java.util.List;

public class StreakWinShareView
extends YYLinearLayout {
    private boolean mInit = false;
    View mShareLogo;
    View mShareContainer;
    View mBanner;
    CircleImageView mHead;
    RecycleImageView mStreakRemark;
    TextView mStreakCount;
    private static final int GAME_SIZE = 3;
    RoundConerImageView[] mIcons = new RoundConerImageView[3];
    TextView[] mTexts = new TextView[3];

    public StreakWinShareView(Context context) {
        super(context);
        this.initView();
    }

    public StreakWinShareView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public StreakWinShareView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
        if (this.mInit) {
            return;
        }
        this.mInit = true;
        this.setOrientation(1);
        StreakWinShareView.inflate((Context)this.getContext(), (int)R.layout.game_streakwin_share_layout, (ViewGroup)this);
        this.mShareLogo = this.findViewById(R.id.streak_win_share_logo);
        this.mShareContainer = this.findViewById(R.id.share_container);
        this.mBanner = this.findViewById(R.id.ll_banner);
        this.mHead = (CircleImageView)this.findViewById(R.id.share_head_icon);
        this.mStreakRemark = (RecycleImageView)this.findViewById(R.id.share_remark);
        this.mStreakCount = (TextView)this.findViewById(R.id.streak_count);
        this.mIcons[0] = (RoundConerImageView)this.findViewById(R.id.streak_win_icon1);
        this.mIcons[1] = (RoundConerImageView)this.findViewById(R.id.streak_win_icon2);
        this.mIcons[2] = (RoundConerImageView)this.findViewById(R.id.streak_win_icon3);
        this.mTexts[0] = (TextView)this.findViewById(R.id.streak_win_gamename1);
        this.mTexts[1] = (TextView)this.findViewById(R.id.streak_win_gamename2);
        this.mTexts[2] = (TextView)this.findViewById(R.id.streak_win_gamename3);
    }

    public void updateUIMyselfInfo(UserInfoBean myInfo) {
        if (myInfo == null) {
            return;
        }
        ImageLoader.loadImage((RecycleImageView)this.mHead, (String)(myInfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)));
    }

    public void updateUIWinStreak(PKWinStreakPush data) {
        if (data == null) {
            return;
        }
        int winStreakCount = (int)(data.win_streak_count + 1L);
        this.mStreakCount.setText(StreakWinShareView.getSpanString(winStreakCount + " " + ResourceUtils.getString((int)R.string.winning_streak), winStreakCount, false));
        this.mStreakCount.setVisibility(0);
        String remarkIconUrl = "";
        List list = data.win_streak_context;
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (i == list.size() - 1) {
                    if ((long)winStreakCount < ((PKWinStreakContext)list.get((int)i)).win_streak_count) continue;
                    remarkIconUrl = ((PKWinStreakContext)list.get((int)i)).win_streak_context;
                    break;
                }
                if ((long)winStreakCount != ((PKWinStreakContext)list.get((int)i)).win_streak_count) continue;
                remarkIconUrl = ((PKWinStreakContext)list.get((int)i)).win_streak_context;
                break;
            }
        }
        if (FP.empty((CharSequence)remarkIconUrl)) {
            this.mStreakRemark.setVisibility(8);
        } else {
            ImageLoader.loadImage((RecycleImageView)this.mStreakRemark, (String)remarkIconUrl);
        }
        List urlList = data.win_streak_game_infos;
        for (int i = 0; i < urlList.size() && i < this.mIcons.length; ++i) {
            ImageLoader.loadImage((RecycleImageView)this.mIcons[i], (String)((PKWinStreakGameInfo)urlList.get((int)i)).game_icon_url);
            this.mTexts[i].setText((CharSequence)((PKWinStreakGameInfo)urlList.get((int)i)).game_name);
        }
        this.mShareContainer.setBackgroundResource(StreakWinLevelHelper.getShareBg(winStreakCount));
        this.mBanner.setVisibility(0);
        this.mBanner.setBackgroundResource(StreakWinLevelHelper.getBanner(winStreakCount));
        this.mHead.setVisibility(0);
        this.mHead.setBorderColor(ResourceUtils.getColor((int)StreakWinLevelHelper.getAvatarStrokeColor(winStreakCount)));
    }

    public void updateUIWinStreak(StreakWinData streakWinData) {
        String remarkIconUrl = streakWinData.getRemarkIconUrl();
        if (FP.empty((CharSequence)remarkIconUrl)) {
            this.mStreakRemark.setVisibility(8);
        } else {
            ImageLoader.loadImage((RecycleImageView)this.mStreakRemark, (String)remarkIconUrl);
        }
        List streakGameInfoList = streakWinData.getStreakGameInfoList();
        if (streakGameInfoList != null) {
            for (int i = 0; i < streakGameInfoList.size() && i < this.mIcons.length; ++i) {
                ImageLoader.loadImage((RecycleImageView)this.mIcons[i], (String)((StreakWinData.StreakGameInfo)streakGameInfoList.get(i)).getIconUrl());
                this.mTexts[i].setText((CharSequence)((StreakWinData.StreakGameInfo)streakGameInfoList.get(i)).getName());
            }
        }
        int winStreakCount = streakWinData.getCount();
        this.mStreakCount.setText(StreakWinShareView.getSpanString(winStreakCount + " " + ResourceUtils.getString((int)R.string.winning_streak), winStreakCount, false));
        this.mShareContainer.setBackgroundResource(StreakWinLevelHelper.getShareBg(winStreakCount));
        this.mBanner.setVisibility(0);
        this.mBanner.setBackgroundResource(StreakWinLevelHelper.getBanner(winStreakCount));
        this.mHead.setVisibility(0);
        this.mHead.setBorderColor(ResourceUtils.getColor((int)StreakWinLevelHelper.getAvatarStrokeColor(winStreakCount)));
    }

    public void updateThreeWin(int winStreakCount, List<GameInfo> gameInfos) {
        if (gameInfos != null && !gameInfos.isEmpty()) {
            for (int i = 0; i < gameInfos.size(); ++i) {
                GameInfo info;
                if (i >= 3 || (info = gameInfos.get(i)) == null) continue;
                this.mTexts[i].setText((CharSequence)info.getGname());
                ImageLoader.loadImage((RecycleImageView)this.mIcons[i], (String)info.getIconUrl());
            }
        }
        this.mShareContainer.setBackgroundResource(R.drawable.new_register_three_win);
        this.mStreakRemark.setImageResource(R.drawable.icon_new_register_tag_good);
        this.mBanner.setBackgroundResource(R.drawable.bg_newuser_win_3_banner);
        this.mHead.setVisibility(4);
        this.mStreakCount.setText(StreakWinShareView.getSpanString(ResourceUtils.getString((int)R.string.title_won_3_crowns), winStreakCount, true));
    }

    public static CharSequence getSpanString(String defaultString, int counts, boolean isThreeWin) {
        if (StringUtils.isEmpty((String)defaultString)) {
            return "";
        }
        String placeHolder = "3";
        int index = defaultString.indexOf(String.valueOf(counts));
        int index1 = defaultString.indexOf(placeHolder);
        int n = index >= 0 ? index : (index = index1 >= 0 ? index1 : -1);
        if (index >= 0) {
            placeHolder = String.valueOf(counts);
        }
        if (index < 0) {
            return "";
        }
        String countsStr = String.valueOf(counts);
        String modifiStr = defaultString.replaceFirst(placeHolder, countsStr);
        SpannableString spannableString = new SpannableString((CharSequence)modifiStr);
        spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffffea00")), index, index + countsStr.length(), 17);
        spannableString.setSpan((Object)new AbsoluteSizeSpan(ResolutionUtils.dip2Px((float)26.0f)), index, index + countsStr.length(), 17);
        if (isThreeWin) {
            spannableString.setSpan((Object)new StyleSpan(1), index, index + countsStr.length(), 17);
        }
        return spannableString;
    }
}

