/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.module.streakwin.StreakWinLevelHelper;
import com.yy.hiyo.game.base.streakwin.StreakWinData;

public class StreakWinDialogView
extends YYRelativeLayout {
    private TextView mStreakCount;
    private CircleImageView mHead;
    private View bannerView;

    public StreakWinDialogView(Context context) {
        super(context);
        this.initViews();
    }

    public StreakWinDialogView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViews();
    }

    public StreakWinDialogView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initViews();
    }

    private void initViews() {
        StreakWinDialogView.inflate((Context)this.getContext(), (int)R.layout.game_streakwin_dialog_view, (ViewGroup)this);
        this.mStreakCount = (TextView)this.findViewById(R.id.streak_count);
        this.mHead = (CircleImageView)this.findViewById(R.id.share_head_icon);
        this.bannerView = this.findViewById(R.id.ll_banner);
        this.setBackgroundResource(R.drawable.streak_win_1_share);
    }

    public void updateUIMyselfInfo(UserInfoBean myInfo) {
        if (myInfo == null) {
            return;
        }
        ImageLoader.loadImage((RecycleImageView)this.mHead, (String)(myInfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)));
    }

    public void updateUIWinStreak(StreakWinData data) {
        if (data == null) {
            return;
        }
        int winStreakCount = data.getCount();
        this.mStreakCount.setText((CharSequence)String.valueOf(winStreakCount));
        this.bannerView.setBackgroundResource(StreakWinLevelHelper.getBanner(winStreakCount));
        this.setBackgroundResource(StreakWinLevelHelper.getShareBg(winStreakCount));
        this.mHead.setBorderColor(ResourceUtils.getColor((int)StreakWinLevelHelper.getAvatarStrokeColor(winStreakCount)));
    }
}

