/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.module.streakwin.StreakWinShareHelper;
import com.yy.game.module.streakwin.ui.StreakWinDialogView;
import com.yy.game.module.streakwin.ui.StreakWinShareView;
import com.yy.hiyo.game.base.streakwin.StreakWinData;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IShareDialogViewProvider;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class StreakWinDialogPage
extends YYFrameLayout
implements IShareDialogViewProvider,
View.OnClickListener {
    private View mRootView;
    private StreakWinShareView mStreakWinShareView;
    private LinearLayout mShareContainer;
    private View mSaveAlbumBtn;
    private StreakWinDialogView mDialogView;
    private StreakWinShareHelper mStreakWinShareHelper;
    private String mNickName = "";
    private StreakWinData mStreakWinData;

    public StreakWinDialogPage(Context context, StreakWinShareHelper mStreakWinShareHelper) {
        super(context);
        this.mStreakWinShareHelper = mStreakWinShareHelper;
        this.initViews();
    }

    public void initViews() {
        this.mRootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.game_streakwin_dialog_layout, (ViewGroup)this);
        this.mShareContainer = (LinearLayout)this.mRootView.findViewById(R.id.ll_share_container);
        this.mSaveAlbumBtn = this.mRootView.findViewById(R.id.iv_save_album_btn);
        this.mDialogView = (StreakWinDialogView)this.mRootView.findViewById(R.id.streakwin_view);
        this.initShareChannels(this.getContext());
        this.mSaveAlbumBtn.setOnClickListener((View.OnClickListener)this);
        this.mStreakWinShareView = new StreakWinShareView(this.getContext());
    }

    private void initShareChannels(Context context) {
        List<BaseShareChannel> shareChannelList = this.mStreakWinShareHelper.getChannels();
        if (shareChannelList == null) {
            return;
        }
        for (BaseShareChannel shareChannel : shareChannelList) {
            int marginValue;
            YYImageView ivIcon = new YYImageView(context);
            int iconSize = ResourceUtils.getDimen((int)R.dimen.winning_streak_share_icon_size);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(iconSize, iconSize);
            lp.leftMargin = marginValue = ResolutionUtils.dip2Px((float)7.0f);
            lp.rightMargin = marginValue;
            int idResId = 0;
            int iconResId = 0;
            switch (shareChannel.getId()) {
                case 5: {
                    idResId = R.id.share_platform_facebook;
                    iconResId = R.drawable.ico_share_facebook;
                    break;
                }
                case 2: {
                    idResId = R.id.share_platform_whatsapp;
                    iconResId = R.drawable.ico_share_whatsapp;
                    break;
                }
                case 1: {
                    idResId = R.id.share_platform_line;
                    iconResId = R.drawable.ico_share_line;
                    break;
                }
                case 3: {
                    idResId = R.id.share_platform_instagram;
                    iconResId = R.drawable.ico_share_ins;
                    break;
                }
                case 6: {
                    idResId = R.id.share_platform_messenger;
                    iconResId = R.drawable.ico_share_messenger;
                    break;
                }
                case 9: {
                    idResId = R.id.share_platform_vk;
                    iconResId = R.drawable.ico_share_vk;
                    break;
                }
            }
            ivIcon.setId(idResId);
            ivIcon.setImageResource(iconResId);
            this.mShareContainer.addView((View)ivIcon, (ViewGroup.LayoutParams)lp);
            ivIcon.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void updateUIMyselfInfo(UserInfoBean myInfo) {
        if (myInfo == null) {
            return;
        }
        this.mNickName = myInfo.getNick();
        this.mDialogView.updateUIMyselfInfo(myInfo);
        this.mStreakWinShareView.updateUIMyselfInfo(myInfo);
    }

    public void updateUIWinStreak(StreakWinData data) {
        this.mStreakWinData = data;
        this.mDialogView.updateUIWinStreak(data);
        this.mStreakWinShareView.updateUIWinStreak(data);
    }

    public void onClick(View v) {
        int winStreakCount = 0;
        if (this.mStreakWinData != null) {
            winStreakCount = this.mStreakWinData.getCount();
        }
        int id2 = v.getId();
        int channel = 0;
        if (id2 == R.id.share_platform_facebook) {
            this.mStreakWinShareHelper.shareFacebook(this.mNickName, winStreakCount, false);
            channel = 1;
        } else if (id2 == R.id.share_platform_messenger) {
            channel = 7;
            this.mStreakWinShareHelper.shareMessenger(this.mNickName, winStreakCount, false);
        } else if (id2 == R.id.share_platform_instagram) {
            channel = 4;
            this.mStreakWinShareHelper.shareInstagram((View)this.mStreakWinShareView);
        } else if (id2 == R.id.share_platform_whatsapp) {
            channel = 3;
            this.mStreakWinShareHelper.shareWhatsapp((View)this.mStreakWinShareView, this.mNickName, winStreakCount, false);
        } else if (id2 == R.id.share_platform_line) {
            channel = 2;
            this.mStreakWinShareHelper.shareLine(this.mNickName, winStreakCount, false);
        } else if (id2 == R.id.share_platform_vk) {
            channel = 6;
            this.mStreakWinShareHelper.shareVK(this.mNickName, winStreakCount, false);
        } else if (id2 == R.id.iv_save_album_btn) {
            channel = 8;
            this.mStreakWinShareHelper.saveToAlbum((View)this.mStreakWinShareView, new StreakWinShareHelper.HelperListener(){

                @Override
                public void onSuccess() {
                    TopToastUtils.showSucceedToast((CharSequence)ResourceUtils.getString((int)R.string.saved_to_album_tips), (int)0);
                }

                @Override
                public void onFailed() {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.save_to_album_failed_tips), (int)0);
                }
            });
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "10").put("share_channel", String.valueOf(channel)));
    }

    public View getContentView() {
        return this;
    }

    public View getShareImage() {
        return this.mStreakWinShareView;
    }
}

