/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.yy.appbase.DR;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.api.IDRCallback;
import com.yy.hiyo.dyres.inner.DResource;
import org.jetbrains.annotations.NotNull;

public class GameMasterView
extends YYConstraintLayout {
    private static String TAG = "GameMasterView";
    private Context context;
    private YYTextView contentTv;
    private RecycleImageView iconImg;
    private DResource resourceKey = DR.icon_master_tag;

    public GameMasterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.createView();
    }

    private void createView() {
        LayoutInflater.from((Context)this.context).inflate(R.layout.game_master_layout, (ViewGroup)this);
        this.contentTv = (YYTextView)this.findViewById(R.id.tv_earn_tittle);
        this.iconImg = (RecycleImageView)this.findViewById(R.id.icon_img);
    }

    public void upDateMaster(int iconId) {
        String tittle = ResourceUtils.getString((int)R.string.short_tip_excellent);
        if (iconId == 2) {
            this.resourceKey = DR.icon_master_tag;
        } else if (iconId == 1) {
            this.resourceKey = DR.icon_super_master_tag;
        }
        DyResLoader.INSTANCE.getResFilePath(this.resourceKey, new IDRCallback(){

            public void onFailed(@NotNull String msg) {
            }

            public void onSucceed(@NotNull String filePath) {
                if (!FP.empty((CharSequence)filePath)) {
                    Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)filePath, (ImageConfig)ImageConfig.fullImageConfig(), (boolean)false);
                    if (bitmap == null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TAG, (String)"DyResLoader.icon_super_master bitmap is null", (Object[])new Object[0]);
                        }
                        return;
                    }
                    BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                    GameMasterView.this.iconImg.setImageDrawable((Drawable)drawable2);
                }
            }
        });
        this.contentTv.setText((CharSequence)tittle);
    }
}

