/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin;

import android.graphics.Bitmap;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.game.R;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.socialplatformbase.data.ShareData;
import java.io.File;
import java.util.List;

public class StreakWinShareHelper
implements ISharePage {
    private static String IKXD_PRODUCT_HOST = "https://www.kaixindou.net/a/indonesiasharepage/win.html?uid=%d&streakWin=%d&langCode=%s&h=%d&isNewUser=%d&imgShare=%s&nick=%s";
    private static String IKXD_IND_TEST_HOST = "https://test.kaixindou.net/a/indonesiasharepage/win.html?uid=%d&streakWin=%d&langCode=%s&h=%d&isNewUser=%d&imgShare=%s&nick=%s";
    private static String IKXD_SHENZHEN_TEST_HOST = "https://ikxd-test.yy.com/a/indonesiasharepage/win.html?uid=%d&streakWin=%d&langCode=%s&h=%d&isNewUser=%d&imgShare=%s&nick=%s";
    private IIntlShareService shareService;
    private HelperListener helperListener;

    public StreakWinShareHelper(IIntlShareService shareService) {
        this.shareService = shareService;
    }

    public void setHelperListener(HelperListener helperListener) {
        this.helperListener = helperListener;
    }

    public List<BaseShareChannel> getChannels() {
        return this.shareService.getChannelsByPage((ISharePage)this);
    }

    public void shareFacebook(final String nickName, final int winStreakCount, final boolean isNewUser) {
        final String shareLink = this.genShareLink(AccountUtil.getUid(), winStreakCount, isNewUser);
        final ShareData.Builder shareDataBuilder = ShareData.builder();
        shareDataBuilder.type(2);
        shareDataBuilder.to(2);
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)(isNewUser ? R.string.tip_three_win_share_content : R.string.streak_win_share_msg), (Object[])new Object[]{nickName, winStreakCount, shortUrl});
                shareDataBuilder.text(text);
                shareDataBuilder.gotoUrl(shortUrl);
                StreakWinShareHelper.this.shareService.share(5, shareDataBuilder.build());
                StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)(isNewUser ? R.string.tip_three_win_share_content : R.string.streak_win_share_msg), (Object[])new Object[]{nickName, winStreakCount, shareLink});
                shareDataBuilder.text(text);
                shareDataBuilder.gotoUrl(shareLink);
                StreakWinShareHelper.this.shareService.share(5, shareDataBuilder.build());
                StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
            }
        });
    }

    public void shareLine(final String nickName, final int winSteakCount, final boolean isNewUser) {
        final String shareLink = this.genShareLink(AccountUtil.getUid(), winSteakCount, isNewUser);
        final ShareData.Builder shareDataBuilder = ShareData.builder();
        shareDataBuilder.to(1);
        shareDataBuilder.type(0);
        shareDataBuilder.systemShare(true);
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)(isNewUser ? R.string.tip_three_win_share_content : R.string.streak_win_share_msg), (Object[])new Object[]{nickName, winSteakCount, shortUrl});
                shareDataBuilder.text(text);
                StreakWinShareHelper.this.shareService.share(1, shareDataBuilder.build());
                StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)(isNewUser ? R.string.tip_three_win_share_content : R.string.streak_win_share_msg), (Object[])new Object[]{nickName, winSteakCount, shareLink});
                shareDataBuilder.text(text);
                StreakWinShareHelper.this.shareService.share(1, shareDataBuilder.build());
                StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
            }
        });
    }

    public void shareWhatsapp(final View shareView, final String nickName, final int winSteakCount, final boolean isNewUser) {
        final String shareLink = this.genShareLink(AccountUtil.getUid(), winSteakCount, isNewUser);
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)(isNewUser ? R.string.tip_three_win_share_content : R.string.streak_win_share_msg), (Object[])new Object[]{nickName, winSteakCount, shortUrl});
                StreakWinShareHelper.this.genShareImageAndShare(shareView, 2, text);
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)(isNewUser ? R.string.tip_three_win_share_content : R.string.streak_win_share_msg), (Object[])new Object[]{nickName, winSteakCount, shareLink});
                StreakWinShareHelper.this.genShareImageAndShare(shareView, 2, text);
            }
        });
    }

    public void shareInstagram(View shareView) {
        this.genShareImageAndShare(shareView, 3, null);
    }

    public void shareMessenger(final String nickName, final int winStreakCount, boolean isNewUser) {
        final ShareData.Builder shareDataBuilder = ShareData.builder();
        shareDataBuilder.to(1);
        shareDataBuilder.type(2);
        shareDataBuilder.title(ResourceUtils.getString((int)R.string.share_default_title));
        final String shareLink = this.genShareLink(AccountUtil.getUid(), winStreakCount, isNewUser);
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)R.string.streak_win_share_msg, (Object[])new Object[]{nickName, winStreakCount, shortUrl});
                shareDataBuilder.text(text);
                shareDataBuilder.gotoUrl(shortUrl);
                StreakWinShareHelper.this.shareService.share(6, shareDataBuilder.build());
                StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)R.string.streak_win_share_msg, (Object[])new Object[]{nickName, winStreakCount, shareLink});
                shareDataBuilder.text(text);
                shareDataBuilder.gotoUrl(shareLink);
                StreakWinShareHelper.this.shareService.share(6, shareDataBuilder.build());
                StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
            }
        });
    }

    public void shareVK(final String nickName, final int winStreakCount, final boolean isNewUser) {
        final String shareLink = this.genShareLink(AccountUtil.getUid(), winStreakCount, isNewUser);
        final ShareData.Builder shareDataBuilder = ShareData.builder();
        shareDataBuilder.to(2);
        shareDataBuilder.type(2);
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)(isNewUser ? R.string.tip_three_win_share_content : R.string.streak_win_share_msg), (Object[])new Object[]{nickName, winStreakCount, shortUrl});
                shareDataBuilder.text(text);
                shareDataBuilder.gotoUrl(shortUrl);
                StreakWinShareHelper.this.shareService.share(9, shareDataBuilder.build());
                StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)(isNewUser ? R.string.tip_three_win_share_content : R.string.streak_win_share_msg), (Object[])new Object[]{nickName, winStreakCount, shareLink});
                shareDataBuilder.text(text);
                shareDataBuilder.gotoUrl(shareLink);
                StreakWinShareHelper.this.shareService.share(9, shareDataBuilder.build());
                StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
            }
        });
    }

    public void saveToAlbum(View saveView, HelperListener saveListener) {
        this.genImageAndSaveToAlbum(saveView, saveListener);
    }

    private String genShareLink(long uid, int winStreak, boolean isNewUser) {
        return this.generateShareLink(uid, winStreak, isNewUser, "", "");
    }

    public String generateShareLink(long uid, int winStreak, boolean isNewUser, String imgUrl, String nickname) {
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        String shareUrl = type == EnvSettingType.Dev ? StringUtils.formatWitUSLocal((String)IKXD_SHENZHEN_TEST_HOST, (Object[])new Object[]{uid, winStreak, SystemUtils.getLangAndCountry(), UriProvider.getIdc(), isNewUser ? 1 : 0, imgUrl, nickname}) : (type == EnvSettingType.Product ? StringUtils.formatWitUSLocal((String)IKXD_PRODUCT_HOST, (Object[])new Object[]{uid, winStreak, SystemUtils.getLangAndCountry(), UriProvider.getIdc(), isNewUser ? 1 : 0, imgUrl, nickname}) : (type == EnvSettingType.Test ? StringUtils.formatWitUSLocal((String)IKXD_IND_TEST_HOST, (Object[])new Object[]{uid, winStreak, SystemUtils.getLangAndCountry(), UriProvider.getIdc(), isNewUser ? 1 : 0, imgUrl, nickname}) : StringUtils.formatWitUSLocal((String)IKXD_PRODUCT_HOST, (Object[])new Object[]{uid, winStreak, SystemUtils.getLangAndCountry(), UriProvider.getIdc(), isNewUser ? 1 : 0, imgUrl, nickname})));
        return URLUtils.replaceUrl((String)shareUrl);
    }

    public void genShareImageAndShare(final View shareView, final int channelId, final String text) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)shareView);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, false);
                        }
                    });
                    return;
                }
                String imagePath = YYFileUtils.getYYTempDir();
                String imageName = "viewimage.png";
                FileUtils.delete((String)(imagePath + File.separator + imageName));
                final String imageFull = ViewImage.saveImgToLocal((Bitmap)bitmap, (String)imageName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.PNG);
                if (!FP.empty((CharSequence)imageFull)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ShareData.Builder shareDataBuilder = ShareData.builder();
                            shareDataBuilder.to(1);
                            shareDataBuilder.type(1);
                            shareDataBuilder.imgPath(imageFull);
                            shareDataBuilder.text(text);
                            shareDataBuilder.systemShare(true);
                            StreakWinShareHelper.this.shareService.share(channelId, shareDataBuilder.build());
                            StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
                        }
                    });
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, false);
                        }
                    });
                }
            }
        });
    }

    private void genImageAndSaveToAlbum(final View saveView, final HelperListener saveListener) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)saveView);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            StreakWinShareHelper.this.handleHelperListener(saveListener, false);
                        }
                    });
                    return;
                }
                String imagePath = YYFileUtils.getYYTempDir();
                String imageName = "winning_streak_" + System.currentTimeMillis() + ".png";
                final String saveResult = ViewImage.saveImgToAlbum((Bitmap)bitmap, (String)imageName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (boolean)true);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!FP.empty((CharSequence)saveResult)) {
                            StreakWinShareHelper.this.handleHelperListener(saveListener, true);
                            StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, true);
                        } else {
                            StreakWinShareHelper.this.handleHelperListener(saveListener, false);
                            StreakWinShareHelper.this.handleHelperListener(StreakWinShareHelper.this.helperListener, false);
                        }
                    }
                });
            }
        });
    }

    private void handleHelperListener(HelperListener listener, boolean success2) {
        if (listener == null) {
            return;
        }
        if (success2) {
            listener.onSuccess();
        } else {
            listener.onFailed();
        }
    }

    public String getPageName() {
        return "winning_streak_share";
    }

    public static interface HelperListener {
        public void onSuccess();

        public void onFailed();
    }
}

