/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin;

import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import com.yy.game.R;
import com.yy.hiyo.game.base.bean.StreakWinLevelDef;

public class StreakWinLevelHelper {
    public static final int LEVEL_1_LIMIT = 3;
    public static final int LEVEL_2_LIMIT = 5;
    public static final int LEVEL_3_LIMIT = 10;
    public static final int LEVEL_4_LIMIT = 20;

    @DrawableRes
    public static int getShareBg(int winCount) {
        if (winCount >= 20) {
            return R.drawable.streak_win_4_share;
        }
        if (winCount >= 10) {
            return R.drawable.streak_win_3_share;
        }
        if (winCount >= 5) {
            return R.drawable.streak_win_2_share;
        }
        if (winCount >= 3) {
            return R.drawable.streak_win_1_share;
        }
        return 0;
    }

    @DrawableRes
    public static int getCup(int winCount) {
        if (winCount >= 20) {
            return R.drawable.streak_win_4_cup;
        }
        if (winCount >= 10) {
            return R.drawable.streak_win_3_cup;
        }
        if (winCount >= 5) {
            return R.drawable.streak_win_2_cup;
        }
        if (winCount >= 3) {
            return R.drawable.streak_win_1_cup;
        }
        return 0;
    }

    @DrawableRes
    public static int getBanner(int winCount) {
        if (winCount >= 20) {
            return R.drawable.streak_win_4_banner_bk;
        }
        if (winCount >= 10) {
            return R.drawable.streak_win_3_banner_bk;
        }
        if (winCount >= 5) {
            return R.drawable.streak_win_2_banner_bk;
        }
        if (winCount >= 3) {
            return R.drawable.streak_win_1_banner_bk;
        }
        return 0;
    }

    @StringRes
    public static int getLevelString(int winCount) {
        if (winCount >= 20) {
            return R.string.play_level_outstanding;
        }
        if (winCount >= 10) {
            return R.string.play_level_awesome;
        }
        if (winCount >= 5) {
            return R.string.play_level_excellent;
        }
        if (winCount >= 3) {
            return R.string.play_level_good;
        }
        return 0;
    }

    @ColorRes
    public static int getAvatarStrokeColor(int winCount) {
        if (winCount >= 20) {
            return R.color.streak_win_4_color;
        }
        if (winCount >= 10) {
            return R.color.streak_win_3_color;
        }
        if (winCount >= 5) {
            return R.color.streak_win_2_color;
        }
        if (winCount >= 3) {
            return R.color.streak_win_1_color;
        }
        return 0;
    }

    public static int getStreakWinLevel(int winCount) {
        return StreakWinLevelDef.getStreakWinLevel((int)winCount);
    }
}

