/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.game.module.streakwin.StreakWinShareHelper;
import com.yy.game.module.streakwin.ui.StreakWinDialogPage;
import com.yy.hiyo.game.base.streakwin.StreakWinData;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.IShareDialogViewProvider;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class StreakWinDialogController
extends DefaultController
implements StreakWinShareHelper.HelperListener {
    private StreakWinShareHelper streakWinShareHelper;
    private StreakWinDialogPage streakWinDialogPage;

    public StreakWinDialogController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        if (msg.what == BaseMsgDef.SHOW_WINNING_STREAK_DIALOG) {
            this.handleShowStreakWinDialog(msg);
        }
    }

    private void handleShowStreakWinDialog(Message msg) {
        Bundle bundle = msg.getData();
        if (bundle != null) {
            final String data = msg.getData().getString("winning_streak_data");
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    final StreakWinData streakWinData = (StreakWinData)JsonParser.parseJsonObject((String)data, StreakWinData.class);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            StreakWinDialogController.this.showStreakWinDialog(streakWinData);
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024413").put("function_id", "msg_click").put("win_times", String.valueOf(streakWinData.getCount())));
                        }
                    });
                }
            });
        }
    }

    private void showStreakWinDialog(StreakWinData data) {
        if (this.streakWinDialogPage == null) {
            this.streakWinShareHelper = new StreakWinShareHelper((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class));
            this.streakWinShareHelper.setHelperListener(this);
            this.streakWinDialogPage = new StreakWinDialogPage((Context)this.mContext, this.streakWinShareHelper);
        }
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).showShareCenterDialog((IShareDialogViewProvider)this.streakWinDialogPage, new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog2) {
                StreakWinDialogController.this.streakWinDialogPage = null;
            }
        });
        UserInfoBean userInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
        if (userInfo != null) {
            this.streakWinDialogPage.updateUIMyselfInfo(userInfo);
        }
        if (data != null) {
            this.streakWinDialogPage.updateUIWinStreak(data);
        }
    }

    @Override
    public void onSuccess() {
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).closeShareDialog();
    }

    @Override
    public void onFailed() {
    }
}

