/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.streakwin;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.game.bean.GameDataModel;
import com.yy.game.module.streakwin.IStreakWinUICallbacks;
import com.yy.game.module.streakwin.StreakWinShareHelper;
import com.yy.game.module.streakwin.ui.StreakWinWindow;
import com.yy.hiyo.game.base.GameResultBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.helper.GameResultHelper;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.voice.base.roomvoice.AbsVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.IRoomManagerService;
import com.yy.hiyo.voice.base.roomvoice.RoomSlot;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.gameresult.PKWinStreakPush;
import java.util.ArrayList;

public class StreakWinController
extends DefaultWindowController
implements IStreakWinUICallbacks {
    public static final String TAG = "StreakWinController";
    private StreakWinWindow mStreakWinWindow;
    private PKWinStreakPush mWinStreakData;
    private IStreakWinControlCallback mCb;
    private boolean showThreeWin = false;
    private GameResultBean gameResultBean;
    private int shareType;
    private int iconId;
    IRoomManagerService mRoomService;
    RoomSlot<AbsVoiceRoom> mRoomSlot;
    String mSessionId;

    public StreakWinController(Environment env, IStreakWinControlCallback cb) {
        super(env);
        this.mCb = cb;
        this.mRoomService = (IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
    }

    public void initSteakWin(GameResultBean gameResultBean, int shareGameMaster, int masterType) {
        this.iconId = masterType;
        this.initSteakWin(gameResultBean, shareGameMaster);
    }

    public void initSteakWin(GameResultBean gameResultBean, int shareType) {
        if (this.getCurrentWindow() instanceof StreakWinWindow) {
            return;
        }
        this.shareType = shareType;
        if (gameResultBean == null) {
            return;
        }
        this.gameResultBean = gameResultBean;
        this.mSessionId = gameResultBean.getSessionId();
        if (this.mStreakWinWindow == null) {
            StreakWinShareHelper helper = new StreakWinShareHelper((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class));
            this.mStreakWinWindow = new StreakWinWindow((Context)this.mContext, helper, this);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mStreakWinWindow, true);
    }

    private static boolean isShowWindowForStreakCount(int winStreakCount) {
        return winStreakCount == 3 || winStreakCount == 5 || winStreakCount % 10 == 0;
    }

    public Object handleMessageSync(Message msg) {
        return null;
    }

    public boolean isStreakWinShow(GameResultBean gameResultBean) {
        if (GameDataModel.instance.getWinStreakData() == null) {
            return false;
        }
        this.mWinStreakData = GameDataModel.instance.getWinStreakData();
        int winstreak = (int)(this.mWinStreakData.win_streak_count + 1L);
        return gameResultBean != null && GameResultHelper.imWin((GameResultBean)gameResultBean) && StreakWinController.isShowWindowForStreakCount(winstreak);
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        if (abstractWindow == this.mStreakWinWindow) {
            this.closeWindow(abstractWindow);
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.mStreakWinWindow = null;
        if (this.mRoomSlot != null) {
            ((IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class)).leaveRoom(this.mRoomSlot, 5);
            this.mSessionId = "";
        }
        this.unregisterFromMsgDispatcher();
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (this.mWinStreakData != null && this.gameResultBean != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024413").put("function_id", "show").put("gid", this.gameResultBean.getGameID()).put("win_times", String.valueOf(this.mWinStreakData.win_streak_count + 1L)));
        }
    }

    @Override
    public int getLastStreakWincount() {
        return this.mWinStreakData != null ? this.mWinStreakData.win_streak_count.intValue() : 0;
    }

    @Override
    public void closeStreakWindow() {
        if (this.mCb != null) {
            this.mCb.onCloseStreakWinWindow();
        }
        if (this.mWinStreakData != null && this.gameResultBean != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024413").put("function_id", "continue_click").put("gid", this.gameResultBean.getGameID()).put("win_times", String.valueOf(this.mWinStreakData.win_streak_count + 1L)));
        }
    }

    @Override
    public GameResultBean getResultBean() {
        return this.gameResultBean;
    }

    @Override
    public IIntlShareService getShareService() {
        return (IIntlShareService)this.getServiceManager().getService(IIntlShareService.class);
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        if (this.mStreakWinWindow != null) {
            UserInfoBean userInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
            if (userInfo != null) {
                this.mStreakWinWindow.updateUIMyselfInfo(userInfo);
            }
            if (this.shareType == 2) {
                IGameInfoService service = (IGameInfoService)this.getServiceManager().getService(IGameInfoService.class);
                ArrayList<GameInfo> list = new ArrayList<GameInfo>();
                if (service != null) {
                    list.add(service.getGameInfoByGid("yangyangdazuozhan_yn"));
                    list.add(service.getGameInfoByGid("feidao_yn"));
                    list.add(service.getGameInfoByGid("ludoduliyouxi_yn"));
                }
                this.mStreakWinWindow.showThreeWin(3, list);
            } else if (this.shareType == 3) {
                this.mStreakWinWindow.showGameMaster(this.iconId);
            } else if (this.mWinStreakData != null) {
                this.mStreakWinWindow.updateUIWinStreak(this.mWinStreakData);
            }
            if (StringUtils.isNotEmpty((String)this.mSessionId)) {
                this.mRoomSlot = ((IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class)).joinRoom(this.mSessionId, 1, null);
            }
        }
    }

    public void onWindowExitEvent(boolean withAnimation) {
        if (this.mCb != null) {
            this.mCb.onCloseStreakWinWindow();
        }
    }

    @Override
    public void share(int streakWinCount, boolean isNewUser, int channelId) {
        this.sendMessage(BaseMsgDef.MSG_SHARE_STREAK_WIN, channelId, isNewUser ? 1 : 0, streakWinCount);
    }

    @Override
    public void shareMaster(int masterType, int channelId) {
        this.sendMessage(BaseMsgDef.MSG_SHARE_GAME_MASTER, channelId, masterType);
    }

    private void closeWindow(AbstractWindow abstractWindow) {
        if (abstractWindow == this.mStreakWinWindow) {
            StreakWinWindow window = this.mStreakWinWindow;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable((AbstractWindow)window){
                final /* synthetic */ AbstractWindow val$window;
                {
                    this.val$window = abstractWindow;
                }

                @Override
                public void run() {
                    if (this.val$window != null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)StreakWinController.TAG, (String)"onWindowHidden_popWindow", (Object[])new Object[0]);
                        }
                        StreakWinController.this.mWindowMgr.popWindow(false, (AbstractWindow)StreakWinController.this.mStreakWinWindow);
                    }
                }
            });
        }
    }

    public static interface IStreakWinControlCallback {
        public void onCloseStreakWinWindow();
    }
}

