/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.remotedebug.game;

import android.content.Context;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.LinearLayout;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.download.version.GameVersion;
import com.yy.game.module.remotedebug.game.EnvGameExpandableListAdapter;
import com.yy.game.module.remotedebug.game.EnvGameSettingController;
import com.yy.game.module.remotedebug.game.EnvGameSettingItem;
import com.yy.game.module.remotedebug.game.IItemClick;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnvGameSettingWindow
extends DefaultWindow
implements IItemClick {
    private static final String TAG = "EnvGameSettingWindow";
    private EnvGameSettingController mUiCallback;
    private View mRootView;
    private SimpleTitleBar mTitleBar;
    private LinearLayout mContainer;
    private ExpandableListView mDirList;
    private EnvGameExpandableListAdapter mAdapter;
    private final List<String> mDirs = new ArrayList<String>(2);
    private final Map<String, List<EnvGameSettingItem>> mItemPath = new HashMap<String, List<EnvGameSettingItem>>(2);
    private static final Comparator<EnvGameSettingItem> COMPARATOR = new Comparator<EnvGameSettingItem>(){

        @Override
        public int compare(EnvGameSettingItem o1, EnvGameSettingItem o2) {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            long dif = o2.lastModified - o1.lastModified;
            if (dif == 0L) {
                dif = o2.size - o1.size;
                return dif == 0L ? 0 : (dif > 0L ? 1 : -1);
            }
            return dif > 0L ? 1 : -1;
        }
    };

    public EnvGameSettingWindow(Context context, UICallBacks callBacks) {
        super(context, callBacks, "EnvGameSetting");
        this.mUiCallback = (EnvGameSettingController)callBacks;
        this.createView(context);
    }

    private void createView(Context context) {
        this.mRootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_env_game_setting, null);
        this.getBaseLayer().addView(this.mRootView);
        this.mContainer = (LinearLayout)this.mRootView.findViewById(R.id.env_game_container);
        this.mTitleBar = (SimpleTitleBar)this.mRootView.findViewById(R.id.title_bar);
        this.mDirList = (ExpandableListView)this.mRootView.findViewById(R.id.dir_exlist);
        this.mAdapter = new EnvGameExpandableListAdapter();
        this.mDirList.setAdapter((ExpandableListAdapter)this.mAdapter);
        this.mAdapter.setOnClick(this);
        this.mTitleBar.setTitlte("\u6e38\u620f\u8bbe\u7f6e");
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                EnvGameSettingWindow.this.mUiCallback.onBackClicked();
            }
        });
        this.getData();
    }

    private void getData() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                EnvGameSettingWindow.this.getPath();
            }
        }, (Runnable)new Runnable(){

            @Override
            public void run() {
                EnvGameSettingWindow.this.mAdapter.setData(EnvGameSettingWindow.this.mDirs, EnvGameSettingWindow.this.mItemPath);
            }
        });
    }

    private void getPath() {
        this.mDirs.clear();
        this.mItemPath.clear();
        String sdDir = GameDownloadUtils.getAppGameDir();
        List<EnvGameSettingItem> list = this.getSubFiles(sdDir);
        if (!FP.empty(list)) {
            this.mDirs.add(sdDir);
            Collections.sort(list, COMPARATOR);
        }
        this.mItemPath.put(sdDir, list);
    }

    private List<EnvGameSettingItem> getSubFiles(String parent) {
        File[] files;
        if (FP.empty((CharSequence)parent)) {
            return null;
        }
        ArrayList<EnvGameSettingItem> list = new ArrayList<EnvGameSettingItem>();
        File file = new File(parent);
        MLog.debug((Object)TAG, (String)"getSubFiles parent: %s", (Object[])new Object[]{parent});
        if (file.exists() && file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                File[] subFiles;
                MLog.debug((Object)TAG, (String)"getSubFiles source : %s", (Object[])new Object[]{f.getAbsolutePath()});
                if (!f.isDirectory() || (subFiles = f.listFiles()) == null || subFiles.length == 0) continue;
                for (File subFile : subFiles) {
                    if (subFile == null || !subFile.exists() || !subFile.getName().endsWith(".pkg")) continue;
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)TAG, (String)"get file name: %s", (Object[])new Object[]{subFile.getAbsolutePath()});
                    }
                    String name = subFile.getName().replace(".pkg", "");
                    String version = name.replace(f.getName() + "_", "");
                    EnvGameSettingItem item = new EnvGameSettingItem();
                    item.gameId = f.getName();
                    item.version = version;
                    item.lastModified = subFile.lastModified();
                    item.size = FileUtils.getFileSize((File)subFile);
                    list.add(item);
                }
            }
        }
        return list;
    }

    @Override
    public void onGroupDelete(final String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u5373\u5c06\u91cd\u542f\u5e94\u7528", (int)1);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                File dir = new File(path);
                YYFileUtils.delete((File)dir);
                YYTaskExecutor.postToMainThread(() -> {
                    Message msg = Message.obtain();
                    msg.what = BaseMsgDef.APP_EXIT;
                    msg.obj = true;
                    MsgDispatcher.getInstance().sendMessageSync(msg);
                }, (long)500L);
            }
        });
    }

    @Override
    public void onItemDelete(final String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                EnvGameSettingWindow.this.deleteGame(path);
            }
        });
        this.getData();
    }

    private boolean deleteGame(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return true;
        }
        String appDir = GameDownloadUtils.getAppGameDir();
        if (path.startsWith(appDir)) {
            String gameId = path.replace(appDir, "");
            GameVersion.INSTANCE.deleteGame(gameId, true, true);
            GameInfo info = ((IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)).getGameInfoByGid(gameId);
            if (info != null) {
                info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_not);
            }
        }
        YYFileUtils.delete((File)new File(path));
        return false;
    }
}

