/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.remotedebug.game;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.TextView;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.game.R;
import com.yy.game.module.remotedebug.game.EnvGameSettingItem;
import com.yy.game.module.remotedebug.game.IItemClick;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnvGameExpandableListAdapter
extends BaseExpandableListAdapter {
    private final List<String> gData = new ArrayList<String>();
    private final Map<String, List<EnvGameSettingItem>> iData = new HashMap<String, List<EnvGameSettingItem>>();
    private IItemClick mClick;

    public void setData(List<String> gData, Map<String, List<EnvGameSettingItem>> iData) {
        this.gData.clear();
        this.iData.clear();
        if (gData != null) {
            this.gData.addAll(gData);
        }
        if (iData != null) {
            this.iData.putAll(iData);
        }
        this.notifyDataSetChanged();
    }

    public void setOnClick(IItemClick click) {
        this.mClick = click;
    }

    public int getGroupCount() {
        return this.gData.size();
    }

    public int getChildrenCount(int groupPosition) {
        if (this.iData.get(this.gData.get(groupPosition)) == null) {
            return 0;
        }
        return this.iData.get(this.gData.get(groupPosition)).size();
    }

    public String getGroup(int groupPosition) {
        return this.gData.get(groupPosition);
    }

    public EnvGameSettingItem getChild(int groupPosition, int childPosition) {
        return this.iData.get(this.gData.get(groupPosition)).get(childPosition);
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return false;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        ViewHolderGroup groupHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_env_game_exlist_group, parent, false);
            groupHolder = new ViewHolderGroup(convertView);
            convertView.setTag((Object)groupHolder);
            groupHolder.delete.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String path = (String)v.getTag();
                    if (EnvGameExpandableListAdapter.this.mClick != null) {
                        EnvGameExpandableListAdapter.this.mClick.onGroupDelete(path);
                    }
                }
            });
        } else {
            groupHolder = (ViewHolderGroup)convertView.getTag();
        }
        String path = this.gData.get(groupPosition);
        groupHolder.tvGroupPath.setText((CharSequence)path);
        groupHolder.delete.setTag((Object)path);
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ViewHolderItem itemHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_env_game_exlist_item, parent, false);
            itemHolder = new ViewHolderItem(convertView);
            convertView.setTag((Object)itemHolder);
            itemHolder.delete.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String path = (String)v.getTag();
                    if (EnvGameExpandableListAdapter.this.mClick != null) {
                        EnvGameExpandableListAdapter.this.mClick.onItemDelete(path);
                    }
                }
            });
        } else {
            itemHolder = (ViewHolderItem)convertView.getTag();
        }
        EnvGameSettingItem item = this.iData.get(this.gData.get(groupPosition)).get(childPosition);
        String path = item.gameId;
        itemHolder.tvPath.setText((CharSequence)path);
        itemHolder.version.setText((CharSequence)("version: " + item.version));
        itemHolder.size.setText((CharSequence)("size: " + YYFileUtils.getFileSizeInMBytes((long)item.size)));
        itemHolder.date.setText((CharSequence)TimeUtils.getTimeStringFromMillis((long)item.lastModified));
        itemHolder.delete.setTag((Object)(this.gData.get(groupPosition) + path));
        return convertView;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    private static class ViewHolderItem {
        private TextView tvPath;
        private TextView delete;
        private TextView version;
        private TextView date;
        private TextView size;

        ViewHolderItem(View itemView) {
            this.tvPath = (TextView)itemView.findViewById(R.id.dir_path);
            this.delete = (TextView)itemView.findViewById(R.id.delete);
            this.version = (TextView)itemView.findViewById(R.id.version);
            this.date = (TextView)itemView.findViewById(R.id.time);
            this.size = (TextView)itemView.findViewById(R.id.size);
        }
    }

    private static class ViewHolderGroup {
        private TextView tvGroupPath;
        private TextView delete;

        ViewHolderGroup(View itemView) {
            this.tvGroupPath = (TextView)itemView.findViewById(R.id.dir_path);
            this.delete = (TextView)itemView.findViewById(R.id.delete);
        }
    }
}

