/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.remotedebug;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.widget.SwitchButton;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.module.remotedebug.RemoteDebugController;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.callback.IGameDownloadCallback;

public class RemoteDebugPager
extends YYFrameLayout
implements IGameDownloadCallback {
    private RemoteDebugController mUICallBacks;
    private View view;
    private TextView tips;
    private SimpleTitleBar mTitleBar;
    private Button remoteButton;

    public RemoteDebugPager(Context context, UICallBacks callBacks) {
        super(context);
        this.mUICallBacks = (RemoteDebugController)callBacks;
        this.createView(context);
    }

    private void createView(Context context) {
        this.view = LayoutInflater.from((Context)context).inflate(R.layout.activity_remote_debug, (ViewGroup)this);
        this.initView();
    }

    private void initView() {
        this.initTitleBar();
        this.initGameRemoteEnv();
    }

    private void initTitleBar() {
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.mTitleBar.setLeftTitle("RemoteDebug");
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, v -> this.mUICallBacks.finish());
    }

    private void initGameRemoteEnv() {
        final EditText gameUrlV = (EditText)this.view.findViewById(R.id.game_download_url);
        TextView uidV = (TextView)this.view.findViewById(R.id.hago_uid);
        gameUrlV.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String host = gameUrlV.getText().toString();
                if (Patterns.IP_ADDRESS.matcher(host).matches()) {
                    RemoteDebugPager.this.mUICallBacks.updateHost(host);
                    SettingFlags.setStringValue((String)"envgameremotelianyunip", (String)host);
                }
            }
        });
        gameUrlV.setText((CharSequence)SettingFlags.getStringValue((String)"envgameremotelianyunip", null));
        this.mUICallBacks.updateHost(gameUrlV.getText().toString());
        uidV.setText((CharSequence)String.format("uid:%d", AccountUtil.getUid()), null);
        this.tips = (TextView)this.view.findViewById(R.id.remote_debug_tips);
        SwitchButton switchButton = (SwitchButton)this.view.findViewById(R.id.remote_screen_switch);
        switchButton.setChecked(SettingFlags.getBoolean((String)"envgameremotescreen", (boolean)false));
        this.view.findViewById(R.id.copy_uid_button).setOnClickListener(v -> this.copyToClipboard(String.format("%d", AccountUtil.getUid())));
        this.mUICallBacks.updateHorizontal(switchButton.isChecked());
        switchButton.setOnCheckedChangeListener((view, isChecked, isChangeByTouch) -> {
            SettingFlags.setBoolean((String)"envgameremotescreen", (boolean)switchButton.isChecked());
            this.mUICallBacks.updateHorizontal(isChecked);
        });
        this.remoteButton = (Button)this.view.findViewById(R.id.start_remote_debug);
        this.hostNotAvailable();
        this.remoteButton.setOnClickListener(v -> this.mUICallBacks.start(switchButton.isChecked(), this));
    }

    private boolean copyToClipboard(String text) {
        try {
            int sdk = Build.VERSION.SDK_INT;
            if (sdk < 11) {
                Context context = this.view.getContext();
                this.view.getContext();
                android.text.ClipboardManager clipboard = (android.text.ClipboardManager)context.getSystemService("clipboard");
                clipboard.setText((CharSequence)text);
            } else {
                Context context = this.view.getContext();
                this.view.getContext();
                ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"Label", (CharSequence)text);
                clipboard.setPrimaryClip(clip);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void showError(String message) {
        this.getHandler().post(() -> {
            ToastUtils.showToast((Context)this.view.getContext(), (String)message, (int)0);
            RemoteGameDebugService.Companion.writeLog(message);
            this.tips.setText((CharSequence)message);
            this.tips.setTextColor(this.tips.getResources().getColor(R.color.color_red));
        });
    }

    public void onDownloadBegin(BasicGameInfo info) {
        this.remoteButton.setEnabled(false);
        this.remoteButton.setText((CharSequence)"Downloading Game");
    }

    public void onDownloadError(BasicGameInfo gameInfo, int code, String msg) {
        this.remoteButton.setEnabled(false);
        this.remoteButton.setText((CharSequence)"Download Error");
        this.showMessage("Download fail " + code + ", " + msg);
    }

    public void onDownloadSucceed(BasicGameInfo info) {
        this.showMessage("Download Game Success");
    }

    public void showMessage(String message) {
        RemoteGameDebugService.Companion.writeLog(message);
        ToastUtils.showToast((Context)this.getContext(), (String)message, (int)0);
    }

    public void usbDebugAvailable() {
        this.remoteButton.setEnabled(true);
        this.remoteButton.setText((CharSequence)"Start Usb Debug");
    }

    public void hostAvailable() {
        this.remoteButton.setEnabled(true);
        this.remoteButton.setText((CharSequence)"Start Wifi Debug");
    }

    public void hostNotAvailable() {
        this.remoteButton.setEnabled(false);
        this.remoteButton.setText((CharSequence)"Ip not reachable by wifi or not usb debuggable");
    }
}

