/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.remotedebug;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.gamemodule.loader.WebGameLoader;
import com.yy.game.module.remotedebug.RemoteDebugWindow;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugCallback;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.GameBaseMsgDef;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.DownloadGameErrorInfo;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.callback.IGameDownloadCallback;
import com.yy.hiyo.game.base.singlegame.indie.IndieGamePlayContext;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.home.base.GameExtraInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class RemoteDebugController
extends DefaultWindowController
implements IGameDownloadCallback,
RemoteGameDebugCallback {
    private RemoteDebugWindow mWindow;
    private RemoteGameDebugService remoteService;
    private Map<String, IGameDownloadCallback> mDownloadCallbacks;
    private static final String TAG = RemoteDebugController.class.getSimpleName();
    private GameInfo mGameInfo;
    private boolean mHorizontal = false;
    private String mGameId = null;
    private boolean mUseUsb = false;
    private String mPackageUrl = null;
    private String mMd5 = null;
    private boolean mDownloaded = false;
    static final IGameDownloadCallback EMPTY = new SimpleDownloadCallback();

    public RemoteDebugController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.GAME_DOWNLOAD_FINISH, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.GAME_DOWNLOAD_ERROR, (INotify)this);
    }

    public void handleMessage(Message msg) {
        if (msg == null) {
            return;
        }
        if (msg.what == GameBaseMsgDef.SHOW_REMOTE_DEBUG_WINDOW) {
            if (this.mWindow == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"RemoteDebugController SHOW_REMOTE_DEBUG_WINDOW", (Object[])new Object[0]);
                }
                this.remoteService = new RemoteGameDebugService((RemoteGameDebugCallback)this);
                this.mWindow = new RemoteDebugWindow((Context)this.mContext, (UICallBacks)this);
                WebGameLoader.Companion.setFileLoadSequence();
                this.updateDebugAble();
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        }
    }

    public void onWindowDetach(AbstractWindow window) {
        if (window == this.mWindow) {
            this.mWindow = null;
        }
        this.finish();
    }

    public void onBackClicked() {
        this.finish();
        this.mWindowMgr.popWindow(true);
    }

    public void finish() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"RemoteDebugController finish", (Object[])new Object[0]);
        }
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
        if (this.remoteService != null) {
            this.remoteService.destroy();
        }
        WebGameLoader.Companion.clearFileLoadSequence();
        NotificationCenter.getGlobalInstance().unregister(NotificationIdDef.GAME_DOWNLOAD_FINISH, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationIdDef.GAME_DOWNLOAD_ERROR, (INotify)this);
    }

    private void downloadGame(String mMd5, String mPackageUrl) {
        if (this.mGameInfo != null && mPackageUrl.equals(this.mGameInfo.getModulerUrl())) {
            this.updateDebugAble();
            return;
        }
        GameInfo serverInfo = ((IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)).getGameInfoByGid(this.mGameId);
        GameInfo.Builder builder = GameInfo.newBuilder((GameInfoSource)GameInfoSource.DEBUG);
        builder.gid(this.mGameId);
        builder.defLang("en-us");
        builder.gname("RemoteDebug");
        builder.desc("RemoteDebug");
        builder.iconUrl("https://o-id.ihago.net/lianyundemo_yn1544612635.png");
        builder.screenDire(1);
        builder.rootTemplate(1);
        builder.modulerUrl(mPackageUrl);
        builder.modulerMd5(mMd5);
        builder.modulerVer("" + System.currentTimeMillis() / 1000L);
        builder.voiceType(1);
        builder.screenDire(this.mHorizontal ? 2 : 1);
        builder.gameType(2);
        builder.gameMode(9);
        builder.socketType(2);
        builder.langList(Arrays.asList("id", "en-us", "hi", "th", "vi", "pt-br", "ar", "ja"));
        if (serverInfo != null) {
            builder.gameMode(serverInfo.getGameMode());
            builder.gameType(serverInfo.getGameType());
            builder.defLang(serverInfo.getDefLang());
            if (serverInfo.getLangList() != null && serverInfo.getLangList().size() > 0) {
                builder.langList(serverInfo.getLangList());
            }
        } else if (this.mWindow != null) {
            this.mWindow.showMessage("error : Can't get game info from server, try use test environment");
        }
        if (serverInfo == null || serverInfo.getGameMode() == 9) {
            builder.socketType(2);
        } else {
            builder.socketType(1);
        }
        this.mGameInfo = builder.build();
        if (this.mWindow != null) {
            RemoteGameDebugService.Companion.writeLog("download begin " + this.mGameInfo.getModulerUrl());
            this.mWindow.getEnvSettingPager().onDownloadBegin((BasicGameInfo)this.mGameInfo);
        }
        this.downloadGame(this.mGameInfo, this);
    }

    public void start(boolean horizontal, IGameDownloadCallback callback2) {
        this.internalStart(this.mGameInfo);
    }

    private void internalStart(@Nonnull GameInfo gameInfo) {
        switch (gameInfo.getGameMode()) {
            case 9: {
                GamePlayContext context = new GamePlayContext(GameContextDef.JoinFrom.FROM_DEFAULT);
                context.setGameInfo(gameInfo);
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, context);
                break;
            }
            case 1: {
                this.startPk(gameInfo, null);
                break;
            }
            case 6: {
                this.starIndie(gameInfo, null);
                break;
            }
            default: {
                MLog.error((Object)TAG, (String)"unknown game mode %d", (Object[])new Object[]{gameInfo.getGameMode()});
            }
        }
    }

    private void starIndie(GameInfo gameInfo, GameExtraInfo extraInfo) {
        String roomId = "";
        boolean createNewIfNoRoom = false;
        if (extraInfo != null) {
            roomId = extraInfo.getRoomId();
            createNewIfNoRoom = extraInfo.isCreateNewIfNoRoom();
        }
        IndieGamePlayContext playContext = new IndieGamePlayContext.Builder(GameContextDef.JoinFrom.FROM_HOME).roomId(roomId).build();
        if (extraInfo != null) {
            String extend = extraInfo.getExtend();
            if (StringUtils.isNotEmpty((String)extend)) {
                playContext.addExtendValue("extend_from_h5", (Object)extend);
            }
            playContext.addExtendValue("createNewIfNoRoom", (Object)createNewIfNoRoom);
        }
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, (GamePlayContext)playContext);
    }

    private void startPk(GameInfo gameInfo, GameExtraInfo extraInfo) {
        GameMatchContext gameMatchContext = new GameMatchContext(GameContextDef.JoinFrom.FROM_HOME);
        if (gameInfo.getExt() != null) {
            gameMatchContext.addAllKV(gameInfo.getExt());
        }
        if (extraInfo != null) {
            gameMatchContext.addExtendValue("isMatchAi", (Object)extraInfo.isMatchAi());
            gameMatchContext.addExtendValue("matchAiSex", (Object)extraInfo.getMatchAiSex());
            gameMatchContext.addExtendValue("matchTargetUid", (Object)extraInfo.getTargetUid());
        }
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).matchGame(gameInfo, gameMatchContext, null);
    }

    private void downloadGame(GameInfo gameInfo, IGameDownloadCallback callback2) {
        this.addCallback(gameInfo.getGid(), callback2);
        this.downloadGameInner(gameInfo);
    }

    private void downloadGameInner(GameInfo gameInfo) {
        IGameDownloadCallback callback2 = this.getCallback(gameInfo.getGid());
        callback2.onDownloadBegin((BasicGameInfo)gameInfo);
        gameInfo.downloadInfo.setFrom(GameDownloadInfo.DownloadFrom.home);
        boolean isDownload = ((IGameService)this.getServiceManager().getService(IGameService.class)).isGamePkgValid(gameInfo);
        if (isDownload) {
            this.mDownloaded = true;
            this.updateDebugAble();
        } else {
            ((IGameService)this.getServiceManager().getService(IGameService.class)).downloadGame(gameInfo, GameDownloadInfo.DownloadType.by_hand);
            ((IGameService)this.getServiceManager().getService(IGameService.class)).preLoadGamePage(gameInfo.getGid());
        }
    }

    public void onDownloadBegin(BasicGameInfo info) {
    }

    public void onDownloadSucceed(BasicGameInfo info) {
    }

    public void onDownloadError(BasicGameInfo gameInfo, int code, String msg) {
        IGameDownloadCallback callback2 = this.getCallback(gameInfo.getGid());
        if (callback2 != this) {
            callback2.onDownloadError(gameInfo, code, msg);
        }
        this.removeCallback(gameInfo.getGid());
    }

    private void updateDebugAble() {
        if (this.mWindow != null && this.mMd5 != null && this.mDownloaded) {
            if (this.mUseUsb) {
                this.mWindow.getEnvSettingPager().usbDebugAvailable();
            } else {
                this.mWindow.getEnvSettingPager().hostAvailable();
            }
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        int id2 = notification.id;
        if (id2 == NotificationIdDef.GAME_DOWNLOAD_FINISH) {
            if (notification.extObj instanceof GameInfo) {
                MLog.debug((Object)TAG, (String)" NotificationIdDef.GAME_DOWNLOAD_FINISH", (Object[])new Object[0]);
                GameInfo info = (GameInfo)notification.extObj;
                if (info.gid.equals(this.mGameId)) {
                    this.mDownloaded = true;
                    this.updateDebugAble();
                }
            }
        } else if (id2 == NotificationIdDef.GAME_DOWNLOAD_ERROR && notification.extObj instanceof DownloadGameErrorInfo) {
            MLog.debug((Object)TAG, (String)" NotificationIdDef.GAME_DOWNLOAD_ERROR", (Object[])new Object[0]);
            DownloadGameErrorInfo error = (DownloadGameErrorInfo)notification.extObj;
            this.onDownloadError(error.gameInfo, error.code, error.msg);
            if (error.gameInfo.gid.equals(this.mGameId)) {
                this.mDownloaded = false;
                this.mWindow.getEnvSettingPager().onDownloadError(error.gameInfo, error.code, error.msg);
            }
        }
    }

    private void addCallback(String gameId, IGameDownloadCallback callback2) {
        if (this.mDownloadCallbacks == null) {
            this.mDownloadCallbacks = new HashMap<String, IGameDownloadCallback>(4);
        }
        this.mDownloadCallbacks.put(gameId, callback2);
    }

    @Nonnull
    private IGameDownloadCallback getCallback(String gameId) {
        if (FP.empty((CharSequence)gameId) || this.mDownloadCallbacks == null || this.mDownloadCallbacks.get(gameId) == null) {
            return EMPTY;
        }
        IGameDownloadCallback callback2 = this.mDownloadCallbacks.get(gameId);
        return callback2 != null ? callback2 : EMPTY;
    }

    private void removeCallback(String gameId) {
        if (this.mDownloadCallbacks != null && !FP.empty((CharSequence)gameId)) {
            this.mDownloadCallbacks.remove(gameId);
        }
    }

    public void updateHost(String host) {
        this.remoteService.updateDebugHost(host);
    }

    public void updateHorizontal(boolean isChecked) {
        this.mHorizontal = isChecked;
        if (this.mGameInfo != null) {
            this.mGameInfo.setScreenDir(this.mHorizontal ? 2 : 1);
        }
    }

    public void onReady(@NotNull String gameId, @NotNull String packageMd5, @NotNull String debugHost, int debugType) {
        if (packageMd5 != null && !packageMd5.equals(this.mMd5)) {
            GameInfo serverInfo;
            if (this.mWindow != null) {
                this.mWindow.showMessage("newer version detected");
            }
            this.mGameId = gameId;
            this.mMd5 = packageMd5;
            boolean bl = this.mUseUsb = debugType == 1;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("remote gameId onReady: " + this.mGameId + " " + this.mMd5), (Object[])new Object[0]);
            }
            if ((serverInfo = ((IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)).getGameInfoByGid(gameId)) != null && serverInfo.getGameType() == 3) {
                this.mPackageUrl = RemoteGameDebugService.Companion.replaceDownloadUrl(".pkg", gameId);
            } else {
                if (serverInfo == null) {
                    this.mWindow.showMessage("error game has no server info check if your app env is Test");
                }
                this.mPackageUrl = RemoteGameDebugService.Companion.replaceDownloadUrl(".zip", gameId);
            }
            this.downloadGame(packageMd5, this.mPackageUrl);
        }
    }

    public void onFail(@NotNull String message) {
        this.mWindow.showError("remoteDebugService fail" + message);
    }

    public static class SimpleDownloadCallback
    implements IGameDownloadCallback {
        static final IGameDownloadCallback EMPTY = new SimpleDownloadCallback();

        public void onDownloadBegin(BasicGameInfo info) {
        }

        public void onDownloadError(BasicGameInfo gameInfo, int code, String msg) {
        }

        public void onDownloadSucceed(BasicGameInfo info) {
        }
    }
}

