/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.matchgame.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Build;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.BubbleTextView;
import com.yy.appbase.ui.widget.bubble.RelativePos;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.module.gameroom.ui.BallTwinkleProgressBar;
import com.yy.game.module.matchgame.I2v2GameMatchInterface;
import com.yy.game.module.matchgame.IMatchGameUICallbacks;
import com.yy.game.module.matchgame.ui.AllGameMatchPager;
import com.yy.hiyo.game.base.bean.GameDef;
import java.util.List;

public class TwoVsTwoMatchPager
extends AllGameMatchPager
implements I2v2GameMatchInterface {
    private static final long SVGA_DELAY_TIME = 500L;
    private static final long SVGA_FINISH_DELAY_TIME = 700L;
    private static final long SVGA_FINISH_TIME_OUT_TIME = 2000L;
    private HeadFrameImageView mMineleftHead;
    private HeadFrameImageView mMineRightHead;
    private HeadFrameImageView mOtherLeftHead;
    private HeadFrameImageView mOtherRightHead;
    private RecycleImageView mMineleftSex;
    private RecycleImageView mMineRightSex;
    private RecycleImageView mOtherLeftSex;
    private RecycleImageView mOtherRightSex;
    private BallTwinkleProgressBar mMineMatchBar;
    private BallTwinkleProgressBar motherLeftMatchBar;
    private BallTwinkleProgressBar motherRightMatchBar;
    private YYRelativeLayout mMineLayoutMatchBar;
    private YYRelativeLayout mOtherLeftLayoutMatchBar;
    private YYRelativeLayout mOtherRightLayoutMatchBar;
    public YYRelativeLayout mFlMatchTips;
    public volatile boolean mIsSVGALoad = false;
    Runnable mTimeOutRunnable;
    private View mBgView;
    Runnable mTipTask = new Runnable(){

        @Override
        public void run() {
            RelativePos relativePos = new RelativePos(0, 0);
            relativePos.setVerticalRelate(2);
            if (TwoVsTwoMatchPager.this.mMatchTipPopupWindow != null) {
                TwoVsTwoMatchPager.this.mMatchTipPopupWindow.showArrowTo((View)TwoVsTwoMatchPager.this.mMineRightHead, relativePos, ResolutionUtils.dip2Px((float)20.0f), -10);
            }
        }
    };

    public TwoVsTwoMatchPager(Context context, IMatchGameUICallbacks matchGameUICallbacks, boolean isTeamGame) {
        super(context, matchGameUICallbacks, isTeamGame);
    }

    @Override
    public void createView(Context context) {
        this.mRoot = TwoVsTwoMatchPager.inflate((Context)context, (int)R.layout.match_game_2v2_layout, (ViewGroup)this);
        this.initMineLayout();
        this.initOtherLayout();
        this.mBgView = this.mRoot.findViewById(R.id.bg_view);
        this.mBtnCancel = (YYImageView)this.mRoot.findViewById(R.id.btn_cancel);
        this.mTvTitle = (TextView)this.mRoot.findViewById(R.id.tv_title);
        this.mTvGamePlayCount = (TextView)this.mRoot.findViewById(R.id.tv_game_players);
        this.mTvGamePlayCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mTvTitle.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoTitle));
        this.mTvGameStatus = (TextView)this.mRoot.findViewById(R.id.tv_match_status);
        View matchTipView = LayoutInflater.from((Context)context).inflate(R.layout.game_match_tips, null);
        this.mTvGameMatchTips = (BubbleTextView)matchTipView.findViewById(R.id.tv_game_match_tips);
        this.mTvGameMatchTips.setFillColor(ResourceUtils.getColor((int)R.color.game_im_pop_color));
        this.mTvGameMatchTips.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        this.mMatchTipPopupWindow = new BubblePopupWindow(matchTipView, (BubbleStyle)this.mTvGameMatchTips);
        this.mMatchTipPopupWindow.setCancelOnTouchOutside(false);
        this.mMatchTipPopupWindow.setCancelOnTouch(false);
        this.mPkTipIcon = (RoundImageView)this.mRoot.findViewById(R.id.img_pk_icon);
        this.mSvgaImageView = (SVGAImageView)this.mRoot.findViewById(R.id.svg_match_tips);
        this.mFlMatchTips = (YYRelativeLayout)this.mRoot.findViewById(R.id.fl_match_tips);
        this.mSvgaImageView.setFillMode(SVGAImageView.FillMode.Forward);
        this.mSvgaImageView.setClearsAfterStop(false);
        this.initClick();
        if (this.mMatchGameUICallbacks != null) {
            if (this.mMatchGameUICallbacks.isShowTipAnim()) {
                if (Build.VERSION.SDK_INT < 21) {
                    this.mFlMatchTips.setVisibility(8);
                    this.mMatchGameUICallbacks.onMatchTipFinish();
                    return;
                }
                this.mMatchGameUICallbacks.onMatchGuideStart();
                this.mFlMatchTips.setVisibility(0);
                this.initMatchTipsSvga();
            }
        } else {
            this.mFlMatchTips.setVisibility(8);
        }
    }

    private void initMineLayout() {
        this.mMineLayout = (ViewGroup)this.mRoot.findViewById(R.id.mylayout);
        this.mMineleftHead = (HeadFrameImageView)this.mMineLayout.findViewById(R.id.img_left_head);
        this.mMineRightHead = (HeadFrameImageView)this.mMineLayout.findViewById(R.id.img_right_head);
        this.mMineleftSex = (RecycleImageView)this.mMineLayout.findViewById(R.id.img_left_sex);
        this.mMineRightSex = (RecycleImageView)this.mMineLayout.findViewById(R.id.img_right_sex);
        this.mMineLayoutMatchBar = (YYRelativeLayout)this.mMineLayout.findViewById(R.id.layout_match_bar);
        this.mMineMatchBar = (BallTwinkleProgressBar)this.mMineLayout.findViewById(R.id.prossgress_match);
    }

    private void initOtherLayout() {
        this.mOtherLayout = (ViewGroup)this.mRoot.findViewById(R.id.otherlayout);
        this.mOtherLeftHead = (HeadFrameImageView)this.mOtherLayout.findViewById(R.id.img_left_head);
        this.mOtherRightHead = (HeadFrameImageView)this.mOtherLayout.findViewById(R.id.img_right_head);
        this.mOtherLeftSex = (RecycleImageView)this.mOtherLayout.findViewById(R.id.img_left_sex);
        this.mOtherRightSex = (RecycleImageView)this.mOtherLayout.findViewById(R.id.img_right_sex);
        this.mOtherLeftLayoutMatchBar = (YYRelativeLayout)this.mOtherLayout.findViewById(R.id.layout_match_bar_left);
        this.motherLeftMatchBar = (BallTwinkleProgressBar)this.mOtherLeftLayoutMatchBar.findViewById(R.id.prossgress_match_left);
        this.mOtherRightLayoutMatchBar = (YYRelativeLayout)this.mOtherLayout.findViewById(R.id.layout_match_bar_right);
        this.motherRightMatchBar = (BallTwinkleProgressBar)this.mOtherRightLayoutMatchBar.findViewById(R.id.prossgress_match_right);
    }

    private void initMatchTipsSvga() {
        this.mTimeOutRunnable = new Runnable(){

            @Override
            public void run() {
                TwoVsTwoMatchPager.this.onSvgaFail();
            }
        };
        YYTaskExecutor.postToMainThread((Runnable)this.mTimeOutRunnable, (long)2000L);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mTimeOutRunnable);
    }

    public synchronized void onSvgaFail() {
        if (!this.mIsAnimatorStop) {
            this.mIsAnimatorStop = true;
            if (this.mFlMatchTips != null) {
                this.mFlMatchTips.setVisibility(8);
            }
            if (this.mMatchGameUICallbacks != null) {
                this.mMatchGameUICallbacks.onMatchTipFinish();
            }
        }
    }

    @Override
    public void startMatchAnim(boolean isTwo) {
        if (isTwo) {
            if (this.mMineMatchBar != null && this.mMineLayoutMatchBar != null) {
                this.mMineMatchBar.stopAnimator();
                this.mMineLayoutMatchBar.setVisibility(8);
            }
        } else if (this.mMineMatchBar != null && this.mMineLayoutMatchBar != null) {
            this.mMineMatchBar.startAnimator();
            this.mMineLayoutMatchBar.setVisibility(0);
        }
        if (this.motherLeftMatchBar != null && this.mOtherLeftLayoutMatchBar != null) {
            this.mOtherLeftLayoutMatchBar.setVisibility(0);
            this.motherLeftMatchBar.startAnimator();
        }
        if (this.motherRightMatchBar != null && this.mOtherRightLayoutMatchBar != null) {
            this.mOtherRightLayoutMatchBar.setVisibility(0);
            this.motherRightMatchBar.startAnimator();
        }
    }

    @Override
    public void updateFriendsView(UserInfoKS userInfoKS) {
        if (this.mMineMatchBar != null && this.mMineLayoutMatchBar != null) {
            this.mMineMatchBar.stopAnimator();
            this.mMineLayoutMatchBar.setVisibility(8);
        }
        if (this.mMineRightHead == null || this.mMineRightSex == null) {
            return;
        }
        this.showFriendsLayout(true);
        ImageLoader.loadImage((RecycleImageView)this.mMineRightHead.getCircleImageView(), (String)(userInfoKS.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.getSex()));
        ImageLoader.loadImage((RecycleImageView)this.mMineRightSex, (int)(userInfoKS.getSex() == 0 ? R.drawable.badge_female : R.drawable.badge_male));
    }

    @Override
    public void updateMyInfoView(UserInfoKS userInfoKS) {
        if (this.mMineleftHead == null || this.mMineleftSex == null) {
            return;
        }
        ImageLoader.loadImage((RecycleImageView)this.mMineleftHead.getCircleImageView(), (String)(userInfoKS.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.getSex()));
        ImageLoader.loadImage((RecycleImageView)this.mMineleftSex, (int)(userInfoKS.getSex() == 0 ? R.drawable.badge_female : R.drawable.badge_male));
    }

    @Override
    public void updateOtherTeamView(List<UserInfoKS> userInfoKSList) {
        if (!this.showOtherLayout(true)) {
            return;
        }
        if (userInfoKSList != null && userInfoKSList.size() > 0) {
            int num = 0;
            for (UserInfoKS userInfoKS : userInfoKSList) {
                if (num == 0) {
                    ImageLoader.loadImage((RecycleImageView)this.mOtherLeftHead.getCircleImageView(), (String)(userInfoKS.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.getSex()));
                    ImageLoader.loadImage((RecycleImageView)this.mOtherLeftSex, (int)(userInfoKS.getSex() == 0 ? R.drawable.badge_female : R.drawable.badge_male));
                } else if (num == 1) {
                    ImageLoader.loadImage((RecycleImageView)this.mOtherRightHead.getCircleImageView(), (String)(userInfoKS.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.getSex()));
                    ImageLoader.loadImage((RecycleImageView)this.mOtherRightSex, (int)(userInfoKS.getSex() == 0 ? R.drawable.badge_female : R.drawable.badge_male));
                }
                ++num;
            }
        }
    }

    @Override
    public void startMatchSuccessAnim() {
        this.stopMatchAnim();
        this.showOtherLayout(true);
        this.showFriendsLayout(true);
        if (this.mBtnCancel != null) {
            this.mBtnCancel.setVisibility(8);
        }
        this.leftTransAnim((View)this.mMineLayout);
        this.rightTransAnim((View)this.mOtherLayout);
        this.middleScaleAnim((View)this.mPkTipIcon);
    }

    @Override
    public void initClick() {
        this.mBtnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"AllGameMatchPager", (String)"mBtnCancel cancel", (Object[])new Object[0]);
                }
                TwoVsTwoMatchPager.this.mMatchGameUICallbacks.cancelMatch(3);
            }
        });
    }

    @Override
    public void stopMatchAnim() {
        if (this.mMineMatchBar != null && this.mMineLayoutMatchBar != null) {
            this.mMineMatchBar.stopAnimator();
            this.mMineLayoutMatchBar.setVisibility(8);
        }
        if (this.motherLeftMatchBar != null && this.mOtherLeftLayoutMatchBar != null) {
            this.motherLeftMatchBar.stopAnimator();
            this.mOtherLeftLayoutMatchBar.setVisibility(8);
        }
        if (this.motherRightMatchBar != null && this.mOtherRightLayoutMatchBar != null) {
            this.motherRightMatchBar.stopAnimator();
            this.mOtherRightLayoutMatchBar.setVisibility(8);
        }
    }

    public void showFriendsLayout(boolean isShow) {
        if (this.mMineRightHead != null && this.mMineRightSex != null) {
            if (isShow) {
                this.mMineRightHead.setVisibility(0);
                this.mMineRightSex.setVisibility(0);
            } else {
                this.mMineRightHead.setVisibility(8);
                this.mMineRightSex.setVisibility(8);
            }
        }
    }

    public boolean showOtherLayout(boolean isShow) {
        boolean isSuccess = false;
        if (this.mOtherLeftHead != null && this.mOtherLeftSex != null && this.mOtherRightHead != null && this.mOtherRightSex != null) {
            if (isShow) {
                this.mOtherLeftHead.setVisibility(0);
                this.mOtherLeftSex.setVisibility(0);
                this.mOtherRightHead.setVisibility(0);
                this.mOtherRightSex.setVisibility(0);
            } else {
                this.mOtherLeftHead.setVisibility(8);
                this.mOtherLeftSex.setVisibility(8);
                this.mOtherRightHead.setVisibility(8);
                this.mOtherRightSex.setVisibility(8);
            }
            isSuccess = true;
        }
        return isSuccess;
    }

    @Override
    public void updateTVMatch(GameDef.MatchStatus status, String text) {
        if (status.equals((Object)GameDef.MatchStatus.MATCHING)) {
            this.mTvGameStatus.setText((CharSequence)text);
        } else if (status.equals((Object)GameDef.MatchStatus.MATCHING_SUCCESS)) {
            this.mTvGameStatus.setText((CharSequence)ResourceUtils.getString((int)R.string.team_match_success));
            text = text.replace("#999999", "#ffffff");
            text = text.replace("#ff4a6d", "#fff45c");
            this.mTvGameMatchTips.setText((CharSequence)Html.fromHtml((String)text));
            YYTaskExecutor.postToMainThread((Runnable)this.mTipTask, (long)360L);
        }
    }

    @Override
    public void leftTransAnim(View view) {
        ObjectAnimator first = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, ResolutionUtils.dip2Px((float)20.0f)});
        ObjectAnimator second = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{ResolutionUtils.dip2Px((float)20.0f), -ResolutionUtils.dip2Px((float)0.0f)});
        AnimatorSet set = new AnimatorSet();
        first.setDuration(80L);
        first.setInterpolator((TimeInterpolator)new LinearInterpolator());
        second.setDuration(280L);
        second.setInterpolator((TimeInterpolator)new LinearInterpolator());
        set.playSequentially(new Animator[]{first, second});
        set.start();
    }

    @Override
    public void rightTransAnim(View view) {
        ObjectAnimator first = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, -ResolutionUtils.dip2Px((float)20.0f)});
        ObjectAnimator second = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-ResolutionUtils.dip2Px((float)20.0f), ResolutionUtils.dip2Px((float)0.0f)});
        AnimatorSet set = new AnimatorSet();
        first.setDuration(80L);
        first.setInterpolator((TimeInterpolator)new LinearInterpolator());
        second.setDuration(280L);
        second.setInterpolator((TimeInterpolator)new LinearInterpolator());
        set.playSequentially(new Animator[]{first, second});
        set.start();
    }

    @Override
    public void showActivityBanner(int resId) {
    }

    @Override
    public void removeTipRunnable() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mTipTask);
    }
}

