/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.matchgame.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RelativeLayout;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.widget.volume.VolumeViewManager;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.module.matchgame.IGameMatchInterface;
import com.yy.game.module.matchgame.IMatchGameUICallbacks;
import com.yy.game.module.matchgame.ui.PkMatchLoadingPage;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.mvp.base.SimpleLifeCycleOwner;

public class MatchGameWindow
extends DefaultWindow {
    public IMatchGameUICallbacks mMatchGameUICallbacks;
    public IGameMatchInterface mGameMatchPager;
    public SimpleLifeCycleOwner mLifeCycleOwner;
    public PkMatchLoadingPage mLoading;

    public MatchGameWindow(Context context, UICallBacks callBacks) {
        super(context, callBacks, "MatchGame");
    }

    public MatchGameWindow(Context context, UICallBacks callBacks, AbstractWindow.WindowLayerType useLayerType, GameInfo gameInfo) {
        super(context, callBacks, useLayerType, "MatchGame");
        this.mLoading = new PkMatchLoadingPage(context);
        this.mLifeCycleOwner = SimpleLifeCycleOwner.of((View)this);
        if (callBacks instanceof IMatchGameUICallbacks) {
            this.mMatchGameUICallbacks = (IMatchGameUICallbacks)callBacks;
        }
        this.setWindowType(101);
        this.setOnClickListener(v -> {});
    }

    public void hideLoading() {
        if (this.mLoading != null) {
            this.mLoading.setVisibility(8);
        }
    }

    public void loadLoadingView(GameInfo gameInfo) {
        if (this.mLoading != null) {
            ViewParent parent = this.mLoading.getParent();
            if (parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView((View)this.mLoading);
            }
            this.getBaseLayer().addView((View)this.mLoading, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            this.setPushAnimationType(3);
            this.mLoading.updateGameinfo(gameInfo);
        }
    }

    public void updateLoadingProgress(int progress) {
        if (this.mLoading != null) {
            this.mLoading.updateProgress(progress);
        }
    }

    public IMatchGameUICallbacks getMatchGameUICallbacks() {
        return this.mMatchGameUICallbacks;
    }

    public void setMatchGameUICallbacks(IMatchGameUICallbacks mMatchGameUICallbacks) {
        this.mMatchGameUICallbacks = mMatchGameUICallbacks;
    }

    public void initView(GameInfo gameInfo) {
        if (this.mGameMatchPager == null) {
            this.mGameMatchPager = this.mMatchGameUICallbacks.getMatchView(gameInfo);
        }
        if (this.mGameMatchPager instanceof View) {
            ViewParent parent = ((View)this.mGameMatchPager).getParent();
            if (parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView((View)this.mGameMatchPager);
            }
            this.getBaseLayer().addView((View)this.mGameMatchPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            this.setPushAnimationType(3);
        }
    }

    public IGameMatchInterface getGameMatchPager() {
        return this.mGameMatchPager;
    }

    public void startMatchSuccessAnim() {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.startMatchSuccessAnim();
        }
    }

    public void startMatchAnim() {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.startMatchAnim();
        }
    }

    public void stopMatchAnim() {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.stopMatchAnim();
        }
    }

    public void updateTVMatch(GameDef.MatchStatus status, String text) {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.updateTVMatch(status, text);
        }
    }

    public void updateotherView(UserInfoKS userInfo) {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.updateOtherView(userInfo);
        }
    }

    public void updateMyInfoView(UserInfoKS userInfo) {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.updateMyInfoView(userInfo);
        }
    }

    public void updateGoldEntryView(boolean isShowGoldUI, int coins) {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.updateGoldEntryView(isShowGoldUI, coins);
        }
    }

    public void updateGameInfo(GameInfo gameInfo) {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.updateGameDisplay(gameInfo);
        }
    }

    public void showInviteNotice(GameInfo gameInfo, CharSequence tip, long countDown) {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.showMatchInviteNotice(gameInfo, tip, countDown);
        }
    }

    public void hideInviteNotice() {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.hideMatchInviteNotice();
        }
    }

    public void updateUserProgress(boolean isMine, int progress) {
        if (this.mGameMatchPager != null) {
            if (isMine) {
                this.mGameMatchPager.updateMineProgress(progress);
            } else {
                this.mGameMatchPager.updateOtherProgress(progress);
            }
        }
    }

    public void showVolumeView(boolean isUp) {
        VolumeViewManager.INSTANCE.showVolumeView((ViewGroup)this.getExtLayer(), isUp, 2);
    }

    public void stopMatchTipAnim() {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.stopMatchTipAnim();
        }
    }

    public void showMplBanner(int resId) {
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.showActivityBanner(resId);
        }
    }

    public void onHidden() {
        super.onHidden();
        if (this.mGameMatchPager != null) {
            this.mGameMatchPager.dismissMatchTip();
        }
    }
}

