/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.matchgame.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.BubbleTextView;
import com.yy.appbase.ui.widget.bubble.RelativePos;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.module.gameroom.ui.BallTwinkleProgressBar;
import com.yy.game.module.matchgame.IGameMatchInterface;
import com.yy.game.module.matchgame.IMatchGameUICallbacks;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.api.IDRCallback;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import org.jetbrains.annotations.NotNull;

public class AllGameMatchPager
extends YYFrameLayout
implements IGameMatchInterface {
    public static final String TAG = "AllGameMatchPager";
    public static final long HEAD_FRI_ANIM_DISTANCE = 20L;
    public static final long HEAD_SEC_ANIM_DISTANCE = 0L;
    public static final long HEAD_FRI_PK_ANIM_DISTANCE = 30L;
    public IMatchGameUICallbacks mMatchGameUICallbacks;
    public View mRoot;
    public ViewGroup mMineLayout;
    public ViewGroup mOtherLayout;
    private HeadFrameImageView mMineHead;
    private HeadFrameImageView mOtherHead;
    private TextView mMineName;
    private TextView mOtherName;
    private TextView mMineProgressTv;
    private ProgressBar mMineProgress;
    private TextView mOtherProgressTv;
    private ProgressBar mOtherProgress;
    public YYImageView mBtnCancel;
    public TextView mTvGameStatus;
    public TextView mTvTitle;
    private BallTwinkleProgressBar mMatchBar;
    private View mLayoutMatchBar;
    public BubbleTextView mTvGameMatchTips;
    public TextView mTvGamePlayCount;
    public SVGAImageView mSvgaImageView;
    public FrameLayout mFlMatchTips;
    public TextView mTvMatchTips;
    public RoundImageView mPkTipIcon;
    private LinearLayout mLLMatchBg;
    public boolean mIsAnimatorStop = false;
    private boolean mIsTeamGame = false;
    public BubblePopupWindow mMatchTipPopupWindow;
    private View mGoldEntryView;
    private View mBgView;
    private RecycleImageView mBgImg;
    private ImageView mMineCoinsFrame;
    private ImageView mOtherCoinsFrame;
    private YYImageView mActivityBanner;
    private ViewStub mInviteViewStub;
    private TextView mInviteRejectTv;
    private TextView mInviteAcceptTv;
    private RoundImageView mInviteGameIcon;
    private TextView mInviteTipTv;
    private Runnable mMatchTipsShowTask = new Runnable(){

        @Override
        public void run() {
            if (AllGameMatchPager.this.mOtherLayout == null) {
                return;
            }
            RelativePos relativePos = new RelativePos(0, 0);
            relativePos.setVerticalRelate(2);
            if (AllGameMatchPager.this.mMatchTipPopupWindow != null) {
                AllGameMatchPager.this.mMatchTipPopupWindow.showArrowTo((View)AllGameMatchPager.this.mOtherLayout, relativePos, ResolutionUtils.dip2Px((float)20.0f), -10);
            }
        }
    };

    public AllGameMatchPager(Context context, IMatchGameUICallbacks matchGameUICallbacks, boolean isTeamGame) {
        super(context);
        this.mMatchGameUICallbacks = matchGameUICallbacks;
        this.mIsTeamGame = isTeamGame;
        this.createView(context);
    }

    public void createView(Context context) {
        this.mRoot = this.mMatchGameUICallbacks != null && this.mMatchGameUICallbacks.isNewGameload() ? AllGameMatchPager.inflate((Context)context, (int)R.layout.match_game_team_layout_new, (ViewGroup)this) : AllGameMatchPager.inflate((Context)context, (int)R.layout.match_game_team_layout, (ViewGroup)this);
        this.mBgView = this.mRoot.findViewById(R.id.rl_bg);
        this.mBgImg = (RecycleImageView)this.mRoot.findViewById(R.id.imgBg);
        DyResLoader.INSTANCE.loadImage(this.mBgImg, DR.common_game_loading_bg);
        this.mMineLayout = (ViewGroup)this.mRoot.findViewById(R.id.mylayout);
        this.mOtherLayout = (ViewGroup)this.mRoot.findViewById(R.id.otherlayout);
        this.mMineHead = (HeadFrameImageView)this.mMineLayout.findViewById(R.id.img_head);
        this.mOtherHead = (HeadFrameImageView)this.mOtherLayout.findViewById(R.id.img_head);
        this.mMineName = (TextView)this.mMineLayout.findViewById(R.id.tv_user_name);
        this.mOtherName = (TextView)this.mOtherLayout.findViewById(R.id.tv_user_name);
        this.mMineProgressTv = (TextView)this.mMineLayout.findViewById(R.id.downloadingTv);
        this.mMineProgress = (ProgressBar)this.mMineLayout.findViewById(R.id.downloadingPb);
        this.mOtherProgressTv = (TextView)this.mOtherLayout.findViewById(R.id.downloadingTv);
        this.mOtherProgress = (ProgressBar)this.mOtherLayout.findViewById(R.id.downloadingPb);
        FontUtils.setFontType((TextView)this.mMineProgressTv, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        FontUtils.setFontType((TextView)this.mOtherProgressTv, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        this.mBtnCancel = (YYImageView)this.mRoot.findViewById(R.id.btn_cancel);
        this.mTvTitle = (TextView)this.mRoot.findViewById(R.id.tv_title);
        FontUtils.setFontType((TextView)this.mTvTitle, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoTitle));
        this.mTvGamePlayCount = (TextView)this.mRoot.findViewById(R.id.tv_game_players);
        if (this.mMatchGameUICallbacks != null) {
            if (!this.mMatchGameUICallbacks.isNewGameload()) {
                this.mTvGamePlayCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
            } else {
                this.mMineName.setTextColor(ResourceUtils.getColor((int)R.color.black_0b0505));
                this.mOtherName.setTextColor(ResourceUtils.getColor((int)R.color.black_0b0505));
            }
        }
        this.mTvTitle.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mTvGameStatus = (TextView)this.mRoot.findViewById(R.id.tv_match_status);
        View matchTipView = LayoutInflater.from((Context)context).inflate(R.layout.game_match_tips, null);
        this.mTvGameMatchTips = (BubbleTextView)matchTipView.findViewById(R.id.tv_game_match_tips);
        this.mTvGameMatchTips.setFillColor(ResourceUtils.getColor((int)R.color.game_im_pop_color));
        this.mTvGameMatchTips.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        this.mMatchTipPopupWindow = new BubblePopupWindow(matchTipView, (BubbleStyle)this.mTvGameMatchTips);
        this.mMatchTipPopupWindow.setCancelOnTouchOutside(false);
        this.mMatchTipPopupWindow.setCancelOnTouch(false);
        this.mPkTipIcon = (RoundImageView)this.mRoot.findViewById(R.id.img_pk_icon);
        this.mMatchBar = (BallTwinkleProgressBar)this.mOtherLayout.findViewById(R.id.prossgress_match);
        this.mLayoutMatchBar = this.mOtherLayout.findViewById(R.id.layout_match_bar);
        this.mSvgaImageView = (SVGAImageView)this.mRoot.findViewById(R.id.svg_match_tips);
        this.mFlMatchTips = (FrameLayout)this.mRoot.findViewById(R.id.fl_match_tips);
        this.mTvMatchTips = (TextView)this.mRoot.findViewById(R.id.tv_match_tips);
        this.mGoldEntryView = this.mRoot.findViewById(R.id.ll_gold_game_flag);
        this.mLLMatchBg = (LinearLayout)this.mRoot.findViewById(R.id.ll_match_bg);
        this.mMineCoinsFrame = (ImageView)this.mMineLayout.findViewById(R.id.iv_coins_frame);
        this.mOtherCoinsFrame = (ImageView)this.mOtherLayout.findViewById(R.id.iv_coins_frame);
        this.mActivityBanner = (YYImageView)this.mRoot.findViewById(R.id.iv_activity_banner);
        this.mTvMatchTips.setTypeface(Typeface.defaultFromStyle((int)1));
        this.mTvMatchTips.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mLayoutMatchBar.setVisibility(0);
        this.mOtherHead.setVisibility(8);
        this.mMineCoinsFrame.setVisibility(8);
        this.mOtherCoinsFrame.setVisibility(8);
        this.mSvgaImageView.setFillMode(SVGAImageView.FillMode.Forward);
        this.mSvgaImageView.setClearsAfterStop(false);
        this.mInviteViewStub = (ViewStub)this.mRoot.findViewById(R.id.layout_match_invite);
        this.initClick();
        if (Build.VERSION.SDK_INT > 20) {
            this.mMineName.setEllipsize(TextUtils.TruncateAt.END);
            this.mOtherName.setEllipsize(TextUtils.TruncateAt.END);
        }
        if (this.mIsTeamGame) {
            if (this.mMatchGameUICallbacks != null) {
                if (this.mMatchGameUICallbacks.isShowTipAnim()) {
                    this.mMatchGameUICallbacks.onMatchGuideStart();
                    this.mFlMatchTips.setVisibility(0);
                    this.initMatchTipsSvga();
                }
            } else {
                this.mFlMatchTips.setVisibility(8);
            }
        }
        HeadFrameType headFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
        Kvo.addKvoBinding((KvoSource)headFrameType, (Object)this, (String)"onMyHeadFrameTypeUpdate");
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onMyHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.mMineHead != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.mMineHead.setHeadFrame(this.mMatchGameUICallbacks.getHeadFrameUrl(frame));
        }
    }

    public void updateOtherHeadFrame(int type) {
        if (this.mOtherHead != null) {
            this.mOtherHead.setHeadFrame(this.mMatchGameUICallbacks.getHeadFrameUrl(type));
        }
    }

    private void initMatchTipsSvga() {
        DyResLoader.INSTANCE.loadSvga(this.mSvgaImageView, DR.match_tips, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
                AllGameMatchPager.this.mSvgaImageView.setCallback(new SVGACallback(){

                    public void onPause() {
                    }

                    public void onFinished() {
                        AllGameMatchPager.this.mIsAnimatorStop = true;
                        if (AllGameMatchPager.this.mFlMatchTips != null) {
                            AllGameMatchPager.this.mFlMatchTips.setVisibility(8);
                        }
                        if (AllGameMatchPager.this.mMatchGameUICallbacks != null) {
                            AllGameMatchPager.this.mMatchGameUICallbacks.onMatchTipFinish();
                        }
                    }

                    public void onRepeat() {
                    }

                    public void onStep(int i, double v) {
                        if (i == 30 && AllGameMatchPager.this.mTvMatchTips != null) {
                            AllGameMatchPager.this.mTvMatchTips.setVisibility(0);
                            AllGameMatchPager.this.showMatchTipsAnimator((View)AllGameMatchPager.this.mTvMatchTips);
                        }
                    }
                });
                AllGameMatchPager.this.mSvgaImageView.startAnimation();
            }

            public void onFailed(Exception e) {
                AllGameMatchPager.this.mIsAnimatorStop = true;
                if (AllGameMatchPager.this.mFlMatchTips != null) {
                    AllGameMatchPager.this.mFlMatchTips.setVisibility(8);
                }
                if (AllGameMatchPager.this.mMatchGameUICallbacks != null) {
                    AllGameMatchPager.this.mMatchGameUICallbacks.onMatchTipFinish();
                }
            }
        });
    }

    public void showMatchTipsAnimator(View view) {
        int width = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int height = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(width, height);
        final float appearLocationY = this.mSvgaImageView.getY() - (float)this.mSvgaImageView.getMeasuredHeight();
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator scaleYAnimator = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.3f, 1.0f});
        ObjectAnimator scaleXAnimator = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.3f, 1.0f});
        ObjectAnimator appearAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{appearLocationY, appearLocationY - (float)ResolutionUtils.dip2Px((float)150.0f)});
        ObjectAnimator translationDownAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{appearLocationY - (float)ResolutionUtils.dip2Px((float)150.0f), appearLocationY - (float)ResolutionUtils.dip2Px((float)150.0f) + (float)ResolutionUtils.dip2Px((float)20.0f)});
        ObjectAnimator translationUpAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{appearLocationY - (float)ResolutionUtils.dip2Px((float)150.0f) + (float)ResolutionUtils.dip2Px((float)20.0f), appearLocationY - (float)ResolutionUtils.dip2Px((float)150.0f)});
        AnimatorSet animatorSet = new AnimatorSet();
        translationUpAnimator.setDuration(500L);
        translationUpAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        translationDownAnimator.setDuration(500L);
        translationDownAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animatorSet.playTogether(new Animator[]{alphaAnimator, scaleXAnimator, scaleYAnimator});
        animatorSet.playSequentially(new Animator[]{appearAnimator, translationDownAnimator, translationUpAnimator});
        translationUpAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                AllGameMatchPager.this.executeUpDownAnimator((View)AllGameMatchPager.this.mTvMatchTips, appearLocationY);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSet.start();
    }

    private void executeUpDownAnimator(View view, final float appearLocationY) {
        if (this.mIsAnimatorStop) {
            return;
        }
        ObjectAnimator translationDownAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{appearLocationY - (float)ResolutionUtils.dip2Px((float)150.0f), appearLocationY - (float)ResolutionUtils.dip2Px((float)150.0f) + (float)ResolutionUtils.dip2Px((float)20.0f)});
        ObjectAnimator translationUpAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{appearLocationY - (float)ResolutionUtils.dip2Px((float)150.0f) + (float)ResolutionUtils.dip2Px((float)20.0f), appearLocationY - (float)ResolutionUtils.dip2Px((float)150.0f)});
        AnimatorSet animatorSet = new AnimatorSet();
        translationUpAnimator.setDuration(500L);
        translationUpAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        translationDownAnimator.setDuration(500L);
        translationDownAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animatorSet.playSequentially(new Animator[]{translationDownAnimator, translationUpAnimator});
        animatorSet.start();
        translationUpAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                AllGameMatchPager.this.executeUpDownAnimator((View)AllGameMatchPager.this.mTvMatchTips, appearLocationY);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void middleScaleAnim(final View view) {
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(360L);
        set.playTogether(new Animator[]{scaleX, scaleY});
        set.setStartDelay(80L);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                view.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        set.start();
    }

    public void initClick() {
        this.mBtnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)AllGameMatchPager.TAG, (String)"mBtnCancel cancel", (Object[])new Object[0]);
                }
                AllGameMatchPager.this.mMatchGameUICallbacks.cancelMatch(3);
            }
        });
        if (this.mInviteViewStub != null) {
            this.mInviteViewStub.setOnInflateListener(new ViewStub.OnInflateListener(){

                public void onInflate(ViewStub stub, View inflated) {
                    AllGameMatchPager.this.mInviteGameIcon = (RoundImageView)inflated.findViewById(R.id.gameIconIv);
                    AllGameMatchPager.this.mInviteTipTv = (TextView)inflated.findViewById(R.id.inviteTipTv);
                    AllGameMatchPager.this.mInviteRejectTv = (TextView)inflated.findViewById(R.id.rejectTv);
                    AllGameMatchPager.this.mInviteAcceptTv = (TextView)inflated.findViewById(R.id.acceptTv);
                    AllGameMatchPager.this.mInviteAcceptTv.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (AllGameMatchPager.this.mMatchGameUICallbacks != null) {
                                AllGameMatchPager.this.mMatchGameUICallbacks.answerMatchInvite(true);
                            }
                        }
                    });
                    AllGameMatchPager.this.mInviteRejectTv.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (AllGameMatchPager.this.mMatchGameUICallbacks != null) {
                                AllGameMatchPager.this.mMatchGameUICallbacks.answerMatchInvite(false);
                            }
                        }
                    });
                }
            });
        }
    }

    @Override
    public void updateMyInfoView(UserInfoKS userInfoBean) {
        if (this.mMineLayout == null) {
            return;
        }
        this.updateUserInfoView(userInfoBean, this.mMineName, this.mMineHead);
    }

    @Override
    public void updateOtherView(UserInfoKS userInfoBean) {
        if (this.mOtherLayout == null) {
            return;
        }
        this.updateUserInfoView(userInfoBean, this.mOtherName, this.mOtherHead);
    }

    private void updateUserInfoView(UserInfoKS userInfoBean, TextView nameView, HeadFrameImageView iconView) {
        if (userInfoBean == null) {
            return;
        }
        iconView.setVisibility(0);
        ImageLoader.loadImage((RecycleImageView)iconView.getCircleImageView(), (String)(userInfoBean.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)userInfoBean.getSex()));
        Drawable sexDrawable = userInfoBean.getSex() == 0 ? ResourceUtils.getDrawable((int)R.drawable.ico_match_girl) : ResourceUtils.getDrawable((int)R.drawable.ico_match_boy);
        int size = ResolutionUtils.dip2Px((float)12.0f);
        sexDrawable.setBounds(0, 0, size, size);
        nameView.setCompoundDrawablesRelative(sexDrawable, null, null, null);
        nameView.setText((CharSequence)userInfoBean.getNick());
        nameView.setVisibility(0);
    }

    @Override
    public void startMatchSuccessAnim() {
        this.stopMatchAnim();
        this.mOtherHead.setVisibility(0);
        if (this.mMatchGameUICallbacks != null && !this.mMatchGameUICallbacks.isMatchPoolInvite() && this.mBtnCancel != null) {
            this.mBtnCancel.setVisibility(8);
        }
        this.leftTransAnim((View)this.mMineLayout);
        this.rightTransAnim((View)this.mOtherLayout);
        if (!this.mIsTeamGame) {
            this.middleScaleAnim((View)this.mPkTipIcon);
        } else {
            this.mPkTipIcon.setVisibility(8);
        }
    }

    @Override
    public void startMatchAnim() {
        if (this.mLayoutMatchBar != null) {
            this.mLayoutMatchBar.setVisibility(0);
            this.mOtherHead.setVisibility(4);
            this.mOtherName.setVisibility(8);
            this.mMatchBar.startAnimator();
        }
    }

    @Override
    public void stopMatchAnim() {
        if (this.mMatchBar != null) {
            this.mMatchBar.stopAnimator();
            this.mLayoutMatchBar.setVisibility(8);
        }
    }

    @Override
    public void updateGameDisplay(GameInfo gameInfo) {
        if (gameInfo != null) {
            if (this.mTvTitle != null) {
                String name = gameInfo.getGname();
                if (StringUtils.isEmpty((String)name)) {
                    name = "";
                }
                this.mTvTitle.setText((CharSequence)name.toUpperCase());
            }
            if (this.mTvGamePlayCount != null) {
                if (gameInfo.getGameMode() == 7) {
                    this.mTvGamePlayCount.setText((CharSequence)ResourceUtils.getString((int)R.string.short_title_match_game_2v2_type));
                } else if (gameInfo.getPlayerCount() > 0) {
                    this.mTvGamePlayCount.setText((CharSequence)ResourceUtils.getString((int)R.string.team_match_player_count, (Object[])new Object[]{gameInfo.getPlayerCount()}));
                } else {
                    this.mTvGamePlayCount.setText((CharSequence)ResourceUtils.getString((int)R.string.short_title_match_game_type));
                }
            }
        }
    }

    public void leftTransAnim(View view) {
        if (this.mIsTeamGame) {
            ObjectAnimator first = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, -ResolutionUtils.dip2Px((float)20.0f)});
            ObjectAnimator second = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-ResolutionUtils.dip2Px((float)20.0f), ResolutionUtils.dip2Px((float)20.0f)});
            AnimatorSet set = new AnimatorSet();
            first.setDuration(80L);
            first.setInterpolator((TimeInterpolator)new LinearInterpolator());
            second.setDuration(280L);
            second.setInterpolator((TimeInterpolator)new LinearInterpolator());
            set.playSequentially(new Animator[]{first, second});
            set.start();
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mMineName.getLayoutParams();
            params.rightMargin = ResolutionUtils.dip2Px((float)16.0f);
            this.mMineName.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            ObjectAnimator first = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, ResolutionUtils.dip2Px((float)30.0f)});
            ObjectAnimator second = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{ResolutionUtils.dip2Px((float)30.0f), -ResolutionUtils.dip2Px((float)0.0f)});
            AnimatorSet set = new AnimatorSet();
            first.setDuration(80L);
            first.setInterpolator((TimeInterpolator)new LinearInterpolator());
            second.setDuration(280L);
            second.setInterpolator((TimeInterpolator)new LinearInterpolator());
            set.playSequentially(new Animator[]{first, second});
            set.start();
        }
    }

    public void rightTransAnim(View view) {
        if (this.mIsTeamGame) {
            ObjectAnimator first = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, ResolutionUtils.dip2Px((float)20.0f)});
            ObjectAnimator second = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{ResolutionUtils.dip2Px((float)20.0f), -ResolutionUtils.dip2Px((float)20.0f)});
            AnimatorSet set = new AnimatorSet();
            first.setDuration(80L);
            first.setInterpolator((TimeInterpolator)new LinearInterpolator());
            second.setDuration(280L);
            second.setInterpolator((TimeInterpolator)new LinearInterpolator());
            set.playSequentially(new Animator[]{first, second});
            set.start();
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mOtherName.getLayoutParams();
            params.leftMargin = ResolutionUtils.dip2Px((float)16.0f);
            this.mOtherName.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            ObjectAnimator first = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, -ResolutionUtils.dip2Px((float)30.0f)});
            ObjectAnimator second = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-ResolutionUtils.dip2Px((float)30.0f), ResolutionUtils.dip2Px((float)0.0f)});
            AnimatorSet set = new AnimatorSet();
            first.setDuration(80L);
            first.setInterpolator((TimeInterpolator)new LinearInterpolator());
            second.setDuration(280L);
            second.setInterpolator((TimeInterpolator)new LinearInterpolator());
            set.playSequentially(new Animator[]{first, second});
            set.start();
        }
    }

    @Override
    public void updateTVMatch(GameDef.MatchStatus status, String text) {
        if (status.equals((Object)GameDef.MatchStatus.MATCHING)) {
            this.mTvGameStatus.setText((CharSequence)text);
        } else if (status.equals((Object)GameDef.MatchStatus.MATCHING_SUCCESS)) {
            this.mTvGameStatus.setText((CharSequence)ResourceUtils.getString((int)R.string.team_match_success));
            if (FP.empty((CharSequence)text)) {
                return;
            }
            if (!this.mIsTeamGame) {
                text = text.replace("#999999", "#ffffff");
                text = text.replace("#ff4a6d", "#fff45c");
            }
            this.mTvGameMatchTips.setText((CharSequence)Html.fromHtml((String)text));
            YYTaskExecutor.postToMainThread((Runnable)this.mMatchTipsShowTask, (long)360L);
        }
    }

    @Override
    public void dismissMatchTip() {
        this.removeTipRunnable();
        if (this.mMatchTipPopupWindow != null) {
            this.mMatchTipPopupWindow.dismiss();
        }
        this.mMatchTipPopupWindow = null;
    }

    public void removeTipRunnable() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mMatchTipsShowTask);
    }

    @Override
    public void updateGoldEntryView(boolean isShowGoldUI, int coins) {
        if (this.mGoldEntryView == null) {
            return;
        }
        if (!isShowGoldUI || coins <= 0) {
            this.mGoldEntryView.setVisibility(8);
            return;
        }
        TextView tvCount = (TextView)this.mGoldEntryView.findViewById(R.id.tv_coins_entry);
        tvCount.setText((CharSequence)String.valueOf(coins));
        this.mBgView.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_coins_game_bg));
        DyResLoader.INSTANCE.getResFilePath(com.yy.hiyo.game.base.DR.bg_game_coins_result, new IDRCallback(){

            public void onSucceed(@NotNull String data) {
                if (!FP.empty((CharSequence)data)) {
                    Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)data, (ImageConfig)ImageConfig.fullImageConfig(), (boolean)false);
                    if (bitmap == null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)AllGameMatchPager.TAG, (String)"DyResLoader.bg_game_coins_result bitmap is null", (Object[])new Object[0]);
                        }
                        return;
                    }
                    BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                    AllGameMatchPager.this.mBgView.setBackgroundDrawable((Drawable)drawable2);
                }
            }

            public void onFailed(@NotNull String msg) {
                MLog.error((Object)AllGameMatchPager.TAG, (String)msg, (Object[])new Object[0]);
            }
        });
        ((FrameLayout.LayoutParams)this.mLLMatchBg.getLayoutParams()).topMargin = ResolutionUtils.dip2Px((float)13.0f);
        DyResLoader.INSTANCE.getResFilePath(DR.bg_coins_match, new IDRCallback(){

            public void onFailed(@NotNull String msg) {
                MLog.error((Object)AllGameMatchPager.TAG, (String)msg, (Object[])new Object[0]);
            }

            public void onSucceed(@NotNull String data) {
                if (!FP.empty((CharSequence)data)) {
                    Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)data, (ImageConfig)ImageConfig.fullImageConfig(), (boolean)false);
                    if (bitmap == null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)AllGameMatchPager.TAG, (String)"DyResLoader.bg_coins_match bitmap is null", (Object[])new Object[0]);
                        }
                        return;
                    }
                    BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                    AllGameMatchPager.this.mLLMatchBg.setBackgroundDrawable((Drawable)drawable2);
                }
            }
        });
        this.mTvTitle.setBackgroundResource(0);
        this.mLayoutMatchBar.setBackgroundResource(R.drawable.coins_match_circle);
        this.mMineCoinsFrame.setVisibility(0);
        this.mOtherCoinsFrame.setVisibility(0);
        this.mTvGameStatus.setTextColor(ResourceUtils.getColor((int)R.color.white));
    }

    @Override
    public void showActivityBanner(int resId) {
        this.mActivityBanner.setVisibility(0);
        this.mActivityBanner.setImageResource(resId);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mBtnCancel.getLayoutParams();
        params.bottomMargin = ResolutionUtils.dip2Px((float)80.0f);
        this.mBtnCancel.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void stopMatchTipAnim() {
        this.mIsAnimatorStop = true;
        if (this.mMatchTipPopupWindow != null) {
            this.mMatchTipPopupWindow.dismiss();
        }
    }

    @Override
    public void showMatchInviteNotice(GameInfo inviteGame, CharSequence tip, long countdown) {
        if (this.mInviteViewStub != null) {
            this.mInviteViewStub.setVisibility(0);
        }
        if (this.mInviteGameIcon != null) {
            String url = inviteGame.getIconUrl();
            if (StringUtils.isEmpty((String)url)) {
                url = inviteGame.getImIconUrl();
            }
            ImageLoader.loadImage((RecycleImageView)this.mInviteGameIcon, (String)(url + YYImageUtils.getThumbnailPostfix((int)60)));
        }
        if (this.mInviteTipTv != null) {
            this.mInviteTipTv.setText(tip);
        }
        if (this.mInviteAcceptTv != null) {
            String acceptBtn = this.getResources().getString(R.string.accept) + "(" + countdown / 1000L + "s)";
            this.mInviteAcceptTv.setText((CharSequence)acceptBtn);
        }
    }

    @Override
    public void hideMatchInviteNotice() {
        if (this.mInviteViewStub != null) {
            this.mInviteViewStub.setVisibility(8);
        }
    }

    @Override
    public void updateMineProgress(int progress) {
        this.updateProgress(this.mMineProgressTv, this.mMineProgress, progress);
        this.mTvGameStatus.setText((CharSequence)this.getResources().getString(R.string.game_match_title_downloading_content));
    }

    @Override
    public void updateOtherProgress(int progress) {
        this.updateProgress(this.mOtherProgressTv, this.mOtherProgress, progress);
        this.mTvGameStatus.setText((CharSequence)this.getResources().getString(R.string.game_match_title_download_waiting_content, new Object[]{this.mOtherName.getText()}));
    }

    private void updateProgress(final TextView progressTv, final ProgressBar progressBar, int progress) {
        if (progressTv == null || progressBar == null) {
            return;
        }
        if (progress < 0 || progress > progressBar.getMax()) {
            progressBar.setVisibility(8);
            progressTv.setVisibility(8);
        } else {
            progressBar.setVisibility(0);
            progressTv.setVisibility(0);
            progressBar.setProgress(progress);
            progressTv.setText((CharSequence)(progress + "%"));
            if (progress == progressBar.getMax()) {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AllGameMatchPager.this.updateProgress(progressTv, progressBar, -1);
                    }
                }, 1000L);
            }
        }
    }
}

