/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gamesource;

import com.yy.appbase.AppbaseMsgDef;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.game.download.version.GameVersion;
import com.yy.game.module.gamesource.GameSourceDialog;
import com.yy.game.module.gamesource.IGameSourceDialogListener;
import com.yy.hiyo.game.source.IGameSourceDialoger;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class GameSourceDialogPresenter
implements IGameSourceDialogListener,
IGameSourceDialoger {
    private static final String TAG = "GameSourceDialogPresenter";
    private static final long MB = 0x100000L;
    private GameSourceDialog mSourceDialog;
    private DialogLinkManager mDialogLinkManager;
    private int mHomeShownCount = 0;
    private boolean needJump = false;
    private boolean hadShow = false;

    public GameSourceDialogPresenter(DialogLinkManager manager) {
        this.mDialogLinkManager = manager;
    }

    public void showDialogIfNeed() {
        ++this.mHomeShownCount;
        if (this.mHomeShownCount > 2 && this.canShow()) {
            this.showDialog();
        }
    }

    public void hideDialogIfNeed() {
        this.hideDialog();
        this.needJump = false;
    }

    private boolean canShow() {
        if (this.hadShow) {
            return false;
        }
        if (!IGameSourceDialoger.canShow((DialogLinkManager)this.mDialogLinkManager)) {
            return false;
        }
        if (GameVersion.INSTANCE.getTotalSize() / 0x100000L <= (long)SettingFlags.getIntValue((String)"game_source_limit_size", (int)200)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"canShow total size", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    private void showDialog() {
        if (this.mSourceDialog == null) {
            this.mSourceDialog = new GameSourceDialog(this);
            this.mDialogLinkManager.showDialog((BaseDialog)this.mSourceDialog);
            this.hadShow = true;
            SettingFlags.setLongValue((String)"key_game_source_tips_last_time", (long)System.currentTimeMillis());
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023771").put("function_id", "storage_pop_show"));
        }
    }

    private void hideDialog() {
        if (this.mSourceDialog != null) {
            this.mSourceDialog.dismiss();
            this.mSourceDialog = null;
        }
    }

    @Override
    public void onDismiss(boolean selectNotNotify) {
        this.hideDialog();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onDismiss selectNotNotify: %b", (Object[])new Object[]{selectNotNotify});
        }
        SettingFlags.setBoolean((String)"key_game_source_not_tips", (boolean)selectNotNotify);
        if (selectNotNotify) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023771").put("function_id", "storage_pop_never").put("sort_size", "" + GameVersion.INSTANCE.getTotalSize() / 0x100000L));
        }
        if (this.needJump) {
            MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.OPEN_GAME_SOURCE_PAGE);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023771").put("function_id", "storage_pop_enter").put("sort_size", "" + GameVersion.INSTANCE.getTotalSize() / 0x100000L));
        }
        this.needJump = false;
    }

    @Override
    public void onClick() {
        this.hideDialog();
        this.needJump = true;
    }
}

