/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.common.CommonCallback;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.cocos2d.callback.IGameEngineCallback;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.gameview.IGameView;
import com.yy.game.gamemodule.base.gameview.IInnerGameViewCallback;
import com.yy.game.module.gameroom.ui.ExitConfirmDialog;
import com.yy.game.module.gameroom.ui.GameLoadingPage;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.IGameDialogCallback;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GameViewComponent
implements IGameView {
    private static final String TAG = "OpenGameViewComponent";
    private boolean mWindowShown = true;
    private IGameEngineCallback gameViewCallback;
    protected IInnerGameViewCallback mCallback;
    GameLoadingPage mLoadingPage;
    private final String hostWindowTag;
    private ExitConfirmDialog mExitConfirmDialog;
    private ViewGroup container;
    private ViewGroup mInnerContainer;

    public GameViewComponent(String hostWindowTag) {
        this.hostWindowTag = hostWindowTag;
    }

    @Override
    @Nullable
    public CommonCallback getCommonCallback() {
        return null;
    }

    @Override
    public void showLoading(@NotNull GameInfo gameInfo) {
    }

    @Override
    @NotNull
    public Context obtainContext() {
        return this.container.getContext();
    }

    @Override
    @NotNull
    public ViewGroup getContainer() {
        return this.mInnerContainer;
    }

    public void onCreate(ViewGroup container, GamePlayContext gamePlayContext) {
        ViewParent vg;
        if (container == null) {
            GameLoger.error("componentGame", "\u7ec4\u4ef6\u6e38\u620f\u5bb9\u5668\u4e3a\u7a7a\uff01", true);
            return;
        }
        this.container = container;
        if (gamePlayContext == null) {
            GameLoger.error("componentGame", "\u4f20\u5165\u7ec4\u4ef6\u6e38\u620f\u7684context\u4e3a\u7a7a\uff01", true);
            return;
        }
        container.removeAllViews();
        GameLoger.error("componentGame", "\u521b\u5efa\u7ec4\u4ef6\u6e38\u620fview\u6210\u529f");
        if (this.mLoadingPage != null && (vg = this.mLoadingPage.getParent()) instanceof ViewGroup) {
            ((ViewGroup)vg).removeView((View)this.mLoadingPage);
        }
        this.mInnerContainer = new YYFrameLayout(container.getContext());
        container.addView((View)this.mInnerContainer, new ViewGroup.LayoutParams(-1, -1));
        this.initLoadingPage(this.mInnerContainer.getContext(), gamePlayContext.getGameInfo());
        if (this.mLoadingPage != null) {
            container.addView((View)this.mLoadingPage, new ViewGroup.LayoutParams(-1, -1));
            this.onLoadingGameBg(this.mLoadingPage != null ? this.mLoadingPage.getGameLoadingPageImg() : null, 0);
        }
        if (this.mCallback != null) {
            this.mCallback.onLifeCycleChanged(1);
        }
    }

    @Override
    public void setGameWindowCallback(@Nullable IInnerGameViewCallback callback2) {
        this.mCallback = callback2;
    }

    public void initLoadingPage(Context context, GameInfo gameInfo) {
        if (this.mLoadingPage == null) {
            this.mLoadingPage = new GameLoadingPage(context){

                @Override
                public void updateView(View containerView, SVGAImageView backSVGAImageView, RecycleImageView gameLoadingPageImg, YYTextView gameLoadingTv) {
                    super.updateView(containerView, backSVGAImageView, gameLoadingPageImg, gameLoadingTv);
                    containerView.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_99272735));
                    gameLoadingTv.setVisibility(0);
                    gameLoadingPageImg.setScaleType(ImageView.ScaleType.FIT_END);
                    gameLoadingPageImg.setAlpha(0.8f);
                    containerView.findViewById(R.id.v_divider).setVisibility(0);
                }
            };
            this.mLoadingPage.setCallBack(new GameLoadingPage.ILoadingViewCallback(){

                @Override
                public void onCloseClick() {
                }

                @Override
                public int loadingPageType() {
                    return 0;
                }

                @Override
                public DResource getCusLoadingSvgaKey() {
                    return DR.room_game_loading;
                }
            });
            this.updateLoading(gameInfo);
        }
    }

    private void updateLoading(GameInfo gameInfo) {
        if (gameInfo.isWebIndineGame()) {
            this.mLoadingPage.updateWebGameInfo(gameInfo);
        } else {
            this.mLoadingPage.updateNormalView();
        }
    }

    public abstract void onLoadingGameBg(RecycleImageView var1, int var2);

    public void onShown() {
        if (this.mCallback != null && !this.mWindowShown) {
            this.mCallback.onLifeCycleChanged(2);
            this.mWindowShown = true;
        }
    }

    public void onHidden() {
        if (this.mCallback != null && this.mWindowShown) {
            this.mCallback.onLifeCycleChanged(3);
            this.mWindowShown = false;
        }
        this.hideExitDialog();
    }

    @Override
    public void onViewHidden() {
        this.onHidden();
    }

    public void onDetached() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"GameWindowLife onDetached", (Object[])new Object[0]);
        }
        if (this.mCallback != null) {
            this.mCallback.onLifeCycleChanged(4);
        }
        this.hideExitDialog();
    }

    @Override
    public void onViewDetach() {
        this.onDetached();
    }

    public void onActivityResume() {
        if (!this.mWindowShown) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"GameWindowLife onActivityResume", (Object[])new Object[0]);
            }
            if (this.mCallback != null) {
                this.mCallback.onLifeCycleChanged(5);
            }
            this.mWindowShown = true;
        }
    }

    @Override
    public void onViewShown() {
        this.onShown();
    }

    public void onActivityPause() {
        if (this.mWindowShown) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"GameWindowLife onActivityPause", (Object[])new Object[0]);
            }
            if (this.mCallback != null) {
                this.mCallback.onLifeCycleChanged(6);
            }
            this.mWindowShown = false;
        }
    }

    @Override
    public void setGameViewCallback(IGameEngineCallback gameViewCallback) {
        this.gameViewCallback = gameViewCallback;
        if (gameViewCallback == null) {
            GameLoger.error("componentGame", "\u6784\u5efa\u6e38\u620f\u7ec4\u4ef6\u7684callback\u4e3a\u7a7a\uff01", true);
        }
    }

    @Override
    public void hideGameLoading() {
        if (this.mLoadingPage != null) {
            this.mLoadingPage.setVisibility(8);
            this.mLoadingPage.stopAnim();
            ViewParent vg = this.mLoadingPage.getParent();
            if (vg instanceof ViewGroup) {
                ((ViewGroup)vg).removeView((View)this.mLoadingPage);
            }
            this.mLoadingPage = null;
        }
    }

    @Override
    public void hideExitDialog() {
        if (this.mExitConfirmDialog != null) {
            this.mExitConfirmDialog.hideExitDialog();
        }
    }

    @Override
    public void showExitConfirmDialog(String content, String confirm, String cancel, IGameDialogCallback callback2) {
        if (this.mExitConfirmDialog == null) {
            this.mExitConfirmDialog = new ExitConfirmDialog();
        }
        this.mExitConfirmDialog.showExitConfirmDialog(this.container.getContext(), content, confirm, cancel, null, callback2);
    }

    public String getHostWindowTag() {
        return this.hostWindowTag;
    }

    public boolean isWindowShown() {
        return this.mWindowShown;
    }

    @Override
    @Nullable
    public PanelLayer getViewPanelLayer() {
        return null;
    }

    @Override
    public void loadGameView() {
    }
}

