/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.wight.GameTipsView;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class GameLoadingPage
extends YYRelativeLayout {
    SVGAImageView backSVGAImageView;
    RecycleImageView gameLoadingPageImg;
    YYTextView gameLoadingTv;
    YYTextView gameLoadingPercent;
    RoundConerImageView gameIcon;
    YYTextView gameName;
    YYRelativeLayout layoutWebGame;
    YYRelativeLayout layoutNormal;
    ProgressBar mProgressBar;
    RecycleImageView mIconClose;
    GameTipsView mGameTipsView;
    ILoadingViewCallback mCallBack;
    private int seconds = 1;
    private Runnable mMaskTimer = () -> {
        this.updateProgress();
        ++this.seconds;
        this.updateMaskTimer();
    };
    private Runnable mExitShowRunnable = () -> this.updateClose(true);

    public GameLoadingPage(Context context) {
        super(context);
        this.initView(context);
    }

    public void initView(Context context) {
        View view = GameLoadingPage.inflate((Context)context, (int)R.layout.game_loading_layout, (ViewGroup)this);
        view.setBackgroundColor(ResourceUtils.getColor((int)R.color.white));
        this.backSVGAImageView = (SVGAImageView)view.findViewById(R.id.svg_back);
        this.backSVGAImageView.setFillMode(SVGAImageView.FillMode.Forward);
        this.backSVGAImageView.setClearsAfterStop(false);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"GameLoadingPage", (String)"loading game progress bar start", (Object[])new Object[0]);
        }
        this.gameLoadingPageImg = (RecycleImageView)view.findViewById(R.id.game_load_page);
        this.gameLoadingTv = (YYTextView)view.findViewById(R.id.tv_loading);
        this.gameLoadingTv.setVisibility(8);
        this.gameIcon = (RoundConerImageView)view.findViewById(R.id.gameIcon);
        this.gameName = (YYTextView)view.findViewById(R.id.gameName);
        this.layoutWebGame = (YYRelativeLayout)view.findViewById(R.id.layoutWebGame);
        this.gameLoadingPercent = (YYTextView)view.findViewById(R.id.tvLoadPercent);
        this.layoutNormal = (YYRelativeLayout)view.findViewById(R.id.layoutNormal);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.gameProgress);
        this.mIconClose = (RecycleImageView)view.findViewById(R.id.iconClose);
        this.mGameTipsView = (GameTipsView)view.findViewById(R.id.tipsFlipper);
        this.mIconClose.setOnClickListener(v -> {
            if (this.mCallBack != null) {
                this.mCallBack.onCloseClick();
            }
        });
        this.updateView(view, this.backSVGAImageView, this.gameLoadingPageImg, this.gameLoadingTv);
    }

    public void updateView(View containerView, SVGAImageView backSVGAImageView, RecycleImageView gameLoadingPageImg, YYTextView gameLoadingTv) {
    }

    public RecycleImageView getGameLoadingPageImg() {
        return this.gameLoadingPageImg;
    }

    public void stopAnim() {
        this.backSVGAImageView.stopAnimation(true);
    }

    void startFilp(List<String> data) {
        if (this.mGameTipsView != null) {
            this.mGameTipsView.initData(data);
            this.mGameTipsView.startFlipper();
        }
    }

    private DResource getLoadingSvgaResource() {
        DResource svgaKey = this.mCallBack == null ? null : this.mCallBack.getCusLoadingSvgaKey();
        return svgaKey == null ? DR.game_loading : svgaKey;
    }

    public void loadSvga() {
        DyResLoader.INSTANCE.loadSvga(this.backSVGAImageView, this.getLoadingSvgaResource(), new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                MLog.error((Object)"GameLoadingPage", (String)"loading game progress bar success", (Object[])new Object[0]);
                if (GameLoadingPage.this.backSVGAImageView != null) {
                    GameLoadingPage.this.backSVGAImageView.startAnimation();
                }
            }

            public void onFailed(Exception e) {
                MLog.error((Object)"GameLoadingPage", (String)"loading game progress bar fail!!!", (Object[])new Object[0]);
            }
        });
    }

    public void updateNormalView() {
        this.layoutNormal.setVisibility(0);
        this.layoutWebGame.setVisibility(8);
        this.mIconClose.setVisibility(8);
        this.loadSvga();
    }

    public void updateLoading(GameInfo gameInfo) {
        if (this.mCallBack != null && this.mCallBack.loadingPageType() == 2) {
            this.updateWebGameInfo(gameInfo);
        } else {
            this.updateNormalView();
        }
    }

    private void updateMaskTimer() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mMaskTimer);
        YYTaskExecutor.postToMainThread((Runnable)this.mMaskTimer, (long)1000L);
    }

    private void updateProgress() {
        double progress = Math.atan((double)this.seconds / 3.5) / Math.PI * 2.0;
        int progressForShow = (int)(progress * 100.0);
        this.updateProgress(progressForShow);
    }

    public void updateWebGameInfo(GameInfo gameInfo) {
        long showCloseTime;
        this.layoutNormal.setVisibility(8);
        this.layoutWebGame.setVisibility(0);
        DyResLoader.INSTANCE.loadImage(this.gameLoadingPageImg, DR.common_game_loading_bg);
        ImageLoader.loadImage((RecycleImageView)this.gameIcon, (String)gameInfo.getIconUrl());
        this.gameName.setText((CharSequence)gameInfo.getGname());
        this.seconds = 1;
        this.updateMaskTimer();
        if (this.mCallBack != null && !this.mCallBack.getLoadingTips().isEmpty()) {
            this.startFilp(this.mCallBack.getLoadingTips());
        }
        if (this.mCallBack != null && (showCloseTime = this.mCallBack.closeTimer()) > 0L) {
            YYTaskExecutor.postToMainThread((Runnable)this.mExitShowRunnable, (long)showCloseTime);
        }
    }

    void hideGameLoading() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mMaskTimer);
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mExitShowRunnable);
        if (this.mGameTipsView != null) {
            this.mGameTipsView.stopFlipper();
        }
        this.setVisibility(8);
    }

    public void updateProgress(long progress) {
        this.mProgressBar.setProgress((int)progress);
        this.gameLoadingPercent.setText((CharSequence)String.format(ResourceUtils.getString((int)R.string.game_percent), String.valueOf(progress)));
    }

    public void updateClose(boolean visable) {
        if (visable) {
            this.mIconClose.setVisibility(0);
        } else {
            this.mIconClose.setVisibility(8);
        }
    }

    public void setCallBack(ILoadingViewCallback callBack) {
        this.mCallBack = callBack;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mMaskTimer != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mMaskTimer);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoadingPageType {
        public static final int CENTER_SVGA = 1;
        public static final int ICON_PROGERESS = 2;
    }

    public static interface ILoadingViewCallback {
        public void onCloseClick();

        default public long closeTimer() {
            return -1L;
        }

        public int loadingPageType();

        @Nullable
        public DResource getCusLoadingSvgaKey();

        default public List<String> getLoadingTips() {
            return new ArrayList<String>();
        }
    }
}

