/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.ui;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.game.cocos2d.EngineConfig;
import com.yy.game.download.version.GameVersion;
import com.yy.game.gameproxy.appcallgame.AppCallGameProxy;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameRunningDataContainer;
import com.yy.hiyo.game.base.config.GameCommonConfig;
import com.yy.hiyo.game.base.config.GameWebSockectConfig;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u001a\u0012\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\fH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\fH\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0016\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0012\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001c\u001a\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0001H\u0002\u001a\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0019H\u0002\u001a\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u0019H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006+"}, d2={"FOLDER_CACHE", "", "FOLDER_GAME", "FOLDER_WRITEABLE", "SHARED_WRITABLE", "TAG", "sDGameExternalDir", "sDGameShareDir", "getSDGameShareDir", "()Ljava/lang/String;", "getGameLang", "gameInfo", "Lcom/yy/hiyo/game/base/bean/GameInfo;", "getLciNew", "mGameInfo", "getLciOld", "getLcid", "getSDGameCacheDir", "Lcom/yy/hiyo/game/base/bean/BasicGameInfo;", "getSDGameCacheDirByGid", "gid", "getSDGameCacheDirPath", "path", "getSDGameWritableDir", "isSeparateThread", "", "isUseFixLuaWebSocket", "makeEngineConfig", "Lcom/yy/game/cocos2d/EngineConfig;", "gamePlayContext", "Lcom/yy/hiyo/game/service/bean/GamePlayContext;", "context", "Landroid/content/Context;", "config", "saveLang", "", "lang", "toastGameVersion", "version", "toastSpearthread", "isSpearthread", "toastUseLuaWebSocket", "useFixLuaWebSocket", "game_debug"})
public final class EngineConfigGeneratorKt {
    private static final String TAG = "MakeEngineConfig";
    private static final String FOLDER_GAME = "game";
    private static final String FOLDER_WRITEABLE = "writeable";
    private static final String FOLDER_CACHE = "cache";
    private static final String SHARED_WRITABLE = "sharedWritableDir";
    private static final String sDGameExternalDir;

    @NotNull
    public static final EngineConfig makeEngineConfig(@NotNull GamePlayContext gamePlayContext, @NotNull Context context, @NotNull EngineConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)gamePlayContext, (String)"gamePlayContext");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        MLog.verbose((Object)TAG, (String)"MakeEngineConfig start", (Object[])new Object[0]);
        String string2 = gamePlayContext.getGameInfo().gid;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gamePlayContext.gameInfo.gid");
        config.setGameName(string2);
        if (gamePlayContext.getGameUrl() != null) {
            String string3 = gamePlayContext.getGameUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"gamePlayContext.gameUrl");
            config.setGameUrl(string3);
        }
        config.setMediaOverlay(gamePlayContext.isSurfaceViewMediaOverlay());
        config.setOnTop(gamePlayContext.isSurfaceViewOnTop());
        if (gamePlayContext.getGameInfo() != null) {
            GameInfo gameInfo = gamePlayContext.getGameInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo, (String)"gamePlayContext.gameInfo");
            if (gameInfo.getGameMode() != 10) {
                AppCallGameProxy.gameId = gamePlayContext.getGameInfo().getGid();
                AppCallGameProxy.roomId = gamePlayContext.getRoomId();
            }
        }
        config.setTrans(gamePlayContext.isTrans());
        String sharedWritableDir = EngineConfigGeneratorKt.getSDGameShareDir();
        YYFileUtils.ensureFileDirExists((String)sharedWritableDir);
        config.setSharedWritableDir(sharedWritableDir);
        GameInfo gameInfo = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo, (String)"gamePlayContext.gameInfo");
        String gameWritablePath = EngineConfigGeneratorKt.getSDGameWritableDir((BasicGameInfo)gameInfo);
        YYFileUtils.ensureFileDirExists((String)gameWritablePath);
        config.setGameWritablePath(gameWritablePath);
        GameInfo gameInfo2 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo2, (String)"gamePlayContext.gameInfo");
        String gameCachePath = EngineConfigGeneratorKt.getSDGameCacheDir((BasicGameInfo)gameInfo2);
        YYFileUtils.ensureFileDirExists((String)gameCachePath);
        config.setGameCacheDir(gameCachePath);
        String string4 = gamePlayContext.getGameInfo().gid;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"gamePlayContext.gameInfo.gid");
        String version = GameVersion.INSTANCE.getVersion(string4);
        EngineConfigGeneratorKt.toastGameVersion(version);
        GameInfo gameInfo3 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo3, (String)"gamePlayContext.gameInfo");
        String lang = EngineConfigGeneratorKt.getLcid(gameInfo3);
        EngineConfigGeneratorKt.saveLang(lang);
        config.setLang(lang);
        GameInfo gameInfo4 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo4, (String)"gamePlayContext.gameInfo");
        config.setGameType(gameInfo4.getGameType());
        GameInfo gameInfo5 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo5, (String)"gamePlayContext.gameInfo");
        boolean useFixLuaWebSocket = EngineConfigGeneratorKt.isUseFixLuaWebSocket(gameInfo5);
        EngineConfigGeneratorKt.toastUseLuaWebSocket(useFixLuaWebSocket);
        config.setUseFixLuaWebSocket(useFixLuaWebSocket);
        GameInfo gameInfo6 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo6, (String)"gamePlayContext.gameInfo");
        boolean isSeparateThread = EngineConfigGeneratorKt.isSeparateThread(gameInfo6);
        EngineConfigGeneratorKt.toastSpearthread(isSeparateThread);
        GameInfo gameInfo7 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo7, (String)"gamePlayContext.gameInfo");
        if (gameInfo7.isWebGame()) {
            config.setEngineGameMode(9);
        } else {
            config.setEngineGameMode(1);
        }
        GameInfo gameInfo8 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo8, (String)"gamePlayContext.gameInfo");
        config.setAr(gameInfo8.isARGame());
        GameInfo gameInfo9 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo9, (String)"gamePlayContext.gameInfo");
        config.setGameMode(gameInfo9.getGameMode());
        config.setSeparateThread(isSeparateThread);
        GameInfo gameInfo10 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo10, (String)"gamePlayContext.gameInfo");
        config.setHorizontalScreen(gameInfo10.isHorizontalScreen());
        if (SystemUtils.isCpPackage()) {
            config.setMLogLevel(MLog.getVerboseLevel());
        } else {
            config.setMLogLevel(MLog.getLogLevel());
        }
        config.setUserWebAudio(SettingFlags.getBoolean((String)"key_game_web_audio_debug", (boolean)false));
        GameInfo gameInfo11 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo11, (String)"gamePlayContext.gameInfo");
        config.setHideVirtualButton(gameInfo11.getGameMode() != 8);
        GameInfo gameInfo12 = gamePlayContext.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo12, (String)"gamePlayContext.gameInfo");
        if (gameInfo12.isJSGame()) {
            GameInfo gameInfo13 = gamePlayContext.getGameInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo13, (String)"gamePlayContext.gameInfo");
            if (gameInfo13.isARGame()) {
                config.setEngineType("js_ar");
            } else {
                config.setEngineType("jsEngine");
            }
        } else {
            config.setEngineType("luaEngine");
        }
        MLog.verbose((Object)TAG, (String)"MakeEngineConfig end", (Object[])new Object[0]);
        return config;
    }

    private static final boolean isUseFixLuaWebSocket(GameInfo gameInfo) {
        int socketType = gameInfo.getSocketType();
        if (socketType > 0) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"use game info socketType:%d", (Object[])new Object[]{socketType});
            }
        } else {
            socketType = GameWebSockectConfig.getWebSockectType((String)gameInfo.gid);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"use boss config socketType:%d", (Object[])new Object[]{socketType});
            }
        }
        return socketType == 2;
    }

    private static final boolean isSeparateThread(GameInfo gameInfo) {
        boolean isSeparateThread = false;
        if (RuntimeContext.sIsDebuggable && (isSeparateThread = SettingFlags.getBoolean((String)"key_game_speart_thread_debug", (boolean)false))) {
            return true;
        }
        isSeparateThread = GameCommonConfig.getSeparatethreadOpen((String)gameInfo.gid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"use boss config isSeparateThread: %s", (Object[])new Object[]{isSeparateThread});
        }
        return isSeparateThread;
    }

    private static final void toastUseLuaWebSocket(boolean useFixLuaWebSocket) {
        if (RuntimeContext.sIsDebuggable && useFixLuaWebSocket) {
            TopToastUtils.showToast((CharSequence)"\u8be5\u6e38\u620f\u4f7f\u7528\u4e86\u5f15\u64ce\u76f4\u8fde\uff01", (int)1);
        }
    }

    private static final void toastSpearthread(boolean isSpearthread) {
        if (RuntimeContext.sIsDebuggable && isSpearthread) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u8be5\u6e38\u620f\u4f7f\u7528\u4e86\u5f15\u64ce\u7ebf\u7a0b\u5206\u79bb\uff01", (int)1);
        }
    }

    private static final void toastGameVersion(String version) {
        if (RuntimeContext.sIsDebuggable || SystemUtils.isCpPackage()) {
            TopToastUtils.showToast((CharSequence)StringUtils.format((String)"\u6e38\u620f\u7248\u672c\u53f7\u4e3a%s", (Object[])new Object[]{version}), (int)1);
        }
    }

    private static final void saveLang(String lang) {
        KvoSource kvoSource = KvoModuleManager.getModuleData(GameInfoModule.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)kvoSource, (String)"KvoModuleManager.getModu\u2026meInfoModule::class.java)");
        KvoSource data = kvoSource;
        if (data instanceof GameInfoModuleData) {
            GameRunningDataContainer gameRunningDataContainer = ((GameInfoModuleData)data).getRunningGameData();
            Intrinsics.checkExpressionValueIsNotNull((Object)gameRunningDataContainer, (String)"data.runningGameData");
            gameRunningDataContainer.setCurGameLang(lang);
        }
    }

    @NotNull
    public static final String getLcid(@NotNull GameInfo gameInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
        boolean oldSelect = SettingFlags.getBoolean((String)"useoldgamelangselect", (boolean)false);
        return oldSelect ? EngineConfigGeneratorKt.getLciOld(gameInfo) : EngineConfigGeneratorKt.getLciNew(gameInfo);
    }

    private static final String getLciOld(GameInfo mGameInfo) {
        String lcid = SettingFlags.getStringValue((String)"lcid");
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"lcid:%s", (Object[])new Object[]{lcid});
        }
        if (StringUtils.isEmpty((String)lcid)) {
            lcid = EngineConfigGeneratorKt.getGameLang(mGameInfo);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"last lcid:%s", (Object[])new Object[]{lcid});
        }
        String string2 = lcid;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"lcid");
        return string2;
    }

    private static final String getLciNew(GameInfo mGameInfo) {
        return EngineConfigGeneratorKt.getGameLang(mGameInfo);
    }

    private static final String getGameLang(GameInfo gameInfo) {
        String phoneLang = SystemUtils.getLang();
        if (phoneLang != null && StringUtils.equalsIgnoreCase((String)phoneLang, (String)"in")) {
            phoneLang = "id";
        }
        String curPhoneLang = phoneLang;
        String curPhoneCountry = SystemUtils.getTheSystemCountry();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"phoneLang %s phoneCountry %s", (Object[])new Object[]{curPhoneLang, curPhoneCountry});
        }
        String resultLang = "";
        if (gameInfo == null) {
            String string2;
            if (TextUtils.isEmpty((CharSequence)curPhoneLang)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"lang empty,set default to en", (Object[])new Object[0]);
                }
                string2 = "en";
            } else {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"lang empty, set default to curPhoneLang %s", (Object[])new Object[]{curPhoneLang});
                }
                String string3 = curPhoneLang;
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"curPhoneLang");
            }
            resultLang = string2;
            return resultLang;
        }
        List langList = gameInfo.getLangList();
        Object[] objectArray = new Object[2];
        Object object = langList;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        objectArray[0] = object;
        objectArray[1] = gameInfo.getDefLang();
        MLog.info((Object)TAG, (String)"supportlist %s deflang %s", (Object[])objectArray);
        if (StringUtils.isEmpty((String)curPhoneLang)) {
            String string4 = gameInfo.getDefLang();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"gameInfo.defLang");
            resultLang = string4;
        } else if (langList != null && langList.size() > 0) {
            for (String tempLcid : langList) {
                if (!StringUtils.equalsIgnoreCase((String)curPhoneLang, (String)tempLcid)) continue;
                String string5 = tempLcid;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"tempLcid");
                resultLang = string5;
                break;
            }
            if (StringUtils.isEmpty((String)resultLang) && StringUtils.isNotEmpty((String)curPhoneCountry)) {
                String langWithCountry = curPhoneLang + '-' + curPhoneCountry;
                for (String tempLcid : langList) {
                    if (!StringUtils.equalsIgnoreCase((String)langWithCountry, (String)tempLcid)) continue;
                    String string6 = tempLcid;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"tempLcid");
                    resultLang = string6;
                    break;
                }
            }
            if (StringUtils.isEmpty((String)resultLang)) {
                String langWithSplitStr = curPhoneLang + '-';
                for (String tempLcid : langList) {
                    if (!StringUtils.startsWithIgnoreCase((String)tempLcid, (String)langWithSplitStr)) continue;
                    String string7 = tempLcid;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"tempLcid");
                    resultLang = string7;
                    break;
                }
            }
            if (StringUtils.isEmpty((String)resultLang) && StringUtils.isNotEmpty((String)curPhoneCountry)) {
                boolean ends;
                String splitWithCcountry = "";
                String string8 = curPhoneCountry;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"curPhoneCountry");
                boolean bl = ends = !StringsKt.contains$default((CharSequence)string8, (CharSequence)"-", (boolean)false, (int)2, null);
                if (ends) {
                    splitWithCcountry = '-' + curPhoneCountry;
                }
                for (String tempLcid : langList) {
                    if (ends) {
                        if (!StringUtils.endsWithIgnoreCase((String)tempLcid, (String)splitWithCcountry)) continue;
                        String string9 = tempLcid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"tempLcid");
                        resultLang = string9;
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((String)tempLcid, (String)curPhoneCountry)) continue;
                    String string10 = tempLcid;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"tempLcid");
                    resultLang = string10;
                    break;
                }
            }
            if (StringUtils.isEmpty((String)resultLang)) {
                String string11 = gameInfo.getDefLang();
                Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"gameInfo.defLang");
                resultLang = string11;
            }
        } else {
            String string12 = gameInfo.getDefLang();
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"gameInfo.defLang");
            resultLang = string12;
        }
        if (TextUtils.isEmpty((CharSequence)resultLang) && langList != null && langList.size() > 0) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"lang set index 0 inlist", (Object[])new Object[0]);
            }
            Object e = langList.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"langList[0]");
            resultLang = (String)e;
        }
        if (TextUtils.isEmpty((CharSequence)resultLang)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"lang empty,set default to en", (Object[])new Object[0]);
            }
            resultLang = "en";
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"result lang %s", (Object[])new Object[]{resultLang});
        }
        return resultLang;
    }

    @NotNull
    public static final String getSDGameWritableDir(@NotNull BasicGameInfo gameInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
        return sDGameExternalDir + FOLDER_WRITEABLE + File.separator + gameInfo.gid + File.separator;
    }

    @NotNull
    public static final String getSDGameCacheDir(@NotNull BasicGameInfo gameInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
        return sDGameExternalDir + FOLDER_CACHE + File.separator + gameInfo.gid + File.separator;
    }

    @NotNull
    public static final String getSDGameCacheDirPath(@NotNull String gid, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return sDGameExternalDir + FOLDER_CACHE + File.separator + gid + File.separator + path;
    }

    @NotNull
    public static final String getSDGameCacheDirByGid(@NotNull String gid) {
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        return sDGameExternalDir + FOLDER_CACHE + File.separator + gid + File.separator;
    }

    private static final String getSDGameShareDir() {
        return sDGameExternalDir + SHARED_WRITABLE + File.separator;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        FileStorageUtils fileStorageUtils = FileStorageUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileStorageUtils, (String)"FileStorageUtils.getInstance()");
        sDGameExternalDir = stringBuilder.append(fileStorageUtils.getExternalFileRootDir()).append(File.separator).append(FOLDER_GAME).append(File.separator).toString();
    }
}

