/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import com.yy.base.R;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;

public class BallTwinkleProgressBar
extends YYView {
    private static final int DEFAULT_MAX_RADIUS = ResolutionUtils.dip2Px((float)4.0f);
    private static final int DEFAULT_DISTANCE = ResolutionUtils.dip2Px((float)10.0f);
    private int mBallMargeDistance = DEFAULT_DISTANCE;
    private int mBallRadius = DEFAULT_MAX_RADIUS;
    private static final int DEFAULT_ONE_BALL_COLOR = ResourceUtils.getColor((int)R.color.white);
    private static final int DEFAULT_ANIMATOR_DURATION = 800;
    private Paint mPaint;
    private long duration = 800L;
    private Ball mOneBall;
    private Ball mTwoBall;
    private Ball mThreeBall;
    private float mCenterX;
    private float mCenterY;
    private AnimatorSet animatorSet;
    private Context mcontext;

    public BallTwinkleProgressBar(Context context) {
        this(context, null);
    }

    public BallTwinkleProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BallTwinkleProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mcontext = context;
        this.mOneBall = new Ball();
        this.mTwoBall = new Ball();
        this.mThreeBall = new Ball();
        this.mOneBall.setColor(DEFAULT_ONE_BALL_COLOR);
        this.mTwoBall.setColor(DEFAULT_ONE_BALL_COLOR);
        this.mThreeBall.setColor(DEFAULT_ONE_BALL_COLOR);
        this.mOneBall.setRadius(this.mBallRadius);
        this.mTwoBall.setRadius(this.mBallRadius);
        this.mThreeBall.setRadius(this.mBallRadius);
        this.mOneBall.setAlpha(51);
        this.mTwoBall.setAlpha(51);
        this.mThreeBall.setAlpha(51);
        this.mPaint = new Paint(1);
        this.mPaint.setColor(DEFAULT_ONE_BALL_COLOR);
        this.configAnimator();
    }

    public void initAttrs(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BallTwinkleProgressBar, defStyle, 0);
        this.mBallMargeDistance = a.getDimensionPixelSize(R.styleable.BallTwinkleProgressBar_twiklemarge, DEFAULT_DISTANCE);
        this.mBallRadius = a.getDimensionPixelSize(R.styleable.BallTwinkleProgressBar_twikleradius, DEFAULT_MAX_RADIUS);
        a.recycle();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCenterX = w / 2;
        this.mCenterY = h / 2;
        this.mTwoBall.setCenterX(this.mCenterX);
        this.mOneBall.setCenterX(this.mCenterX - (float)(this.mBallMargeDistance + this.mBallRadius * 2));
        this.mThreeBall.setCenterX(this.mCenterX + (float)(this.mBallMargeDistance + this.mBallRadius * 2));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mCenterX = this.getWidth() / 2;
        this.mCenterY = this.getHeight() / 2;
        this.mTwoBall.setCenterX(this.mCenterX);
        this.mOneBall.setCenterX(this.mCenterX - (float)(this.mBallMargeDistance + this.mBallRadius * 2));
        this.mThreeBall.setCenterX(this.mCenterX + (float)(this.mBallMargeDistance + this.mBallRadius * 2));
    }

    public void addOnLayoutChangeListener(View.OnLayoutChangeListener listener) {
        super.addOnLayoutChangeListener(listener);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        float r = this.mBallRadius;
        this.mPaint.setAlpha(this.mOneBall.getAlpha());
        canvas.drawCircle(this.mOneBall.getCenterX(), this.mCenterY, r, this.mPaint);
        this.mPaint.setAlpha(this.mTwoBall.getAlpha());
        canvas.drawCircle(this.mTwoBall.getCenterX(), this.mCenterY, r, this.mPaint);
        this.mPaint.setAlpha(this.mThreeBall.getAlpha());
        canvas.drawCircle(this.mThreeBall.getCenterX(), this.mCenterY, r, this.mPaint);
    }

    private void configAnimator() {
        ValueAnimator oneCenterAnimator = ValueAnimator.ofFloat((float[])new float[]{0.2f, 0.5f, 1.0f, 0.5f, 0.2f});
        oneCenterAnimator.setRepeatCount(-1);
        oneCenterAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                BallTwinkleProgressBar.this.mOneBall.setAlpha((int)(255.0f * value));
                BallTwinkleProgressBar.this.invalidate();
            }
        });
        ValueAnimator twoCenterAnimator = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f, 0.5f, 0.2f, 0.5f});
        twoCenterAnimator.setRepeatCount(-1);
        twoCenterAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                BallTwinkleProgressBar.this.mTwoBall.setAlpha((int)(255.0f * value));
                BallTwinkleProgressBar.this.invalidate();
            }
        });
        ValueAnimator threeCenterAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.5f, 0.2f, 0.5f, 1.0f});
        threeCenterAnimator.setRepeatCount(-1);
        threeCenterAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                BallTwinkleProgressBar.this.mThreeBall.setAlpha((int)(255.0f * value));
                BallTwinkleProgressBar.this.invalidate();
            }
        });
        this.animatorSet = new AnimatorSet();
        this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }

            public void onAnimationRepeat(Animator animation) {
                super.onAnimationRepeat(animation);
            }
        });
        this.animatorSet.setDuration(800L);
        this.animatorSet.playTogether(new Animator[]{oneCenterAnimator, twoCenterAnimator, threeCenterAnimator});
    }

    public void setVisibility(int v) {
        if (this.getVisibility() != v) {
            super.setVisibility(v);
            if (v == 8 || v == 4) {
                // empty if block
            }
        }
    }

    protected void onVisibilityChanged(View changedView, int v) {
        super.onVisibilityChanged(changedView, v);
        if (v == 8 || v == 4) {
            // empty if block
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void setOneBallColor(@ColorInt int color2) {
        this.mOneBall.setColor(color2);
    }

    public void setmTwoBallColor(@ColorInt int color2) {
        this.mTwoBall.setColor(color2);
    }

    public void setDuration(long duration) {
        this.duration = duration;
        if (this.animatorSet != null) {
            this.animatorSet.setDuration(duration);
        }
    }

    public void startAnimator() {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.animatorSet.isRunning()) {
            return;
        }
        if (this.animatorSet != null) {
            this.animatorSet.start();
        }
    }

    public void stopAnimator() {
        if (this.animatorSet != null) {
            this.animatorSet.end();
        }
    }

    public class Ball {
        private float radius;
        private float centerX;
        private int color;
        private int alpha;

        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float radius) {
            this.radius = radius;
        }

        public float getCenterX() {
            return this.centerX;
        }

        public void setCenterX(float centerX) {
            this.centerX = centerX;
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int color2) {
            this.color = color2;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public void setAlpha(int alpha) {
            this.alpha = alpha;
        }
    }
}

