/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.common.CommonCallback;
import com.yy.appbase.ui.widget.volume.VolumeViewManager;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.game.cocos2d.EngineContext;
import com.yy.game.cocos2d.callback.IGameEngineCallback;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.gameview.IGameView;
import com.yy.game.gamemodule.base.gameview.IInnerGameViewCallback;
import com.yy.game.module.gameroom.ui.ExitConfirmDialog;
import com.yy.game.module.gameroom.ui.GameLoadingPage;
import com.yy.game.module.gameroom.ui.GameLoadingPageFactory;
import com.yy.game.module.gameroom.ui.GameWindowConfig;
import com.yy.game.module.gameroom.ui.IExitDialogFactory;
import com.yy.game.module.gameroom.ui.IGameEngine;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.IGameDialogCallback;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.mvp.base.SimpleLifeCycleOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressLint(value={"ViewConstructor"})
public abstract class AbsGameWindow
extends DefaultWindow
implements IGameView {
    public static final String TAG = "AbsGameWindow";
    boolean mWindowShown = false;
    IGameEngine mGameView;
    public GameLoadingPage gameLoadingPage;
    protected IInnerGameViewCallback mCallback;
    private DialogLinkManager mDialogLinkManager;
    private IGameEngineCallback gameViewCallback;
    private IExitDialogFactory exitDialogFactory;
    private GamePlayContext gamePlayContext;
    private ExitConfirmDialog mExitConfirmDialog;
    Runnable mInitRunnable = null;
    public SimpleLifeCycleOwner mLifeCycleOwner = SimpleLifeCycleOwner.of((View)this);
    private CommonCallback mCommonCallback;
    public static String sCurGameId;

    public AbsGameWindow(Context context, UICallBacks callBacks, AbstractWindow.WindowLayerType useLayerType) {
        this(context, callBacks, useLayerType, new GameWindowConfig(false));
    }

    public AbsGameWindow(Context context, UICallBacks callBacks, AbstractWindow.WindowLayerType useLayerType, GameWindowConfig config) {
        super(context, callBacks, useLayerType, "Game");
        this.setWindowType(103);
        boolean isSetCutmode = false;
        if (NAB.A.equals((Object)NewABDefine.GAME_FULL_SCREEN.getTest()) && config.getSupportNotchFullScreen()) {
            isSetCutmode = true;
        }
        this.setNeedFullScreen(true, isSetCutmode);
        this.initCusFuncView(this.getExtLayer());
    }

    @Override
    public void setGameViewCallback(IGameEngineCallback gameViewCallback) {
        this.gameViewCallback = gameViewCallback;
    }

    @Override
    public void setGameWindowCallback(@Nullable IInnerGameViewCallback callback2) {
        this.mCallback = callback2;
    }

    public void initViews(GamePlayContext gamePlayContext, IGameLifecycle gameLifecycle, boolean showLoading) {
        this.gamePlayContext = gamePlayContext;
        IGameEngineCallback callback2 = this.gameViewCallback;
        this.mCommonCallback = () -> {
            GameInfo gameInfo = null;
            if (gamePlayContext == null || gamePlayContext.getGameInfo() == null) {
                GameLoger.error("baseGame", "\u6e38\u620fview\u52a0\u8f7d\u5931\u8d25\uff0ccontext null or game info null");
                return;
            }
            gameInfo = gamePlayContext.getGameInfo();
            if (this.mCallback != null) {
                this.mCallback.onLifeCycleChanged(1);
            }
            sCurGameId = gameInfo.getGid();
            if (showLoading) {
                this.showLoading(gameInfo);
            }
        };
        if (this.mCallback != null) {
            this.mCallback.onLifeCycleChanged(0);
        }
    }

    @Override
    @Nullable
    public CommonCallback getCommonCallback() {
        return this.mCommonCallback;
    }

    @Override
    @NotNull
    public ViewGroup getContainer() {
        return this.getBaseLayer();
    }

    @Override
    @NotNull
    public ViewGroup getFunContainer() {
        return this.getBarLayer();
    }

    public void initViews(GamePlayContext gamePlayContext, IGameLifecycle gameLifecycle) {
        this.initViews(gamePlayContext, gameLifecycle, true);
    }

    @Override
    public void showLoading(GameInfo gameInfo) {
        GameLoadingPage loadingPage = this.getLoadingPage();
        this.getExtLayer().removeView((View)loadingPage);
        loadingPage.setVisibility(0);
        this.getExtLayer().addView((View)loadingPage, new ViewGroup.LayoutParams(-1, -1));
        loadingPage.updateLoading(gameInfo);
        this.onLoadGameBg(this.getLoadbgImg());
    }

    public abstract void initCusFuncView(RelativeLayout var1);

    public abstract void onLoadGameBg(RecycleImageView var1);

    private RecycleImageView getLoadbgImg() {
        if (this.gameLoadingPage != null) {
            return this.gameLoadingPage.getGameLoadingPageImg();
        }
        return null;
    }

    public void onShown() {
        super.onShown();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"GameWindowLife onShown", (Object[])new Object[0]);
        }
        if (this.mCallback != null) {
            this.mCallback.onLifeCycleChanged(2);
        }
        this.mWindowShown = true;
    }

    @Override
    @NotNull
    public Context obtainContext() {
        return this.getContext();
    }

    @Override
    public void onViewHidden() {
        this.onHidden();
    }

    @Override
    public void onViewDetach() {
        this.onDetached();
    }

    public void onHidden() {
        super.onHidden();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"GameWindowLife onHidden", (Object[])new Object[0]);
        }
        if (this.mCallback != null) {
            this.mCallback.onLifeCycleChanged(3);
        }
        this.mWindowShown = false;
    }

    public void onDetached() {
        super.onDetached();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"GameWindowLife onDetached", (Object[])new Object[0]);
        }
        this.hideExitDialog();
        if (this.mCallback != null) {
            this.mCallback.onLifeCycleChanged(4);
        }
        sCurGameId = null;
    }

    public void onActivityStop() {
    }

    public void onActivityDestroy() {
    }

    public void onActivityResume() {
        if (!this.mWindowShown) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"GameWindowLife onActivityResume", (Object[])new Object[0]);
            }
            if (this.mCallback != null) {
                this.mCallback.onLifeCycleChanged(5);
            }
            this.mWindowShown = true;
        }
    }

    public void onActivityPause() {
        if (this.mWindowShown) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"GameWindowLife onActivityPause", (Object[])new Object[0]);
            }
            if (this.mCallback != null) {
                this.mCallback.onLifeCycleChanged(6);
            }
            this.mWindowShown = false;
        }
    }

    @Override
    public void hideExitDialog() {
        if (this.mExitConfirmDialog != null) {
            this.mExitConfirmDialog.hideExitDialog();
        }
    }

    @Override
    public void showExitConfirmDialog(String content, String confirm, String cancel, IGameDialogCallback callback2) {
        if (this.mExitConfirmDialog == null) {
            this.mExitConfirmDialog = new ExitConfirmDialog();
        }
        BaseDialog baseDialog2 = null;
        if (this.exitDialogFactory != null) {
            baseDialog2 = this.exitDialogFactory.createExitDialog(this.gamePlayContext, callback2);
        }
        this.mExitConfirmDialog.showExitConfirmDialog(this.getContext(), content, confirm, cancel, baseDialog2, callback2);
    }

    @Override
    public void hideGameLoading() {
        if (this.gameLoadingPage != null) {
            this.gameLoadingPage.hideGameLoading();
            this.gameLoadingPage.stopAnim();
        }
    }

    public void showVolumeView(boolean isUp) {
        VolumeViewManager.INSTANCE.showVolumeView((ViewGroup)this.getExtLayer(), isUp, 2);
    }

    public void onAttach() {
        super.onAttach();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"GameWindowLife onAttach", (Object[])new Object[0]);
        }
        if (this.mWindowInfo != null) {
            this.mWindowInfo.setCanPopByBackKey(false);
        }
    }

    public void setExitDialogFactory(IExitDialogFactory exitDialogFactory) {
        this.exitDialogFactory = exitDialogFactory;
    }

    public final GameLoadingPage getLoadingPage() {
        if (this.gameLoadingPage == null) {
            this.gameLoadingPage = GameLoadingPageFactory.INSTANCE.getLoadingPage(this.getLoadingType(), this.getContext());
        }
        return this.gameLoadingPage;
    }

    public int getLoadingType() {
        return 2;
    }

    @Override
    @NotNull
    public PanelLayer getViewPanelLayer() {
        return this.getPanelLayer();
    }

    @Override
    public void onViewShown() {
        this.onShown();
    }

    @Override
    public void loadGameView() {
        if (this.mCallback != null) {
            this.initViews(this.mCallback.getGamePlayContext(), null);
        }
    }

    @Nullable
    public EngineContext getEngineContext() {
        if (this.mGameView != null) {
            return this.mGameView.getEngineContext();
        }
        return null;
    }
}

