/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.topbar;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.MikeDeviceFilterUtils;
import com.yy.game.R;
import com.yy.game.module.gameroom.topbar.BaseInfoView;
import com.yy.game.module.gameroom.topbar.Game2V2TopBar;
import com.yy.game.module.gameroom.topbar.ITopBarItemViewOnClick;

public class VerTopBar2v2
extends Game2V2TopBar {
    private ConstraintLayout mContainer;
    private ITopBarItemViewOnClick mClickLisenter;
    private BaseInfoView mMineLeftView;
    private BaseInfoView mMineRightView;
    private BaseInfoView mOhterLeftUserView;
    private BaseInfoView mOhterRightUserView;
    private RecycleImageView mBackIcon;
    private RecycleImageView mMicIcon;
    private RecycleImageView mCenterLogo;
    private boolean mIsMyVoiceOpen = false;
    private boolean mIsTargetVoiceOpen = false;

    public VerTopBar2v2(ITopBarItemViewOnClick click) {
        super(click);
    }

    @Override
    public View getView(Context context) {
        if (this.mContainer == null) {
            this.mContainer = (ConstraintLayout)LayoutInflater.from((Context)context).inflate(R.layout.pk_2v2_ver_topbar, null, false);
            this.mBackIcon = (RecycleImageView)this.mContainer.findViewById(R.id.top_bar_back);
            this.mMicIcon = (RecycleImageView)this.mContainer.findViewById(R.id.top_bar_mic);
            this.mOhterLeftUserView = (BaseInfoView)this.mContainer.findViewById(R.id.game_2v2_ohter_left);
            this.mOhterRightUserView = (BaseInfoView)this.mContainer.findViewById(R.id.game_2v2_ohter_right);
            this.mMineLeftView = (BaseInfoView)this.mContainer.findViewById(R.id.game_2v2_mine_left);
            this.mMineRightView = (BaseInfoView)this.mContainer.findViewById(R.id.game_2v2_mine_right);
            this.mMicIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MikeDeviceFilterUtils.needClickDelay()) {
                        return;
                    }
                    VerTopBar2v2.this.mUICallBack.onMicClick();
                    if (v.isSelected()) {
                        v.setSelected(false);
                    }
                }
            });
            this.mBackIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VerTopBar2v2.this.mUICallBack.onBackClick();
                }
            });
        }
        return this.mContainer;
    }

    @Override
    public void updateMicView(boolean voiceState) {
        this.mMicIcon.setActivated(voiceState);
    }

    @Override
    public void showBackBtn(boolean isHide) {
        if (this.mBackIcon == null) {
            return;
        }
        if (isHide) {
            this.mBackIcon.setVisibility(0);
        } else {
            this.mBackIcon.setVisibility(8);
        }
    }

    @Override
    public void showMicBtn(boolean isShow) {
        if (this.mMicIcon == null) {
            return;
        }
        if (isShow) {
            this.mMicIcon.setVisibility(0);
        } else {
            this.mMicIcon.setVisibility(8);
        }
    }

    @Override
    public void updateMineInfoView(UserInfoKS userInfoBean) {
        this.mMineLeftView.updateView(userInfoBean);
        if (userInfoBean == null) {
            return;
        }
        final long uid = userInfoBean.uid;
        this.mMineLeftView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerTopBar2v2.this.mUICallBack.onUserClick(uid);
            }
        });
    }

    @Override
    public void updateFriendInfoView(UserInfoKS userInfoBean) {
        this.mMineRightView.updateView(userInfoBean);
        if (userInfoBean == null) {
            return;
        }
        final long uid = userInfoBean.uid;
        this.mMineRightView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerTopBar2v2.this.mUICallBack.onUserClick(uid);
            }
        });
    }

    @Override
    public void updateOtherLeftInfoView(UserInfoKS userInfoBean) {
        this.mOhterLeftUserView.updateView(userInfoBean);
        if (userInfoBean == null) {
            return;
        }
        final long uid = userInfoBean.uid;
        this.mOhterLeftUserView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerTopBar2v2.this.mUICallBack.onUserClick(uid);
            }
        });
    }

    @Override
    public void updateOtherRightInfoView(UserInfoKS userInfoBean) {
        this.mOhterRightUserView.updateView(userInfoBean);
        if (userInfoBean == null) {
            return;
        }
        final long uid = userInfoBean.uid;
        this.mOhterRightUserView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerTopBar2v2.this.mUICallBack.onUserClick(uid);
            }
        });
    }

    @Override
    public void updateMineLeftVoice(boolean isSpeaking) {
        if (this.mMineLeftView != null) {
            if (isSpeaking) {
                this.mMineLeftView.setMicStatusSpeaking();
            } else {
                this.mMineLeftView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateMineRightVoice(boolean isSpeaking) {
        if (this.mMineRightView != null) {
            if (isSpeaking) {
                this.mMineRightView.setMicStatusSpeaking();
            } else {
                this.mMineRightView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateOtherLeftVoice(boolean isSpeaking) {
        if (this.mOhterLeftUserView != null) {
            if (isSpeaking) {
                this.mOhterLeftUserView.setMicStatusSpeaking();
            } else {
                this.mOhterLeftUserView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateOtherRightVocie(boolean isSpeaking) {
        if (this.mOhterRightUserView != null) {
            if (isSpeaking) {
                this.mOhterRightUserView.setMicStatusSpeaking();
            } else {
                this.mOhterRightUserView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateMineLeftMicStatusView(boolean isOpen) {
        if (isOpen) {
            this.mMineLeftView.setMicStatusOpen();
        } else {
            this.mMineLeftView.setMicStatusClose();
        }
    }

    @Override
    public void updateMineRightMicStatusView(boolean isOpen) {
        if (isOpen) {
            this.mMineRightView.setMicStatusOpen();
        } else {
            this.mMineRightView.setMicStatusClose();
        }
    }

    @Override
    public void updateOtherLeftMicStatusView(boolean isOpen) {
        if (isOpen) {
            this.mOhterLeftUserView.setMicStatusOpen();
        } else {
            this.mOhterLeftUserView.setMicStatusClose();
        }
    }

    @Override
    public void updateOtherRightMicStatusView(boolean isOpen) {
        if (isOpen) {
            this.mOhterRightUserView.setMicStatusOpen();
        } else {
            this.mOhterRightUserView.setMicStatusClose();
        }
    }

    public BaseInfoView getMineLeftView() {
        return this.mMineLeftView;
    }

    public BaseInfoView getMineRightView() {
        return this.mMineRightView;
    }

    public BaseInfoView getOhterLeftUserView() {
        return this.mOhterLeftUserView;
    }

    public BaseInfoView getOhterRightUserView() {
        return this.mOhterRightUserView;
    }
}

