/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.topbar;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.MikeDeviceFilterUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.module.gameroom.topbar.BaseInfoView;
import com.yy.game.module.gameroom.topbar.GamePkTopBar;
import com.yy.game.module.gameroom.topbar.ITopBarItemViewOnClick;
import com.yy.game.module.gameroom.topbar.LeftUserInfoView;
import com.yy.game.module.gameroom.topbar.RightUserInfoView;

public class VerTopBar
extends GamePkTopBar {
    private RelativeLayout mContainer;
    private ITopBarItemViewOnClick mClickLisenter;
    private BaseInfoView mLeftUserView;
    private BaseInfoView mRigthUserView;
    private YYImageView mBackIcon;
    private YYImageView mMicIcon;
    private YYImageView mCenterLogo;
    private boolean mIsMyVoiceOpen = false;
    private boolean mIsTargetVoiceOpen = false;

    public VerTopBar(ITopBarItemViewOnClick click) {
        super(click);
    }

    @Override
    public View getView(Context context) {
        if (this.mContainer == null) {
            this.mContainer = new YYRelativeLayout(context);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(0, ResourceUtils.getDimen((int)R.dimen.ver_game_top_padding), 0, 0);
            RelativeLayout.LayoutParams topLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            this.mContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            int iconsize = ResourceUtils.getDimen((int)R.dimen.game_icon_size);
            int backleftMargin = ResourceUtils.getDimen((int)R.dimen.game_back_left_margin);
            int backPaddingTopBottom = ResolutionUtils.dip2Px((float)5.0f);
            RelativeLayout.LayoutParams backLayoutParams = new RelativeLayout.LayoutParams(iconsize - backPaddingTopBottom, iconsize - backPaddingTopBottom);
            this.mBackIcon = new YYImageView(context);
            this.mBackIcon.setId(R.id.top_bar_back);
            this.mBackIcon.setContentDescription((CharSequence)"back");
            if (LanguageUtils.isRtl()) {
                backLayoutParams.setMargins(0, 0, backleftMargin, 0);
            } else {
                backLayoutParams.setMargins(backleftMargin, 0, 0, 0);
            }
            backLayoutParams.addRule(15);
            if (Build.VERSION.SDK_INT >= 17) {
                backLayoutParams.addRule(20);
            }
            backLayoutParams.addRule(9);
            this.mBackIcon.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.nav_back_round_white));
            this.mBackIcon.setLayoutParams((ViewGroup.LayoutParams)backLayoutParams);
            this.mContainer.addView((View)this.mBackIcon);
            this.mBackIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VerTopBar.this.mUICallBack.onBackClick();
                }
            });
            int leftmargin = ResourceUtils.getDimen((int)R.dimen.game_left_user_left_margin);
            RelativeLayout.LayoutParams leftlayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            this.mLeftUserView = new LeftUserInfoView(context, this.mClickLisenter);
            this.mMicIcon = new YYImageView(context);
            this.mMicIcon.setId(R.id.top_bar_mic);
            if (LanguageUtils.isRtl()) {
                leftlayoutParams.addRule(1, this.mMicIcon.getId());
            } else {
                leftlayoutParams.addRule(1, this.mBackIcon.getId());
            }
            leftlayoutParams.addRule(15);
            leftlayoutParams.setMargins(leftmargin, 0, 0, 0);
            this.mLeftUserView.setLayoutParams((ViewGroup.LayoutParams)leftlayoutParams);
            this.mContainer.addView((View)this.mLeftUserView);
            this.mCenterLogo = new YYImageView(context);
            this.mCenterLogo.setId(R.id.game_center_logo);
            RelativeLayout.LayoutParams centerlogo = new RelativeLayout.LayoutParams(-2, -2);
            centerlogo.addRule(13);
            this.mCenterLogo.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.game_small_logo));
            this.mCenterLogo.setLayoutParams((ViewGroup.LayoutParams)centerlogo);
            this.mContainer.addView((View)this.mCenterLogo);
            int micRightIcon = ResourceUtils.getDimen((int)R.dimen.game_mic_right_margin);
            RelativeLayout.LayoutParams micLayoutParams = new RelativeLayout.LayoutParams(iconsize, iconsize);
            if (LanguageUtils.isRtl()) {
                micLayoutParams.setMargins(micRightIcon, 0, 0, 0);
            } else {
                micLayoutParams.setMargins(0, 0, micRightIcon, 0);
            }
            if (Build.VERSION.SDK_INT >= 17) {
                micLayoutParams.addRule(21);
            }
            micLayoutParams.addRule(11);
            micLayoutParams.addRule(15);
            this.mMicIcon.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.btn_mic_selector));
            this.mMicIcon.setLayoutParams((ViewGroup.LayoutParams)micLayoutParams);
            this.mContainer.addView((View)this.mMicIcon);
            this.mMicIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MikeDeviceFilterUtils.needClickDelay()) {
                        return;
                    }
                    VerTopBar.this.mUICallBack.onMicClick();
                    if (v.isSelected()) {
                        v.setSelected(false);
                    }
                }
            });
            int rightMarginright = ResourceUtils.getDimen((int)R.dimen.game_right_user_right_margin);
            RelativeLayout.LayoutParams layoutParamsRight = new RelativeLayout.LayoutParams(-2, -2);
            this.mRigthUserView = new RightUserInfoView(context, this.mClickLisenter);
            layoutParamsRight.setMargins(0, 0, rightMarginright, 0);
            if (LanguageUtils.isRtl()) {
                layoutParamsRight.addRule(0, this.mBackIcon.getId());
            } else {
                layoutParamsRight.addRule(0, this.mMicIcon.getId());
            }
            layoutParamsRight.addRule(15);
            this.mRigthUserView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsRight);
            this.mContainer.addView((View)this.mRigthUserView);
        }
        return this.mContainer;
    }

    @Override
    public void updateMyInfoView(UserInfoKS userInfoBean) {
        this.mLeftUserView.updateView(userInfoBean);
        if (userInfoBean == null) {
            return;
        }
        final long uid = userInfoBean.uid;
        this.mLeftUserView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerTopBar.this.mUICallBack.onUserClick(uid);
            }
        });
    }

    @Override
    public void updateOtherInfoView(UserInfoKS userInfoBean) {
        this.mRigthUserView.updateView(userInfoBean);
        if (userInfoBean == null) {
            return;
        }
        final long uid = userInfoBean.uid;
        this.mRigthUserView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerTopBar.this.mUICallBack.onUserClick(uid);
            }
        });
    }

    @Override
    public void updateMicView(boolean voiceState) {
        this.mMicIcon.setActivated(voiceState);
    }

    @Override
    public void updateLeftVoice(boolean isSpeaking) {
        if (this.mLeftUserView != null) {
            if (isSpeaking) {
                this.mLeftUserView.setMicStatusSpeaking();
            } else {
                this.mLeftUserView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateRightVoice(boolean isSpeaking) {
        if (this.mRigthUserView != null) {
            if (isSpeaking && this.mIsTargetVoiceOpen && this.mIsMyVoiceOpen) {
                this.mRigthUserView.setMicStatusSpeaking();
            } else {
                this.mRigthUserView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateMicStatusView(long uid, boolean isOpen) {
        if (uid == AccountUtil.getUid()) {
            this.mIsMyVoiceOpen = isOpen;
            if (this.mLeftUserView == null) {
                return;
            }
            if (isOpen) {
                this.mLeftUserView.setMicStatusOpen();
            } else {
                this.mLeftUserView.setMicStatusClose();
            }
        } else {
            this.mIsTargetVoiceOpen = isOpen;
            if (this.mRigthUserView == null) {
                return;
            }
            if (isOpen) {
                this.mRigthUserView.setMicStatusOpen();
            } else {
                this.mRigthUserView.setMicStatusClose();
            }
        }
    }

    @Override
    public void showBackBtn(boolean isHide) {
        if (this.mBackIcon == null) {
            return;
        }
        if (isHide) {
            this.mBackIcon.setVisibility(0);
        } else {
            this.mBackIcon.setVisibility(8);
        }
    }

    @Override
    public void showMicBtn(boolean isShow) {
        if (this.mMicIcon == null) {
            return;
        }
        if (isShow) {
            this.mMicIcon.setVisibility(0);
        } else {
            this.mMicIcon.setVisibility(8);
        }
    }

    @Override
    public void updateOtherHeadFrameType(String headFrameUrl) {
        if (this.mRigthUserView != null) {
            this.mRigthUserView.updateHeadFrameType(headFrameUrl);
        }
    }

    @Override
    public void updateMyHeadFrameType(String headFrameUrl) {
        if (this.mLeftUserView != null) {
            this.mLeftUserView.updateHeadFrameType(headFrameUrl);
        }
    }
}

