/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.topbar;

import android.content.Context;
import android.view.View;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.game.module.gameroom.topbar.BaseTopBar;
import com.yy.game.module.gameroom.topbar.BaseTopBarController;
import com.yy.game.module.gameroom.topbar.CustomerTopBar;
import com.yy.game.module.gameroom.topbar.GamePkTopBar;
import com.yy.game.module.gameroom.topbar.HorTopBar;
import com.yy.game.module.gameroom.topbar.ITopBarItemViewOnClick;
import com.yy.game.module.gameroom.topbar.ITopBarUiCallback;
import com.yy.game.module.gameroom.topbar.VerTopBar;
import com.yy.hiyo.game.base.bean.GameInfo;

public class TopBarController
extends BaseTopBarController<GamePkTopBar>
implements ITopBarItemViewOnClick {
    private static final String TAG = "TopBarController";

    public TopBarController(ITopBarUiCallback callback2, Environment env) {
        super(callback2, env);
        this.mTopBarCallback = callback2;
    }

    @Override
    public View getTopBar(GameInfo gameinfo) {
        if (gameinfo == null) {
            MLog.warn((Object)TAG, (String)"create top bar with template is null", (Object[])new Object[0]);
            return new CustomerTopBar(this).getView((Context)this.mContext);
        }
        this.mCurrentGame = gameinfo;
        View resultView = null;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"create top bar with mCurrentType type: %s, mCurrentTemplate: %s", (Object[])new Object[]{gameinfo.toString(), this.mCurrentGame.toString()});
        }
        GamePkTopBar topBar = null;
        if (gameinfo.getRoomTemplate() == 1) {
            topBar = (GamePkTopBar)this.mTopBars.get(gameinfo.getScreenDire());
            if (topBar == null) {
                if (gameinfo.getScreenDire() == 1) {
                    topBar = new VerTopBar(this);
                } else if (gameinfo.getScreenDire() == 2) {
                    topBar = new HorTopBar(this);
                }
                this.mTopBars.put(gameinfo.getScreenDire(), topBar);
            }
        } else {
            topBar = new CustomerTopBar(this);
        }
        resultView = ((BaseTopBar)topBar).getView((Context)this.mContext);
        this.mCurrentTopBar = topBar;
        return resultView;
    }

    @Override
    public View getTopBar() {
        View resultView = null;
        CustomerTopBar topBar = null;
        topBar = new CustomerTopBar(this);
        this.mCurrentTopBar = topBar;
        resultView = ((BaseTopBar)topBar).getView((Context)this.mContext);
        return resultView;
    }

    public void updateLeftUser(UserInfoKS userInfoBean) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).updateMyInfoView(userInfoBean);
        }
    }

    public void updateRightUser(UserInfoKS userInfoBean) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).updateOtherInfoView(userInfoBean);
        }
    }

    public void updateLeftVoice(boolean isSpeaking) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).updateLeftVoice(isSpeaking);
        }
    }

    public void showBackBtn(boolean isShow) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).showBackBtn(isShow);
        }
    }

    public void showMicBtn(boolean isShow) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).showMicBtn(isShow);
        }
    }

    public void updateRightVoice(boolean isSpeaking) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).updateRightVoice(isSpeaking);
        }
    }

    public void updateMicView(boolean voiceState) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).updateMicView(voiceState);
        }
    }

    public void updateMicStatusView(long uid, boolean isOpen) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).updateMicStatusView(uid, isOpen);
        }
    }

    public void updateOtherHeadFrameType(String headFrameUrl) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).updateOtherHeadFrameType(headFrameUrl);
        }
    }

    public void updateMyHeadFrameType(String headFrameUrl) {
        if (this.mCurrentTopBar != null) {
            ((GamePkTopBar)this.mCurrentTopBar).updateMyHeadFrameType(headFrameUrl);
        }
    }

    @Override
    public void onBackClick() {
        if (this.mTopBarCallback != null) {
            this.mTopBarCallback.onBackClick();
        }
    }

    @Override
    public void onMicClick() {
        if (this.mTopBarCallback != null) {
            this.mTopBarCallback.onMicClick();
        }
    }

    @Override
    public void onUserClick(long uid) {
        if (this.mTopBarCallback != null) {
            this.mTopBarCallback.onUserClick(uid);
        }
    }

    public BaseTopBar getmCurrentTopBar() {
        return this.mCurrentTopBar;
    }
}

