/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.topbar;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.MikeDeviceFilterUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.module.gameroom.topbar.BaseInfoView;
import com.yy.game.module.gameroom.topbar.GamePkTopBar;
import com.yy.game.module.gameroom.topbar.ITopBarItemViewOnClick;
import com.yy.game.module.gameroom.topbar.LeftUserInfoView;
import com.yy.game.module.gameroom.topbar.RightUserInfoView;

public class HorTopBar
extends GamePkTopBar {
    private static final int USERNAME_MAXWIDTH = 115;
    private RelativeLayout mContainer;
    private ITopBarItemViewOnClick mClickLisenter;
    private BaseInfoView mLeftUserView;
    private BaseInfoView mRigthUserView;
    private YYImageView mBackIcon;
    private YYImageView mMicIcon;
    private YYImageView mCenterLogo;
    private boolean mIsMyVoiceOpen = false;
    private boolean mIsTargetVoiceOpen = false;

    public HorTopBar(ITopBarItemViewOnClick click) {
        super(click);
    }

    @Override
    public View getView(Context context) {
        if (this.mContainer == null) {
            this.mContainer = new YYRelativeLayout(context);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            if (Build.VERSION.SDK_INT >= 17) {
                layoutParams.setLayoutDirection(0);
            }
            layoutParams.setMargins(0, ResourceUtils.getDimen((int)R.dimen.hor_game_top_padding), 0, 0);
            this.mContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            int iconsize = ResourceUtils.getDimen((int)R.dimen.game_icon_size);
            int backleftMargin = ResourceUtils.getDimen((int)R.dimen.game_back_left_margin);
            int backPaddingTopBottom = ResolutionUtils.dip2Px((float)5.0f);
            RelativeLayout.LayoutParams backLayoutParams = new RelativeLayout.LayoutParams(iconsize - backPaddingTopBottom, iconsize - backPaddingTopBottom);
            this.mBackIcon = new YYImageView(context);
            this.mBackIcon.setId(R.id.top_bar_back);
            this.mBackIcon.setContentDescription((CharSequence)"back");
            backLayoutParams.setMargins(backleftMargin, 0, 0, 0);
            this.mBackIcon.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.nav_back_round_white));
            this.mBackIcon.setLayoutParams((ViewGroup.LayoutParams)backLayoutParams);
            this.mContainer.addView((View)this.mBackIcon);
            this.mBackIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (HorTopBar.this.mUICallBack != null) {
                        HorTopBar.this.mUICallBack.onBackClick();
                    }
                }
            });
            this.mCenterLogo = new YYImageView(context);
            this.mCenterLogo.setId(R.id.game_center_logo);
            RelativeLayout.LayoutParams centerlogo = new RelativeLayout.LayoutParams(-2, -2);
            centerlogo.addRule(13);
            this.mCenterLogo.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.game_small_logo));
            this.mCenterLogo.setLayoutParams((ViewGroup.LayoutParams)centerlogo);
            this.mContainer.addView((View)this.mCenterLogo);
            RelativeLayout.LayoutParams leftlayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            this.mLeftUserView = new LeftUserInfoView(context, this.mClickLisenter);
            this.mLeftUserView.setNameTextMaxWidth(ResolutionUtils.dip2Px((float)115.0f));
            leftlayoutParams.addRule(1, this.mBackIcon.getId());
            leftlayoutParams.addRule(15);
            leftlayoutParams.setMargins(0, 0, ResourceUtils.getDimen((int)R.dimen.game_left_margin_center), 0);
            this.mLeftUserView.setLayoutParams((ViewGroup.LayoutParams)leftlayoutParams);
            this.mContainer.addView((View)this.mLeftUserView);
            int micRightIcon = ResourceUtils.getDimen((int)R.dimen.game_mic_right_margin);
            this.mMicIcon = new YYImageView(context);
            this.mMicIcon.setId(R.id.top_bar_mic);
            RelativeLayout.LayoutParams micLayoutParams = new RelativeLayout.LayoutParams(iconsize, iconsize);
            micLayoutParams.setMargins(0, 0, micRightIcon, 0);
            micLayoutParams.addRule(11);
            if (Build.VERSION.SDK_INT >= 17) {
                micLayoutParams.addRule(21);
            }
            micLayoutParams.addRule(15);
            this.mMicIcon.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.btn_mic_selector));
            this.mMicIcon.setLayoutParams((ViewGroup.LayoutParams)micLayoutParams);
            this.mMicIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MikeDeviceFilterUtils.needClickDelay()) {
                        return;
                    }
                    HorTopBar.this.mUICallBack.onMicClick();
                    if (v.isSelected()) {
                        v.setSelected(false);
                    }
                }
            });
            this.mContainer.addView((View)this.mMicIcon);
            RelativeLayout.LayoutParams layoutParamsRight = new RelativeLayout.LayoutParams(-2, -2);
            this.mRigthUserView = new RightUserInfoView(context, this.mClickLisenter);
            this.mRigthUserView.setNameTextMaxWidth(ResolutionUtils.dip2Px((float)115.0f));
            layoutParamsRight.setMargins(ResourceUtils.getDimen((int)R.dimen.game_left_margin_center), 0, 0, 0);
            layoutParamsRight.addRule(0, this.mMicIcon.getId());
            if (Build.VERSION.SDK_INT >= 17) {
                layoutParamsRight.addRule(16, this.mMicIcon.getId());
            }
            layoutParamsRight.addRule(15);
            this.mRigthUserView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsRight);
            this.mContainer.addView((View)this.mRigthUserView);
        }
        return this.mContainer;
    }

    @Override
    public void updateMyInfoView(UserInfoKS userInfoBean) {
        this.mLeftUserView.updateView(userInfoBean);
        if (userInfoBean == null) {
            return;
        }
        final long uid = userInfoBean.uid;
        this.mLeftUserView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HorTopBar.this.mUICallBack.onUserClick(uid);
            }
        });
    }

    @Override
    public void updateOtherInfoView(UserInfoKS userInfoBean) {
        this.mRigthUserView.updateView(userInfoBean);
        if (userInfoBean == null) {
            return;
        }
        final long uid = userInfoBean.uid;
        this.mRigthUserView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HorTopBar.this.mUICallBack.onUserClick(uid);
            }
        });
    }

    @Override
    public void updateMicView(boolean voiceState) {
        this.mMicIcon.setActivated(voiceState);
    }

    @Override
    public void updateLeftVoice(boolean isSpeaking) {
        if (this.mLeftUserView != null) {
            if (isSpeaking) {
                this.mLeftUserView.setMicStatusSpeaking();
            } else {
                this.mLeftUserView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateRightVoice(boolean isSpeaking) {
        if (this.mRigthUserView != null) {
            if (isSpeaking && this.mIsTargetVoiceOpen && this.mIsMyVoiceOpen) {
                this.mRigthUserView.setMicStatusSpeaking();
            } else {
                this.mRigthUserView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateMicStatusView(long uid, boolean isOpen) {
        if (uid == AccountUtil.getUid()) {
            this.mIsMyVoiceOpen = isOpen;
            if (this.mLeftUserView == null) {
                return;
            }
            if (isOpen) {
                this.mLeftUserView.setMicStatusOpen();
            } else {
                this.mLeftUserView.setMicStatusClose();
            }
        } else {
            this.mIsTargetVoiceOpen = isOpen;
            if (this.mRigthUserView == null) {
                return;
            }
            if (isOpen) {
                this.mRigthUserView.setMicStatusOpen();
            } else {
                this.mRigthUserView.setMicStatusClose();
            }
        }
    }

    @Override
    public void showBackBtn(boolean isHide) {
        if (this.mBackIcon == null) {
            return;
        }
        if (isHide) {
            this.mBackIcon.setVisibility(0);
        } else {
            this.mBackIcon.setVisibility(8);
        }
    }

    @Override
    public void showMicBtn(boolean isShow) {
        if (this.mMicIcon == null) {
            return;
        }
        if (isShow) {
            this.mMicIcon.setVisibility(0);
        } else {
            this.mMicIcon.setVisibility(8);
        }
    }

    @Override
    public void updateOtherHeadFrameType(String headFrameUrl) {
        if (this.mRigthUserView != null) {
            this.mRigthUserView.updateHeadFrameType(headFrameUrl);
        }
    }

    @Override
    public void updateMyHeadFrameType(String headFrameUrl) {
        if (this.mLeftUserView != null) {
            this.mLeftUserView.updateHeadFrameType(headFrameUrl);
        }
    }
}

